/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.utils.sys.TimeUtil;

public class CustomBaseChatItem
extends AdapterSuperBaseView<ChatListAdapterPresenter, TalkMessageBean>
implements AdapterBaseView<ChatListAdapterPresenter, TalkMessageBean> {
    public static final long TIME_DIFFERENCE = 300000L;
    private TextView mTimeLineTv;
    private LinearLayout newMessageRemind;

    @Override
    protected void injectView() {
        super.injectView();
        this.mTimeLineTv = (TextView)this.findViewById(R.id.tv_timeLine);
        this.newMessageRemind = (LinearLayout)this.findViewById(R.id.no_read_remaind);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (position == 0) {
            this.setTimeLineVisible(dataSource.getShowTime());
        } else {
            TalkMessageBean lastMessage = ((ChatListAdapterPresenter)this.getPresenter()).getTalkMessage(this.curPosition);
            if (lastMessage != null && dataSource.getShowTime() - lastMessage.getShowTime() > 300000L) {
                this.mTimeLineTv.setVisibility(0);
                this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(dataSource.getShowTime()));
            } else {
                this.mTimeLineTv.setVisibility(8);
            }
        }
        if (dataSource.isRemind()) {
            this.newMessageRemind.setVisibility(0);
        } else {
            this.newMessageRemind.setVisibility(8);
        }
        if (dataSource.getMessageState() < 4) {
            ((ChatListAdapterPresenter)this.getPresenter()).sendReadReceipt(dataSource);
        }
    }

    private void setTimeLineVisible(long time) {
        this.mTimeLineTv.setVisibility(0);
        this.mTimeLineTv.setText((CharSequence)TimeUtil.convertChatTime(time));
    }
}

