/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.base.frame.view.ActivitySuperBaseView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.adapter.FilePreviewAdapter;
import com.xdja.im.uikit.ui.presenter.FilePreviewPresenter;
import com.xdja.im.uikit.ui.view.BaseFilePreview;
import com.xdja.im.uikit.ui.view.vu.FilePreviewVu;

public class ViewFilePreview
extends ActivitySuperBaseView<FilePreviewPresenter>
implements FilePreviewVu {
    private ViewPager mViewPager;
    private ProgressBar mLoadingPbar;
    private TextView mEmptyTv;
    private FilePreviewAdapter mPagerAdapter;
    private int mCurPos;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_file_preview;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mViewPager = (ViewPager)this.findViewById(R.id.pager_file_preview);
        this.mLoadingPbar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mEmptyTv = (TextView)this.findViewById(R.id.tv_empty);
        this.mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ViewFilePreview.this.mPagerAdapter.reFreshPage(position);
            }

            public void onPageScrollStateChanged(int state) {
                if (state == 1) {
                    ViewFilePreview.this.mCurPos = ViewFilePreview.this.mViewPager.getCurrentItem();
                } else if (state == 2 && ViewFilePreview.this.mCurPos != ViewFilePreview.this.mViewPager.getCurrentItem()) {
                    ViewFilePreview.this.mPagerAdapter.onPageSelected(ViewFilePreview.this.mCurPos, ViewFilePreview.this.mViewPager.getCurrentItem());
                    ViewFilePreview.this.mCurPos = ViewFilePreview.this.mViewPager.getCurrentItem();
                }
            }
        });
        this.mEmptyTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewFilePreview.this.getActivity().finish();
            }
        });
    }

    @Override
    public void setAdapter(FilePreviewAdapter adapter) {
        this.mPagerAdapter = adapter;
        this.mViewPager.setAdapter((PagerAdapter)adapter);
    }

    @Override
    public void setCurrentPosition(int position) {
        this.mViewPager.setCurrentItem(position, false);
    }

    @Override
    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    @Override
    public void setProgressVisibility(int visibility) {
        this.mLoadingPbar.setVisibility(visibility);
    }

    @Override
    public void showEmptyView() {
        this.mViewPager.setVisibility(8);
        this.mEmptyTv.setVisibility(0);
    }

    @Override
    public void fileDownloadFinish(int position) {
        ((BaseFilePreview)this.mPagerAdapter.adapterVus.get(position)).onFileDownloadFinish();
    }
}

