/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseSendItem;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewSendFileItem
extends BaseSendItem {
    private ImageView mLogoImg;
    private TextView mFileNameTv;
    private TextView mFileSizeTv;
    private ProgressBar mLoadingPBar;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_file;
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        this.mLogoImg.setImageBitmap(null);
        this.mFileNameTv.setText((CharSequence)"");
        this.mFileSizeTv.setText((CharSequence)"");
        this.mLoadingPBar.setProgress(0);
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.mLogoImg = (ImageView)view.findViewById(R.id.img_file_flag);
        this.mFileNameTv = (TextView)view.findViewById(R.id.tv_file_name);
        this.mFileSizeTv = (TextView)view.findViewById(R.id.tv_file_size);
        this.mLoadingPBar = (ProgressBar)view.findViewById(R.id.pbar_file_progress);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NormalFileInfo fileInfo = (NormalFileInfo)((TalkMessageBean)ViewSendFileItem.this.dataSource).getFileInfo();
                if (fileInfo == null) {
                    LogUtil.e("ERROR: start open file, but file info is null.");
                    return;
                }
                if (FileUtils.getFileExistAndComplete(fileInfo.getFilePath(), fileInfo.getFileState())) {
                    ((ChatListAdapterPresenter)ViewSendFileItem.this.getPresenter()).openNormalFile((TalkMessageBean)ViewSendFileItem.this.dataSource);
                } else {
                    ((ChatListAdapterPresenter)ViewSendFileItem.this.getPresenter()).loadNormalFile((TalkMessageBean)ViewSendFileItem.this.dataSource);
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        NormalFileInfo normalFileInfo = (NormalFileInfo)dataSource.getFileInfo();
        if (normalFileInfo == null) {
            LogUtil.e("ERROR: Send file info is null.");
            return;
        }
        this.mFileNameTv.setText((CharSequence)normalFileInfo.getFileName());
        this.mFileSizeTv.setText((CharSequence)FileSizeUtils.formatFileSize(normalFileInfo.getFileSize()));
        this.mLogoImg.setImageResource(FileUtils.getIconWithSuffix(normalFileInfo.getFilePath()));
        if (dataSource.getMessageState() == 1) {
            this.mLoadingPBar.setVisibility(0);
            this.mLoadingPBar.setProgress((int)((float)this.getTranslateSize(normalFileInfo) * 100.0f / (float)normalFileInfo.getFileSize()));
        } else {
            this.mLoadingPBar.setVisibility(8);
        }
    }

    private long getTranslateSize(NormalFileInfo fileInfo) {
        return Math.max(TranslateInfoUtil.getTranslateSize(fileInfo.getTalkMessageId()), fileInfo.getTranslateSize());
    }
}

