/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.view.BaseChatItem;
import com.xdja.im.uikit.ui.view.BaseSendItem;
import com.xdja.im.uikit.utils.RecognizeHyperlink;

public class ViewSendTextItem
extends BaseSendItem {
    private TextView mContentTv;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_text;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mContentTv = (TextView)this.findViewById(R.id.tv_content);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.mContentTv.setText((CharSequence)EmotionUtils.formatNormalSpanContent(dataSource.getContent(), (Context)this.getActivity()));
        RecognizeHyperlink.getInstance().recognizeHyperlinks(new BaseChatItem.MyLongClick(){

            @Override
            public void onLongClick() {
                ViewSendTextItem.this.showPopDialog();
            }
        }, this.mContentTv, this.getActivity(), 7);
    }

    @Override
    protected void setTxtContentColor(int color2) {
        super.setTxtContentColor(color2);
        this.mContentTv.setTextColor(color2);
    }
}

