/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseSendItem;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.CircleProgressBar;

public class ViewSendVideoItem
extends BaseSendItem {
    private ChatImageView mChatImage;
    private ImageView mPlayFlagImg;
    private CircleProgressBar mLoadingPBar;
    private TextView mVideoTimeTv;
    private ProgressBar loadProgressBar;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_video;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatImage = (ChatImageView)this.findViewById(R.id.img_send_image);
        this.mPlayFlagImg = (ImageView)this.findViewById(R.id.img_play_flag);
        this.mLoadingPBar = (CircleProgressBar)this.findViewById(R.id.pbar_video_loading);
        this.mVideoTimeTv = (TextView)this.findViewById(R.id.tv_video_duration);
        this.loadProgressBar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewSendVideoItem.this.getPresenter()).previewVideo((TalkMessageBean)ViewSendVideoItem.this.dataSource);
            }
        });
        this.mPlayFlagImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewSendVideoItem.this.getPresenter()).previewVideo((TalkMessageBean)ViewSendVideoItem.this.dataSource);
            }
        });
        this.mPlayFlagImg.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return ViewSendVideoItem.this.showPopDialog();
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        VideoFileInfo videoFileInfo = (VideoFileInfo)dataSource.getFileInfo();
        if (videoFileInfo == null) {
            LogUtil.e("Video file info is null error.");
            return;
        }
        this.mPlayFlagImg.setVisibility(0);
        this.mVideoTimeTv.setVisibility(0);
        this.updateProgress(videoFileInfo.getTranslatePercent());
        this.loadImage(videoFileInfo);
        this.mVideoTimeTv.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_video_duration), videoFileInfo.getAmountOfTime() / 60, videoFileInfo.getAmountOfTime() % 60));
    }

    private void loadImage(VideoFileInfo fileInfo) {
        int state = fileInfo.getFileState();
        switch (state) {
            case 7: {
                this.loadFirstImage(fileInfo);
                break;
            }
            case 10: {
                this.loadFirstImage(fileInfo);
                break;
            }
            case 6: {
                this.loadFirstImage(fileInfo);
                break;
            }
            case 8: {
                this.loadFirstImage(fileInfo);
                break;
            }
            case 9: {
                this.loadFirstImage(fileInfo);
                break;
            }
            case 2: {
                this.loadFirstImage(fileInfo);
                break;
            }
            case 5: {
                this.updateLoadProgress(false);
                this.mVideoTimeTv.setVisibility(8);
                this.mPlayFlagImg.setVisibility(8);
                this.mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
                break;
            }
            case 1: {
                ((ChatListAdapterPresenter)this.getPresenter()).downLoadFile((TalkMessageBean)this.dataSource, fileInfo);
                this.updateLoadProgress(true);
                break;
            }
            case 3: {
                ((ChatListAdapterPresenter)this.getPresenter()).downLoadFile((TalkMessageBean)this.dataSource, fileInfo);
                this.updateLoadProgress(true);
                break;
            }
            case 4: {
                ((ChatListAdapterPresenter)this.getPresenter()).downLoadFile((TalkMessageBean)this.dataSource, fileInfo);
                this.updateLoadProgress(true);
            }
        }
    }

    private void loadFirstImage(VideoFileInfo fileInfo) {
        if (FileUtils.isFileExists(fileInfo.getFilePath())) {
            this.updateLoadProgress(false);
            this.mChatImage.loadImage(fileInfo.getFilePath(), 1);
        } else {
            this.updateLoadProgress(false);
            this.mVideoTimeTv.setVisibility(8);
            this.mPlayFlagImg.setVisibility(8);
            this.mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
        }
    }

    private void updateProgress(int percent) {
        if (((TalkMessageBean)this.dataSource).getMessageState() == 1) {
            this.mPlayFlagImg.setVisibility(8);
            this.mLoadingPBar.setVisibility(0);
            this.mLoadingPBar.setProgress(percent);
        } else {
            this.mPlayFlagImg.setVisibility(0);
            this.mLoadingPBar.setVisibility(8);
        }
    }

    private void updateLoadProgress(boolean update) {
        if (update) {
            this.mPlayFlagImg.setVisibility(8);
            this.mChatImage.setVisibility(8);
            this.loadProgressBar.setVisibility(0);
        } else {
            this.mPlayFlagImg.setVisibility(0);
            this.mChatImage.setVisibility(0);
            this.loadProgressBar.setVisibility(8);
        }
    }
}

