/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.lib.filemanage.util.NetworkUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import com.xdja.im.uikit.ui.adapter.SessionListAdapter;
import com.xdja.im.uikit.ui.dialog.BaseRecyclerListDialog;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import com.xdja.im.uikit.ui.view.vu.SessionListVu;
import com.xdja.im.uikit.utils.FunctionUtils;
import com.xdja.im.uikit.utils.NetworkHelper;
import java.util.ArrayList;
import java.util.List;

public class ViewSessionList
extends FragmentSuperBaseView<SessionListPresenter>
implements SessionListVu {
    private ListView mChatSessionList;
    private ProgressBar mLoadingPBar;
    private TextView mEmptyHintTv;
    private BaseRecyclerListDialog mPopDialog;
    private LinearLayout networkStateLineaLayout;
    private TextView networkStateTv;
    protected List<ImOption> mImOptions = new ArrayList<ImOption>();

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_fragment_session_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatSessionList = (ListView)this.findViewById(R.id.rv_session_list);
        this.mLoadingPBar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mEmptyHintTv = (TextView)this.findViewById(R.id.tv_empty);
        this.mChatSessionList.setEmptyView((View)this.mEmptyHintTv);
        this.networkStateLineaLayout = (LinearLayout)this.findViewById(R.id.network_state_view);
        this.networkStateTv = (TextView)this.findViewById(R.id.networkstate_tv);
        this.changeNetworkViewState(NetworkHelper.getHelper().getNetState());
        this.mPopDialog = new BaseRecyclerListDialog(this.getContext()){

            @Override
            public List<ImOption> getOptions() {
                return ViewSessionList.this.buildImOptions();
            }
        };
        this.setListener();
    }

    private void setListener() {
        this.mChatSessionList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ((SessionListPresenter)ViewSessionList.this.getPresenter()).onListItemClick(position);
            }
        });
        this.mChatSessionList.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                return ViewSessionList.this.showPopDialog(position);
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseRecyclerListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                ViewSessionList.this.dismissPopDialog();
                switch (option.getOptionType()) {
                    case 1: {
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).deleteSession(itemPosition);
                        break;
                    }
                    case 2: {
                        if (!NetworkUtils.checkNetworkState(ViewSessionList.this.getContext())) break;
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).setSessionTop(itemPosition);
                        break;
                    }
                    case 3: {
                        if (!NetworkUtils.checkNetworkState(ViewSessionList.this.getContext())) break;
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).deleteSessionTop(itemPosition);
                        break;
                    }
                    case 4: {
                        if (!NetworkUtils.checkNetworkState(ViewSessionList.this.getContext())) break;
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).setDisturb(itemPosition);
                        break;
                    }
                    case 5: {
                        if (!NetworkUtils.checkNetworkState(ViewSessionList.this.getContext())) break;
                        ((SessionListPresenter)ViewSessionList.this.getPresenter()).deleteDisturb(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void setAdapter(SessionListAdapter adapter) {
        this.mChatSessionList.setAdapter((ListAdapter)adapter);
        this.mEmptyHintTv.setVisibility(8);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        this.mLoadingPBar.setVisibility(visibility);
    }

    private List<ImOption> buildImOptions() {
        this.mImOptions.add(new ImOption(1, this.getStringRes(R.string.im_uikit_session_option_delete)));
        this.mImOptions.add(new ImOption(2, this.getStringRes(R.string.im_uikit_session_option_settop)));
        this.mImOptions.add(new ImOption(3, this.getStringRes(R.string.im_uikit_session_option_canceltop)));
        this.mImOptions.add(new ImOption(4, this.getStringRes(R.string.im_uikit_session_option_opendisturb)));
        this.mImOptions.add(new ImOption(5, this.getStringRes(R.string.im_uikit_session_option_closedisturb)));
        return this.mImOptions;
    }

    private boolean showPopDialog(int position) {
        ArrayList<ImOption> data = new ArrayList<ImOption>();
        TalkSessionBean talkSessionBean = ((SessionListPresenter)this.getPresenter()).isSessionTalk(position);
        if (talkSessionBean == null) {
            return false;
        }
        data.add(this.mImOptions.get(0));
        if (talkSessionBean.getParam() == null || !talkSessionBean.getParam().isTop()) {
            data.add(this.mImOptions.get(1));
        } else {
            data.add(this.mImOptions.get(2));
        }
        if (!talkSessionBean.getTalkerAccount().equals("20002")) {
            if (talkSessionBean.getParam() == null || !talkSessionBean.getParam().isDisturb()) {
                data.add(this.mImOptions.get(3));
            } else {
                data.add(this.mImOptions.get(4));
            }
        }
        this.mPopDialog.addData(data);
        this.mPopDialog.show(position);
        return true;
    }

    protected void dismissPopDialog() {
        if (this.mPopDialog != null) {
            this.mPopDialog.dismiss();
        }
    }

    @Override
    public void changeViewSate(int state) {
        this.changeNetworkViewState(state);
        if (!NetworkHelper.getHelper().isFirstNotice() && FunctionUtils.isAppOnForeground((Context)this.getActivity())) {
            if (state == 2) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Network unavailable", (int)1).show();
            } else if (state == 1) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Unable to access the server", (int)1).show();
            }
        }
    }

    private void changeNetworkViewState(int flag) {
        switch (flag) {
            case 2: {
                String tips = this.getActivity().getResources().getString(R.string.im_uikit_network_disabled);
                this.networkStateTv.setText((CharSequence)tips);
                this.networkStateLineaLayout.setVisibility(0);
                break;
            }
            case 1: {
                String tips = this.getActivity().getResources().getString(R.string.im_uikit_network_no_server);
                this.networkStateTv.setText((CharSequence)tips);
                this.networkStateLineaLayout.setVisibility(0);
                break;
            }
            case 0: {
                this.networkStateLineaLayout.setVisibility(8);
                break;
            }
        }
    }
}

