/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.ImageCache;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.ScreenUtil;

@SuppressLint(value={"AppCompatCustomView"})
public class ChatImageView
extends ImageView {
    private static final int BASE_DPI = 140;
    private final int IMAGE_MAX_WIDTH;
    private final int IMAGE_MAX_HEIGHT;
    private int type;

    public ChatImageView(Context context) {
        this(context, null);
    }

    public ChatImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChatImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.IMAGE_MAX_HEIGHT = this.IMAGE_MAX_WIDTH = ScreenUtil.dp2px(context, 140.0f);
    }

    public void loadImage(String url, int type) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.setImageResource(R.mipmap.im_uikit_pic_default);
            return;
        }
        this.type = type;
        boolean isVideo = IMFileUtils.isVideoFileType(url);
        Bitmap bitmap = null;
        if (isVideo) {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(url);
            bitmap = mmr.getFrameAtTime();
            mmr.release();
        } else {
            bitmap = ImageCache.getInstance().get(url);
            if (bitmap == null) {
                bitmap = this.createScaledBitmap(url);
                if (bitmap != null) {
                    ImageCache.getInstance().put(url, bitmap);
                } else {
                    this.setImageResource(R.mipmap.im_uikit_pic_default);
                }
            }
        }
        if (bitmap != null) {
            this.setImageBitmap(bitmap);
        }
    }

    private Bitmap createScaledBitmap(String url) {
        block7: {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)url, (BitmapFactory.Options)options);
            try {
                if (options.outWidth < this.IMAGE_MAX_WIDTH && options.outHeight < this.IMAGE_MAX_HEIGHT) {
                    return this.scaleBitmap(url, options);
                }
                if (options.outWidth > this.IMAGE_MAX_WIDTH || options.outHeight > this.IMAGE_MAX_HEIGHT) {
                    Bitmap bitmap = BitmapUtils.getZoomedDrawable(url, 1);
                    float widthRatio = (float)options.outWidth / (float)this.IMAGE_MAX_WIDTH;
                    float heightRatio = (float)options.outHeight / (float)this.IMAGE_MAX_HEIGHT;
                    float radio = Math.max(widthRatio, heightRatio);
                    int width = (int)((float)options.outWidth / radio);
                    int height = (int)((float)options.outHeight / radio);
                    if (bitmap != null) {
                        Bitmap targetBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)false);
                        if (!bitmap.equals(targetBitmap)) {
                            BitmapUtils.recycleBmp(bitmap);
                        }
                        return targetBitmap;
                    }
                    break block7;
                }
                return BitmapFactory.decodeFile((String)url);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                LogUtil.d("createScaledBitmap e " + e.toString());
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap scaleBitmap(String url, BitmapFactory.Options options) {
        Object scaledBitmap;
        Bitmap bitmap;
        block13: {
            Bitmap bitmap2;
            block12: {
                bitmap = null;
                scaledBitmap = null;
                try {
                    int reqWidth = this.IMAGE_MAX_WIDTH;
                    int reqHeight = this.IMAGE_MAX_HEIGHT;
                    int outWidth = options.outWidth;
                    int outHeight = options.outHeight;
                    if (outWidth <= 0 || outHeight <= 0) {
                        bitmap2 = null;
                        if (scaledBitmap == null) return bitmap2;
                        if (scaledBitmap.equals(bitmap)) return bitmap2;
                        break block12;
                    }
                    bitmap = BitmapFactory.decodeFile((String)url);
                    float ratio = (float)outWidth / (float)outHeight;
                    if (ratio > 1.0f) {
                        reqHeight = (int)((float)reqWidth / ratio);
                    } else {
                        reqWidth = (int)((float)reqHeight * ratio);
                    }
                    scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)reqWidth, (int)reqHeight, (boolean)false);
                    if (scaledBitmap == null) return scaledBitmap;
                    break block13;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return scaledBitmap;
                }
            }
            BitmapUtils.recycleBmp(bitmap);
            return bitmap2;
        }
        if (scaledBitmap.equals(bitmap)) return scaledBitmap;
        BitmapUtils.recycleBmp(bitmap);
        return scaledBitmap;
        catch (OutOfMemoryError outOfMemoryError) {
            if (scaledBitmap == null) return scaledBitmap;
            if (scaledBitmap.equals(bitmap)) return scaledBitmap;
            BitmapUtils.recycleBmp(bitmap);
            return scaledBitmap;
        }
        finally {
            if (scaledBitmap != null && !scaledBitmap.equals(bitmap)) {
                BitmapUtils.recycleBmp(bitmap);
            }
        }
    }

    private Bitmap getNineBitmap(int width, int height) {
        Drawable drawable2 = null;
        if (this.type == 1) {
            drawable2 = this.getResources().getDrawable(R.drawable.im_uikit_chat_detail_web_send_default);
        } else if (this.type == 0) {
            drawable2 = this.getResources().getDrawable(R.drawable.im_uikit_chat_detial_recv_default);
        }
        if (drawable2 instanceof NinePatchDrawable) {
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, width, height);
            drawable2.draw(canvas);
            return bitmap;
        }
        return null;
    }

    public void setImageResource(int resId) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
        this.setImageBitmap(bitmap);
    }

    public void setError(int resId) {
        super.setImageResource(resId);
    }

    public void setImageBitmap(Bitmap srcBitmap) {
        if (srcBitmap == null) {
            super.setImageBitmap(null);
            return;
        }
        int width = srcBitmap.getWidth() > this.IMAGE_MAX_WIDTH ? this.IMAGE_MAX_WIDTH : srcBitmap.getWidth();
        int height = srcBitmap.getHeight() > this.IMAGE_MAX_HEIGHT ? this.IMAGE_MAX_HEIGHT : srcBitmap.getHeight();
        Bitmap destBitmap = ImageCache.getInstance().get(this.type + String.valueOf(srcBitmap.hashCode()));
        if (destBitmap == null && (destBitmap = this.getNineBitmap(width, height)) != null) {
            ImageCache.getInstance().put(this.type + String.valueOf(srcBitmap.hashCode()), destBitmap);
        }
        if (destBitmap != null && width > 0 && height > 0 && !srcBitmap.isRecycled()) {
            try {
                Bitmap output = ImageCache.getInstance().get(String.valueOf(destBitmap.hashCode()));
                if (output == null && (output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)srcBitmap.getConfig())) != null) {
                    ImageCache.getInstance().put(String.valueOf(destBitmap.hashCode()), output);
                }
                Canvas canvas = new Canvas(output);
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                canvas.drawBitmap(srcBitmap, 0.0f, 0.0f, paint);
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
                canvas.drawBitmap(destBitmap, 0.0f, 0.0f, paint);
                super.setImageBitmap(output);
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        } else {
            super.setImageBitmap(srcBitmap);
        }
    }
}

