/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.ImageCache;
import com.xdja.im.uikit.utils.gif.GifDecoder;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@SuppressLint(value={"AppCompatCustomView"})
public class GifImageView
extends ImageView
implements Runnable {
    private static final String TAG = "GifDecoderView";
    private GifDecoder gifDecoder;
    private Bitmap tmpBitmap;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private boolean animating;
    private boolean renderFrame;
    private boolean shouldClear;
    private Thread animationThread;
    private Thread toBytesThread;
    private OnFrameAvailable frameCallback = null;
    private long framesDisplayDuration = -1L;
    private OnAnimationStop animationStopCallback = null;
    private OnAnimationStart animationStartCallback = null;
    private String url;
    private byte[] bytes;
    private final Runnable loadGifImage = new Runnable(){

        @Override
        @RequiresApi(api=16)
        public void run() {
            if (GifImageView.this.setBytes(GifImageView.this.bytes)) {
                GifImageView.this.startAnimation();
            } else {
                GifImageView.this.loadImageFrame(GifImageView.this.url);
            }
        }
    };
    private final Runnable getGifBytes = new Runnable(){

        @Override
        public void run() {
            if (GifImageView.this.bytes == null) {
                File file = new File(GifImageView.this.url);
                try {
                    GifImageView.access$002(GifImageView.this, GifImageView.this.getByte(file));
                    GifImageView.this.handler.post(GifImageView.this.loadGifImage);
                }
                catch (Exception e) {
                    LogUtil.e(GifImageView.TAG, "load gif fail");
                }
            }
        }
    };
    private final Runnable updateResults = new Runnable(){

        @Override
        public void run() {
            if (GifImageView.this.animating && GifImageView.this.tmpBitmap != null) {
                GifImageView.this.setImageBitmap(GifImageView.this.tmpBitmap);
            }
        }
    };
    private final Runnable cleanupRunnable = new Runnable(){

        @Override
        public void run() {
            GifImageView.this.tmpBitmap = null;
            GifImageView.this.gifDecoder = null;
            GifImageView.this.animationThread = null;
            GifImageView.this.shouldClear = false;
            GifImageView.this.setImageBitmap(null);
        }
    };

    public GifImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GifImageView(Context context) {
        this(context, null);
    }

    public GifImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void loadImage(String url) {
        if (this.checkIsCiphert()) {
            return;
        }
        if (!this.animating) {
            this.url = url;
            this.toBytesThread = new Thread(this.getGifBytes);
            this.toBytesThread.setName("ToGifBytesThread");
            this.toBytesThread.start();
        }
    }

    public void loadImageFrame(String url) {
        if (this.checkIsCiphert()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.setImageResource(R.drawable.im_uikit_pic_default);
        } else {
            try {
                Bitmap bitmap = ImageCache.getInstance().get(url);
                if (bitmap == null || bitmap.isRecycled()) {
                    bitmap = BitmapFactory.decodeFile((String)url);
                    ImageCache.getInstance().put(url, bitmap);
                }
                super.setImageBitmap(bitmap);
            }
            catch (Exception e) {
                this.setImageResource(R.drawable.im_uikit_pic_default);
            }
        }
    }

    @RequiresApi(api=16)
    public boolean setBytes(byte[] bytes) {
        this.setBackground(null);
        this.bytes = bytes;
        if (bytes != null) {
            this.gifDecoder = new GifDecoder();
            try {
                this.gifDecoder.read(bytes);
                if (this.animating) {
                    this.startAnimationThread();
                }
                this.gotoFrame(0);
            }
            catch (Exception e) {
                this.gifDecoder = null;
                LogUtil.e(TAG, "load gif fail");
                this.setImageResource(R.drawable.im_uikit_pic_default);
                return false;
            }
        } else {
            this.animating = false;
            this.tmpBitmap = null;
        }
        return true;
    }

    public long getFramesDisplayDuration() {
        return this.framesDisplayDuration;
    }

    public void setFramesDisplayDuration(long framesDisplayDuration) {
        this.framesDisplayDuration = framesDisplayDuration;
    }

    public void startAnimation() {
        this.animating = true;
        this.startAnimationThread();
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void stopAnimation() {
        this.animating = false;
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
        if (this.toBytesThread != null) {
            this.toBytesThread.interrupt();
            this.toBytesThread = null;
        }
        if (this.gifDecoder != null) {
            this.gifDecoder.clear();
        }
        this.gifDecoder = null;
        this.bytes = null;
        this.shouldClear = false;
    }

    public void gotoFrame(int frame) {
        if (this.gifDecoder.getCurrentFrameIndex() == frame) {
            return;
        }
        if (this.gifDecoder.setFrameIndex(frame - 1) && !this.animating) {
            this.renderFrame = true;
            this.startAnimationThread();
        }
    }

    public void resetAnimation() {
        this.gifDecoder.resetLoopIndex();
        this.gotoFrame(0);
    }

    public void clear() {
        this.animating = false;
        this.renderFrame = false;
        this.shouldClear = true;
        this.stopAnimation();
        this.handler.post(this.cleanupRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByte(File file) throws Exception {
        byte[] bytes = new byte[4096];
        FileInputStream in = new FileInputStream(file.getAbsoluteFile());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = ((InputStream)in).read(bytes)) != -1) {
                out.write(bytes, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
                in = null;
            }
        }
        return out.toByteArray();
    }

    private boolean canStart() {
        return (this.animating || this.renderFrame) && this.gifDecoder != null && this.animationThread == null;
    }

    public int getGifWidth() {
        return this.gifDecoder.getWidth();
    }

    public int getGifHeight() {
        return this.gifDecoder.getHeight();
    }

    @Override
    public void run() {
        if (this.animationStartCallback != null) {
            this.animationStartCallback.onAnimationStart();
        }
        boolean advance = false;
        long frameDecodeTime = 0L;
        while (this.animating || this.renderFrame) {
            try {
                advance = this.gifDecoder.advance();
                long before = System.nanoTime();
                this.tmpBitmap = this.gifDecoder.getNextFrame();
                if (this.frameCallback != null) {
                    this.tmpBitmap = this.frameCallback.onFrameAvailable(this.tmpBitmap);
                }
                frameDecodeTime = (System.nanoTime() - before) / 1000000L;
                this.handler.post(this.updateResults);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.renderFrame = false;
            if (!this.animating || !advance) {
                this.animating = false;
                break;
            }
            try {
                int delay = this.gifDecoder.getNextDelay();
                delay = (int)((long)delay - frameDecodeTime);
                if (delay > 0) {
                    Thread.sleep(this.framesDisplayDuration > 0L ? this.framesDisplayDuration : (long)delay);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.animating) continue;
        }
        if (this.shouldClear) {
            this.handler.post(this.cleanupRunnable);
        }
        this.animationThread = null;
        if (this.animationStopCallback != null) {
            this.animationStopCallback.onAnimationStop();
        }
    }

    public OnFrameAvailable getOnFrameAvailable() {
        return this.frameCallback;
    }

    public void setOnFrameAvailable(OnFrameAvailable frameProcessor) {
        this.frameCallback = frameProcessor;
    }

    public OnAnimationStop getOnAnimationStop() {
        return this.animationStopCallback;
    }

    public void setOnAnimationStop(OnAnimationStop animationStop) {
        this.animationStopCallback = animationStop;
    }

    public void setOnAnimationStart(OnAnimationStart animationStart) {
        this.animationStartCallback = animationStart;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear();
    }

    private void startAnimationThread() {
        if (this.canStart()) {
            this.animationThread = new Thread(this);
            this.animationThread.setName("StartAnimationThread");
            this.animationThread.start();
        }
    }

    private boolean checkIsCiphert() {
        return false;
    }

    protected void onDraw(Canvas canvas) {
        try {
            super.onDraw(canvas);
        }
        catch (Exception e) {
            LogUtil.d("", "GifImageView onDraw Exception.");
        }
    }

    static /* synthetic */ byte[] access$002(GifImageView x0, byte[] x1) {
        x0.bytes = x1;
        return x1;
    }

    public static interface OnAnimationStart {
        public void onAnimationStart();
    }

    public static interface OnAnimationStop {
        public void onAnimationStop();
    }

    public static interface OnFrameAvailable {
        public Bitmap onFrameAvailable(Bitmap var1);
    }
}

