/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import android.widget.Scroller;
import com.xdja.im.uikit.view.Info;

public class PhotoView
extends AppCompatImageView {
    private static final int MIN_ROTATE = 35;
    private static final int ANIM_DURING = 340;
    private static final float MAX_SCALE = 2.5f;
    private int mMinRotate;
    private int mAnimDuring;
    private float mMaxScale;
    private int MAX_FLING_OVER_SCROLL = 0;
    private int MAX_OVER_RESISTANCE = 0;
    private int MAX_ANIM_FROM_WAITE = 500;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mAnimMatrix = new Matrix();
    private final Matrix mSynthesisMatrix = new Matrix();
    private final Matrix mTmpMatrix = new Matrix();
    private GestureDetector mDetector;
    private ScaleGestureDetector mScaleDetector;
    private View.OnClickListener mClickListener;
    private ImageView.ScaleType mScaleType;
    private boolean hasMultiTouch;
    private boolean hasDrawable;
    private boolean isKnowSize;
    private boolean hasOverTranslate;
    private boolean isEnable = false;
    private boolean isInit;
    private boolean mAdjustViewBounds;
    private boolean isZoomUp;
    private boolean canRotate;
    private boolean imgLargeWidth;
    private boolean imgLargeHeight;
    private float mRotateFlag;
    private float mDegrees;
    private float mScale = 1.0f;
    private int mTranslateX;
    private int mTranslateY;
    private float mHalfBaseRectWidth;
    private float mHalfBaseRectHeight;
    private final RectF mWidgetRect = new RectF();
    private final RectF mBaseRect = new RectF();
    private final RectF mImgRect = new RectF();
    private final RectF mTmpRect = new RectF();
    private final RectF mCommonRect = new RectF();
    private final RectF outRectF = new RectF();
    private final PointF mScreenCenter = new PointF();
    private final PointF mScaleCenter = new PointF();
    private final PointF mRotateCenter = new PointF();
    private final Transform mTranslate = new Transform();
    private RectF mClip;
    private Info mFromInfo;
    private long mInfoTime;
    private Runnable mCompleteCallBack;
    private View.OnLongClickListener mLongClick;
    private final ScaleGestureDetector.OnScaleGestureListener mScaleListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            float scaleFactor = detector.getScaleFactor();
            if (Float.isNaN(scaleFactor) || Float.isInfinite(scaleFactor)) {
                return false;
            }
            PhotoView.this.mScale = PhotoView.this.mScale * scaleFactor;
            PhotoView.this.mAnimMatrix.postScale(scaleFactor, scaleFactor, detector.getFocusX(), detector.getFocusY());
            PhotoView.this.executeTranslate();
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    };
    private final Runnable mClickRunnable = new Runnable(){

        @Override
        public void run() {
            if (PhotoView.this.mClickListener != null) {
                PhotoView.this.mClickListener.onClick((View)PhotoView.this);
            }
        }
    };
    private final GestureDetector.OnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public void onLongPress(MotionEvent e) {
            if (PhotoView.this.mLongClick != null) {
                PhotoView.this.mLongClick.onLongClick((View)PhotoView.this);
            }
        }

        public boolean onDown(MotionEvent e) {
            PhotoView.this.hasOverTranslate = false;
            PhotoView.this.hasMultiTouch = false;
            PhotoView.this.canRotate = false;
            PhotoView.this.removeCallbacks(PhotoView.this.mClickRunnable);
            return false;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (PhotoView.this.hasMultiTouch) {
                return false;
            }
            if (!PhotoView.this.imgLargeWidth && !PhotoView.this.imgLargeHeight) {
                return false;
            }
            if (((PhotoView)PhotoView.this).mTranslate.isRuning) {
                return false;
            }
            float vx = velocityX;
            float vy = velocityY;
            if ((float)Math.round(((PhotoView)PhotoView.this).mImgRect.left) >= ((PhotoView)PhotoView.this).mWidgetRect.left || (float)Math.round(((PhotoView)PhotoView.this).mImgRect.right) <= ((PhotoView)PhotoView.this).mWidgetRect.right) {
                vx = 0.0f;
            }
            if ((float)Math.round(((PhotoView)PhotoView.this).mImgRect.top) >= ((PhotoView)PhotoView.this).mWidgetRect.top || (float)Math.round(((PhotoView)PhotoView.this).mImgRect.bottom) <= ((PhotoView)PhotoView.this).mWidgetRect.bottom) {
                vy = 0.0f;
            }
            if (PhotoView.this.canRotate || PhotoView.this.mDegrees % 90.0f != 0.0f) {
                float toDegrees = (int)(PhotoView.this.mDegrees / 90.0f) * 90;
                float remainder = PhotoView.this.mDegrees % 90.0f;
                if (remainder > 45.0f) {
                    toDegrees += 90.0f;
                } else if (remainder < -45.0f) {
                    toDegrees -= 90.0f;
                }
                PhotoView.this.mTranslate.withRotate((int)PhotoView.this.mDegrees, (int)toDegrees);
                PhotoView.this.mDegrees = toDegrees;
            }
            PhotoView.this.doTranslateReset(PhotoView.this.mImgRect);
            PhotoView.this.mTranslate.withFling(vx, vy);
            PhotoView.this.mTranslate.start();
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            PhotoView.this.mapRect(PhotoView.this.mImgRect, PhotoView.this.mWidgetRect, PhotoView.this.outRectF);
            if (PhotoView.this.outRectF.width() < PhotoView.this.mWidgetRect.width() - 5.0f && PhotoView.this.outRectF.height() < PhotoView.this.mWidgetRect.height() - 5.0f) {
                return false;
            }
            if (((PhotoView)PhotoView.this).mTranslate.isRuning) {
                PhotoView.this.mTranslate.stop();
            }
            if (PhotoView.this.canScrollHorizontallySelf(distanceX)) {
                if (distanceX < 0.0f && ((PhotoView)PhotoView.this).mImgRect.left - distanceX > ((PhotoView)PhotoView.this).mWidgetRect.left) {
                    distanceX = ((PhotoView)PhotoView.this).mImgRect.left;
                }
                if (distanceX > 0.0f && ((PhotoView)PhotoView.this).mImgRect.right - distanceX < ((PhotoView)PhotoView.this).mWidgetRect.right) {
                    distanceX = ((PhotoView)PhotoView.this).mImgRect.right - ((PhotoView)PhotoView.this).mWidgetRect.right;
                }
                PhotoView.this.mAnimMatrix.postTranslate(-distanceX, 0.0f);
                PhotoView.this.mTranslateX = (int)((float)PhotoView.this.mTranslateX - distanceX);
            } else if (PhotoView.this.imgLargeWidth || PhotoView.this.hasMultiTouch || PhotoView.this.hasOverTranslate) {
                PhotoView.this.checkRect();
                if (!PhotoView.this.hasMultiTouch) {
                    if (distanceX < 0.0f && ((PhotoView)PhotoView.this).mImgRect.left - distanceX > ((PhotoView)PhotoView.this).mCommonRect.left) {
                        distanceX = PhotoView.this.resistanceScrollByX(((PhotoView)PhotoView.this).mImgRect.left - ((PhotoView)PhotoView.this).mCommonRect.left, distanceX);
                    }
                    if (distanceX > 0.0f && ((PhotoView)PhotoView.this).mImgRect.right - distanceX < ((PhotoView)PhotoView.this).mCommonRect.right) {
                        distanceX = PhotoView.this.resistanceScrollByX(((PhotoView)PhotoView.this).mImgRect.right - ((PhotoView)PhotoView.this).mCommonRect.right, distanceX);
                    }
                }
                PhotoView.this.mTranslateX = (int)((float)PhotoView.this.mTranslateX - distanceX);
                PhotoView.this.mAnimMatrix.postTranslate(-distanceX, 0.0f);
                PhotoView.this.hasOverTranslate = true;
            }
            if (PhotoView.this.canScrollVerticallySelf(distanceY)) {
                if (distanceY < 0.0f && ((PhotoView)PhotoView.this).mImgRect.top - distanceY > ((PhotoView)PhotoView.this).mWidgetRect.top) {
                    distanceY = ((PhotoView)PhotoView.this).mImgRect.top;
                }
                if (distanceY > 0.0f && ((PhotoView)PhotoView.this).mImgRect.bottom - distanceY < ((PhotoView)PhotoView.this).mWidgetRect.bottom) {
                    distanceY = ((PhotoView)PhotoView.this).mImgRect.bottom - ((PhotoView)PhotoView.this).mWidgetRect.bottom;
                }
                PhotoView.this.mAnimMatrix.postTranslate(0.0f, -distanceY);
                PhotoView.this.mTranslateY = (int)((float)PhotoView.this.mTranslateY - distanceY);
            } else if (PhotoView.this.imgLargeHeight || PhotoView.this.hasOverTranslate || PhotoView.this.hasMultiTouch) {
                PhotoView.this.checkRect();
                if (!PhotoView.this.hasMultiTouch) {
                    if (distanceY < 0.0f && ((PhotoView)PhotoView.this).mImgRect.top - distanceY > ((PhotoView)PhotoView.this).mCommonRect.top) {
                        distanceY = PhotoView.this.resistanceScrollByY(((PhotoView)PhotoView.this).mImgRect.top - ((PhotoView)PhotoView.this).mCommonRect.top, distanceY);
                    }
                    if (distanceY > 0.0f && ((PhotoView)PhotoView.this).mImgRect.bottom - distanceY < ((PhotoView)PhotoView.this).mCommonRect.bottom) {
                        distanceY = PhotoView.this.resistanceScrollByY(((PhotoView)PhotoView.this).mImgRect.bottom - ((PhotoView)PhotoView.this).mCommonRect.bottom, distanceY);
                    }
                }
                PhotoView.this.mAnimMatrix.postTranslate(0.0f, -distanceY);
                PhotoView.this.mTranslateY = (int)((float)PhotoView.this.mTranslateY - distanceY);
                PhotoView.this.hasOverTranslate = true;
            }
            PhotoView.this.executeTranslate();
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            PhotoView.this.postDelayed(PhotoView.this.mClickRunnable, 250L);
            return false;
        }

        public boolean onDoubleTap(MotionEvent e) {
            float to;
            float from;
            PhotoView.this.mTranslate.stop();
            float imgcx = ((PhotoView)PhotoView.this).mImgRect.left + PhotoView.this.mImgRect.width() / 2.0f;
            float imgcy = ((PhotoView)PhotoView.this).mImgRect.top + PhotoView.this.mImgRect.height() / 2.0f;
            PhotoView.this.mScaleCenter.set(imgcx, imgcy);
            PhotoView.this.mRotateCenter.set(imgcx, imgcy);
            PhotoView.this.mTranslateX = 0;
            PhotoView.this.mTranslateY = 0;
            if (PhotoView.this.isZoomUp) {
                from = PhotoView.this.mScale;
                to = 1.0f;
                PhotoView.this.isZoomUp = false;
            } else {
                from = PhotoView.this.mScale;
                to = PhotoView.this.mMaxScale;
                PhotoView.this.isZoomUp = true;
            }
            PhotoView.this.mTmpMatrix.reset();
            PhotoView.this.mTmpMatrix.postTranslate(-((PhotoView)PhotoView.this).mBaseRect.left, -((PhotoView)PhotoView.this).mBaseRect.top);
            PhotoView.this.mTmpMatrix.postTranslate(((PhotoView)PhotoView.this).mRotateCenter.x, ((PhotoView)PhotoView.this).mRotateCenter.y);
            PhotoView.this.mTmpMatrix.postTranslate(-PhotoView.this.mHalfBaseRectWidth, -PhotoView.this.mHalfBaseRectHeight);
            PhotoView.this.mTmpMatrix.postRotate(PhotoView.this.mDegrees, ((PhotoView)PhotoView.this).mRotateCenter.x, ((PhotoView)PhotoView.this).mRotateCenter.y);
            PhotoView.this.mTmpMatrix.postScale(to, to, ((PhotoView)PhotoView.this).mScaleCenter.x, ((PhotoView)PhotoView.this).mScaleCenter.y);
            PhotoView.this.mTmpMatrix.postTranslate((float)PhotoView.this.mTranslateX, (float)PhotoView.this.mTranslateY);
            PhotoView.this.mTmpMatrix.mapRect(PhotoView.this.mTmpRect, PhotoView.this.mBaseRect);
            PhotoView.this.doTranslateReset(PhotoView.this.mTmpRect);
            PhotoView.this.mTranslate.withScale(from, to);
            PhotoView.this.mTranslate.start();
            return false;
        }
    };

    public PhotoView(Context context) {
        this(context, null);
    }

    public PhotoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PhotoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        super.setScaleType(ImageView.ScaleType.MATRIX);
        if (this.mScaleType == null) {
            this.mScaleType = ImageView.ScaleType.CENTER_INSIDE;
        }
        this.mDetector = new GestureDetector(this.getContext(), this.mGestureListener);
        this.mScaleDetector = new ScaleGestureDetector(this.getContext(), this.mScaleListener);
        float density = this.getResources().getDisplayMetrics().density;
        this.MAX_FLING_OVER_SCROLL = (int)(density * 30.0f);
        this.MAX_OVER_RESISTANCE = (int)(density * 140.0f);
        this.mMinRotate = 35;
        this.mAnimDuring = 340;
        this.mMaxScale = 2.5f;
    }

    public int getDefaultAnimaDuring() {
        return 340;
    }

    public void setOnClickListener(View.OnClickListener l) {
        super.setOnClickListener(l);
        this.mClickListener = l;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        ImageView.ScaleType old = this.mScaleType;
        this.mScaleType = scaleType;
        if (old != scaleType) {
            this.initBase();
        }
    }

    public void setOnLongClickListener(View.OnLongClickListener l) {
        this.mLongClick = l;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mTranslate.setInterpolator(interpolator);
    }

    public int getAnimaDuring() {
        return this.mAnimDuring;
    }

    public void setAnimaDuring(int during) {
        this.mAnimDuring = during;
    }

    public void setMaxScale(float maxScale) {
        this.mMaxScale = maxScale;
    }

    public float getMaxScale() {
        return this.mMaxScale;
    }

    public void enable() {
        this.isEnable = true;
    }

    public void disenable() {
        this.isEnable = false;
    }

    public void setMaxAnimFromWaiteTime(int wait) {
        this.MAX_ANIM_FROM_WAITE = wait;
    }

    public void setImageResource(int resId) {
        Drawable drawable2 = null;
        try {
            drawable2 = this.getResources().getDrawable(resId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setImageDrawable(drawable2);
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        if (drawable2 == null) {
            this.hasDrawable = false;
            return;
        }
        if (!this.hasSize(drawable2)) {
            return;
        }
        if (!this.hasDrawable) {
            this.hasDrawable = true;
        }
        this.initBase();
    }

    private boolean hasSize(Drawable d) {
        return d.getIntrinsicHeight() > 0 && d.getIntrinsicWidth() > 0 || d.getMinimumWidth() > 0 && d.getMinimumHeight() > 0 || d.getBounds().width() > 0 && d.getBounds().height() > 0;
    }

    private static int getDrawableWidth(Drawable d) {
        int width = d.getIntrinsicWidth();
        if (width <= 0) {
            width = d.getMinimumWidth();
        }
        if (width <= 0) {
            width = d.getBounds().width();
        }
        return width;
    }

    private static int getDrawableHeight(Drawable d) {
        int height = d.getIntrinsicHeight();
        if (height <= 0) {
            height = d.getMinimumHeight();
        }
        if (height <= 0) {
            height = d.getBounds().height();
        }
        return height;
    }

    private void initBase() {
        if (!this.hasDrawable) {
            return;
        }
        if (!this.isKnowSize) {
            return;
        }
        this.mBaseMatrix.reset();
        this.mAnimMatrix.reset();
        this.isZoomUp = false;
        Drawable img = this.getDrawable();
        int w = this.getWidth();
        int h = this.getHeight();
        int imgw = PhotoView.getDrawableWidth(img);
        int imgh = PhotoView.getDrawableHeight(img);
        this.mBaseRect.set(0.0f, 0.0f, (float)imgw, (float)imgh);
        int tx = (w - imgw) / 2;
        int ty = (h - imgh) / 2;
        float sx = 1.0f;
        float sy = 1.0f;
        if (imgw > w) {
            sx = (float)w / (float)imgw;
        }
        if (imgh > h) {
            sy = (float)h / (float)imgh;
        }
        float scale = sx < sy ? sx : sy;
        this.mBaseMatrix.reset();
        this.mBaseMatrix.postTranslate((float)tx, (float)ty);
        this.mBaseMatrix.postScale(scale, scale, this.mScreenCenter.x, this.mScreenCenter.y);
        this.mBaseMatrix.mapRect(this.mBaseRect);
        this.mHalfBaseRectWidth = this.mBaseRect.width() / 2.0f;
        this.mHalfBaseRectHeight = this.mBaseRect.height() / 2.0f;
        this.mScaleCenter.set(this.mScreenCenter);
        this.mRotateCenter.set(this.mScaleCenter);
        this.executeTranslate();
        switch (this.mScaleType) {
            case CENTER: {
                this.initCenter();
                break;
            }
            case CENTER_CROP: {
                this.initCenterCrop();
                break;
            }
            case CENTER_INSIDE: {
                this.initCenterInside();
                break;
            }
            case FIT_CENTER: {
                this.initFitCenter();
                break;
            }
            case FIT_START: {
                this.initFitStart();
                break;
            }
            case FIT_END: {
                this.initFitEnd();
                break;
            }
            case FIT_XY: {
                this.initFitXY();
            }
        }
        this.isInit = true;
        if (this.mFromInfo != null && System.currentTimeMillis() - this.mInfoTime < (long)this.MAX_ANIM_FROM_WAITE) {
            this.animaFrom(this.mFromInfo);
        }
        this.mFromInfo = null;
    }

    private void initCenter() {
        if (!this.hasDrawable) {
            return;
        }
        if (!this.isKnowSize) {
            return;
        }
        Drawable img = this.getDrawable();
        int imgw = PhotoView.getDrawableWidth(img);
        int imgh = PhotoView.getDrawableHeight(img);
        if ((float)imgw > this.mWidgetRect.width() || (float)imgh > this.mWidgetRect.height()) {
            float scaleY;
            float scaleX = (float)imgw / this.mImgRect.width();
            this.mScale = scaleX > (scaleY = (float)imgh / this.mImgRect.height()) ? scaleX : scaleY;
            this.mAnimMatrix.postScale(this.mScale, this.mScale, this.mScreenCenter.x, this.mScreenCenter.y);
            this.executeTranslate();
            this.resetBase();
        }
    }

    private void initCenterCrop() {
        if (this.mImgRect.width() < this.mWidgetRect.width() || this.mImgRect.height() < this.mWidgetRect.height()) {
            float scaleY;
            float scaleX = this.mWidgetRect.width() / this.mImgRect.width();
            this.mScale = scaleX > (scaleY = this.mWidgetRect.height() / this.mImgRect.height()) ? scaleX : scaleY;
            this.mAnimMatrix.postScale(this.mScale, this.mScale, this.mScreenCenter.x, this.mScreenCenter.y);
            this.executeTranslate();
            this.resetBase();
        }
    }

    private void initCenterInside() {
        if (this.mImgRect.width() > this.mWidgetRect.width() || this.mImgRect.height() > this.mWidgetRect.height()) {
            float scaleY;
            float scaleX = this.mWidgetRect.width() / this.mImgRect.width();
            this.mScale = scaleX < (scaleY = this.mWidgetRect.height() / this.mImgRect.height()) ? scaleX : scaleY;
            this.mAnimMatrix.postScale(this.mScale, this.mScale, this.mScreenCenter.x, this.mScreenCenter.y);
            this.executeTranslate();
            this.resetBase();
        }
    }

    private void initFitCenter() {
        if (this.mImgRect.width() < this.mWidgetRect.width()) {
            this.mScale = this.mWidgetRect.width() / this.mImgRect.width();
            this.mAnimMatrix.postScale(this.mScale, this.mScale, this.mScreenCenter.x, this.mScreenCenter.y);
            this.executeTranslate();
            this.resetBase();
        }
    }

    private void initFitStart() {
        this.initFitCenter();
        float ty = -this.mImgRect.top;
        this.mTranslateY = (int)((float)this.mTranslateY + ty);
        this.mAnimMatrix.postTranslate(0.0f, ty);
        this.executeTranslate();
        this.resetBase();
    }

    private void initFitEnd() {
        this.initFitCenter();
        float ty = this.mWidgetRect.bottom - this.mImgRect.bottom;
        this.mTranslateY = (int)((float)this.mTranslateY + ty);
        this.mAnimMatrix.postTranslate(0.0f, ty);
        this.executeTranslate();
        this.resetBase();
    }

    private void initFitXY() {
        float scaleX = this.mWidgetRect.width() / this.mImgRect.width();
        float scaleY = this.mWidgetRect.height() / this.mImgRect.height();
        this.mAnimMatrix.postScale(scaleX, scaleY, this.mScreenCenter.x, this.mScreenCenter.y);
        this.executeTranslate();
        this.resetBase();
    }

    private void resetBase() {
        Drawable img = this.getDrawable();
        int imgw = PhotoView.getDrawableWidth(img);
        int imgh = PhotoView.getDrawableHeight(img);
        this.mBaseRect.set(0.0f, 0.0f, (float)imgw, (float)imgh);
        this.mBaseMatrix.set(this.mSynthesisMatrix);
        this.mBaseMatrix.mapRect(this.mBaseRect);
        this.mHalfBaseRectWidth = this.mBaseRect.width() / 2.0f;
        this.mHalfBaseRectHeight = this.mBaseRect.height() / 2.0f;
        this.mScale = 1.0f;
        this.mTranslateX = 0;
        this.mTranslateY = 0;
        this.mAnimMatrix.reset();
    }

    private void executeTranslate() {
        this.mSynthesisMatrix.set(this.mBaseMatrix);
        this.mSynthesisMatrix.postConcat(this.mAnimMatrix);
        this.setImageMatrix(this.mSynthesisMatrix);
        this.mAnimMatrix.mapRect(this.mImgRect, this.mBaseRect);
        this.imgLargeWidth = this.mImgRect.width() > this.mWidgetRect.width();
        this.imgLargeHeight = this.mImgRect.height() > this.mWidgetRect.height();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.hasDrawable) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        Drawable d = this.getDrawable();
        int drawableW = PhotoView.getDrawableWidth(d);
        int drawableH = PhotoView.getDrawableHeight(d);
        int pWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int pHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        ViewGroup.LayoutParams p = this.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-2, -2);
        }
        int width = p.width == -1 ? (widthMode == 0 ? drawableW : pWidth) : (widthMode == 0x40000000 ? pWidth : (widthMode == Integer.MIN_VALUE ? (drawableW > pWidth ? pWidth : drawableW) : drawableW));
        int height = p.height == -1 ? (heightMode == 0 ? drawableH : pHeight) : (heightMode == 0x40000000 ? pHeight : (heightMode == Integer.MIN_VALUE ? (drawableH > pHeight ? pHeight : drawableH) : drawableH));
        if (this.mAdjustViewBounds && (float)drawableW / (float)drawableH != (float)width / (float)height) {
            float hScale = (float)height / (float)drawableH;
            float wScale = (float)width / (float)drawableW;
            float scale = hScale < wScale ? hScale : wScale;
            width = p.width == -1 ? width : (int)((float)drawableW * scale);
            height = p.height == -1 ? height : (int)((float)drawableH * scale);
        }
        this.setMeasuredDimension(width, height);
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        super.setAdjustViewBounds(adjustViewBounds);
        this.mAdjustViewBounds = adjustViewBounds;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidgetRect.set(0.0f, 0.0f, (float)w, (float)h);
        this.mScreenCenter.set((float)(w / 2), (float)(h / 2));
        if (!this.isKnowSize) {
            this.isKnowSize = true;
            this.initBase();
        }
    }

    public void draw(Canvas canvas) {
        if (this.mClip != null) {
            canvas.clipRect(this.mClip);
            this.mClip = null;
        }
        super.draw(canvas);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.isEnable) {
            int Action2 = event.getActionMasked();
            if (event.getPointerCount() >= 2) {
                this.hasMultiTouch = true;
            }
            this.mDetector.onTouchEvent(event);
            this.mScaleDetector.onTouchEvent(event);
            if (Action2 == 1 || Action2 == 3) {
                this.onUp();
            }
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    private void onUp() {
        if (this.mTranslate.isRuning) {
            return;
        }
        if (this.canRotate || this.mDegrees % 90.0f != 0.0f) {
            float toDegrees = (int)(this.mDegrees / 90.0f) * 90;
            float remainder = this.mDegrees % 90.0f;
            if (remainder > 45.0f) {
                toDegrees += 90.0f;
            } else if (remainder < -45.0f) {
                toDegrees -= 90.0f;
            }
            this.mTranslate.withRotate((int)this.mDegrees, (int)toDegrees);
            this.mDegrees = toDegrees;
        }
        float scale = this.mScale;
        if (this.mScale < 1.0f) {
            scale = 1.0f;
            this.mTranslate.withScale(this.mScale, 1.0f);
        } else if (this.mScale > 5.0f) {
            scale = this.mMaxScale;
            this.mTranslate.withScale(this.mScale, this.mMaxScale);
        }
        float cx = this.mImgRect.left + this.mImgRect.width() / 2.0f;
        float cy = this.mImgRect.top + this.mImgRect.height() / 2.0f;
        this.mScaleCenter.set(cx, cy);
        this.mRotateCenter.set(cx, cy);
        this.mTranslateX = 0;
        this.mTranslateY = 0;
        this.mTmpMatrix.reset();
        this.mTmpMatrix.postTranslate(-this.mBaseRect.left, -this.mBaseRect.top);
        this.mTmpMatrix.postTranslate(cx - this.mHalfBaseRectWidth, cy - this.mHalfBaseRectHeight);
        this.mTmpMatrix.postScale(scale, scale, cx, cy);
        this.mTmpMatrix.postRotate(this.mDegrees, cx, cy);
        this.mTmpMatrix.mapRect(this.mTmpRect, this.mBaseRect);
        this.doTranslateReset(this.mTmpRect);
        this.mTranslate.start();
    }

    private void doTranslateReset(RectF imgRect) {
        int tx = 0;
        int ty = 0;
        if (imgRect.width() <= this.mWidgetRect.width()) {
            if (!this.isImageCenterWidth(imgRect)) {
                tx = -((int)((this.mWidgetRect.width() - imgRect.width()) / 2.0f - imgRect.left));
            }
        } else if (imgRect.left > this.mWidgetRect.left) {
            tx = (int)(imgRect.left - this.mWidgetRect.left);
        } else if (imgRect.right < this.mWidgetRect.right) {
            tx = (int)(imgRect.right - this.mWidgetRect.right);
        }
        if (imgRect.height() <= this.mWidgetRect.height()) {
            if (!this.isImageCenterHeight(imgRect)) {
                ty = -((int)((this.mWidgetRect.height() - imgRect.height()) / 2.0f - imgRect.top));
            }
        } else if (imgRect.top > this.mWidgetRect.top) {
            ty = (int)(imgRect.top - this.mWidgetRect.top);
        } else if (imgRect.bottom < this.mWidgetRect.bottom) {
            ty = (int)(imgRect.bottom - this.mWidgetRect.bottom);
        }
        if (tx != 0 || ty != 0) {
            if (!this.mTranslate.mFlingScroller.isFinished()) {
                this.mTranslate.mFlingScroller.abortAnimation();
            }
            this.mTranslate.withTranslate(-tx, -ty);
        }
    }

    private boolean isImageCenterHeight(RectF rect) {
        return Math.abs((float)Math.round(rect.top) - (this.mWidgetRect.height() - rect.height()) / 2.0f) < 1.0f;
    }

    private boolean isImageCenterWidth(RectF rect) {
        return Math.abs((float)Math.round(rect.left) - (this.mWidgetRect.width() - rect.width()) / 2.0f) < 1.0f;
    }

    private float resistanceScrollByX(float overScroll, float detalX) {
        return detalX * (Math.abs(Math.abs(overScroll) - (float)this.MAX_OVER_RESISTANCE) / (float)this.MAX_OVER_RESISTANCE);
    }

    private float resistanceScrollByY(float overScroll, float detalY) {
        return detalY * (Math.abs(Math.abs(overScroll) - (float)this.MAX_OVER_RESISTANCE) / (float)this.MAX_OVER_RESISTANCE);
    }

    private void mapRect(RectF r1, RectF r2, RectF out) {
        float b;
        float r;
        float l = r1.left > r2.left ? r1.left : r2.left;
        float f = r = r1.right < r2.right ? r1.right : r2.right;
        if (l > r) {
            out.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        float t = r1.top > r2.top ? r1.top : r2.top;
        float f2 = b = r1.bottom < r2.bottom ? r1.bottom : r2.bottom;
        if (t > b) {
            out.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        out.set(l, t, r, b);
    }

    private void checkRect() {
        if (!this.hasOverTranslate) {
            this.mapRect(this.mWidgetRect, this.mImgRect, this.mCommonRect);
        }
    }

    private boolean canScrollHorizontallySelf(float direction) {
        int daltX = 10;
        if (direction < 0.0f && this.mImgRect.left + (float)daltX < this.mWidgetRect.left) {
            return true;
        }
        return direction > 0.0f && this.mImgRect.right - (float)daltX > this.mWidgetRect.right;
    }

    public boolean canScrollVerticallySelf(float direction) {
        if (this.mImgRect.height() <= this.mWidgetRect.height()) {
            return false;
        }
        if (direction < 0.0f && (float)Math.round(this.mImgRect.top) - direction >= this.mWidgetRect.top) {
            return false;
        }
        return !(direction > 0.0f) || !((float)Math.round(this.mImgRect.bottom) - direction <= this.mWidgetRect.bottom);
    }

    public boolean canScrollHorizontally(int direction) {
        return this.hasMultiTouch || this.canScrollHorizontallySelf(direction);
    }

    public boolean canScrollVertically(int direction) {
        return this.hasMultiTouch || this.canScrollVerticallySelf(direction);
    }

    private Info getInfo() {
        RectF rect = new RectF();
        int[] p = new int[2];
        PhotoView.getLocation((View)this, p);
        rect.set((float)p[0] + this.mImgRect.left, (float)p[1] + this.mImgRect.top, (float)p[0] + this.mImgRect.right, (float)p[1] + this.mImgRect.bottom);
        return new Info(rect, this.mImgRect, this.mWidgetRect, this.mBaseRect, this.mScreenCenter, this.mScale, this.mDegrees, this.mScaleType);
    }

    public static Info getImageViewInfo(ImageView imgView) {
        int[] p = new int[2];
        PhotoView.getLocation((View)imgView, p);
        Drawable drawable2 = imgView.getDrawable();
        Matrix matrix = imgView.getImageMatrix();
        int width = PhotoView.getDrawableWidth(drawable2);
        int height = PhotoView.getDrawableHeight(drawable2);
        RectF imgRect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        matrix.mapRect(imgRect);
        RectF rect = new RectF((float)p[0] + imgRect.left, (float)p[1] + imgRect.top, (float)p[0] + imgRect.right, (float)p[1] + imgRect.bottom);
        RectF widgetRect = new RectF(0.0f, 0.0f, (float)imgView.getWidth(), (float)imgView.getHeight());
        RectF baseRect = new RectF(widgetRect);
        PointF screenCenter = new PointF(widgetRect.width() / 2.0f, widgetRect.height() / 2.0f);
        return new Info(rect, imgRect, widgetRect, baseRect, screenCenter, 1.0f, 0.0f, imgView.getScaleType());
    }

    private static void getLocation(View target, int[] position) {
        position[0] = position[0] + target.getLeft();
        position[1] = position[1] + target.getTop();
        ViewParent viewParent = target.getParent();
        while (viewParent instanceof View) {
            View view = (View)viewParent;
            if (view.getId() == 0x1020002) {
                return;
            }
            position[0] = position[0] - view.getScrollX();
            position[1] = position[1] - view.getScrollY();
            position[0] = position[0] + view.getLeft();
            position[1] = position[1] + view.getTop();
            viewParent = view.getParent();
        }
        position[0] = (int)((float)position[0] + 0.5f);
        position[1] = (int)((float)position[1] + 0.5f);
    }

    private void reset() {
        this.mAnimMatrix.reset();
        this.executeTranslate();
        this.mScale = 1.0f;
        this.mTranslateX = 0;
        this.mTranslateY = 0;
    }

    private void animaFrom(Info info) {
        if (this.isInit) {
            this.reset();
            Info mine = this.getInfo();
            float scaleX = info.mImgRect.width() / mine.mImgRect.width();
            float scaleY = info.mImgRect.height() / mine.mImgRect.height();
            float scale = scaleX < scaleY ? scaleX : scaleY;
            float ocx = info.mRect.left + info.mRect.width() / 2.0f;
            float ocy = info.mRect.top + info.mRect.height() / 2.0f;
            this.mAnimMatrix.reset();
            this.mAnimMatrix.postTranslate(-this.mBaseRect.left, -this.mBaseRect.top);
            this.mAnimMatrix.postTranslate(ocx - this.mBaseRect.width() / 2.0f, ocy - this.mBaseRect.height() / 2.0f);
            this.mAnimMatrix.postScale(scale, scale, ocx, ocy);
            this.mAnimMatrix.postRotate(info.mDegrees, ocx, ocy);
            this.executeTranslate();
            this.mScaleCenter.set(ocx, ocy);
            this.mRotateCenter.set(ocx, ocy);
            this.mTranslate.withTranslate((int)(this.mScreenCenter.x - ocx), (int)(this.mScreenCenter.y - ocy));
            this.mTranslate.withScale(scale, 1.0f);
            this.mTranslate.withRotate((int)info.mDegrees, 0);
            if (info.mWidgetRect.width() < info.mImgRect.width() || info.mWidgetRect.height() < info.mImgRect.height()) {
                float clipX = info.mWidgetRect.width() / info.mImgRect.width();
                float clipY = info.mWidgetRect.height() / info.mImgRect.height();
                clipX = clipX > 1.0f ? 1.0f : clipX;
                float f = clipY = clipY > 1.0f ? 1.0f : clipY;
                START c = info.mScaleType == ImageView.ScaleType.FIT_START ? new START() : (info.mScaleType == ImageView.ScaleType.FIT_END ? new END() : new OTHER());
                this.mTranslate.withClip(clipX, clipY, 1.0f - clipX, 1.0f - clipY, this.mAnimDuring / 3, c);
                this.mTmpMatrix.setScale(clipX, clipY, (this.mImgRect.left + this.mImgRect.right) / 2.0f, c.calculateTop());
                this.mTmpMatrix.mapRect(this.mTranslate.mClipRect, this.mImgRect);
                this.mClip = this.mTranslate.mClipRect;
            }
            this.mTranslate.start();
        } else {
            this.mFromInfo = info;
            this.mInfoTime = System.currentTimeMillis();
        }
    }

    public void animaTo(Info info, Runnable completeCallBack) {
        if (this.isInit) {
            this.mTranslate.stop();
            this.mTranslateX = 0;
            this.mTranslateY = 0;
            float tcx = info.mRect.left + info.mRect.width() / 2.0f;
            float tcy = info.mRect.top + info.mRect.height() / 2.0f;
            this.mScaleCenter.set(this.mImgRect.left + this.mImgRect.width() / 2.0f, this.mImgRect.top + this.mImgRect.height() / 2.0f);
            this.mRotateCenter.set(this.mScaleCenter);
            this.mAnimMatrix.postRotate(-this.mDegrees, this.mScaleCenter.x, this.mScaleCenter.y);
            this.mAnimMatrix.mapRect(this.mImgRect, this.mBaseRect);
            float scaleX = info.mImgRect.width() / this.mBaseRect.width();
            float scaleY = info.mImgRect.height() / this.mBaseRect.height();
            float scale = scaleX > scaleY ? scaleX : scaleY;
            this.mAnimMatrix.postRotate(this.mDegrees, this.mScaleCenter.x, this.mScaleCenter.y);
            this.mAnimMatrix.mapRect(this.mImgRect, this.mBaseRect);
            this.mDegrees %= 360.0f;
            this.mTranslate.withTranslate((int)(tcx - this.mScaleCenter.x), (int)(tcy - this.mScaleCenter.y));
            this.mTranslate.withScale(this.mScale, scale);
            this.mTranslate.withRotate((int)this.mDegrees, (int)info.mDegrees, this.mAnimDuring * 2 / 3);
            if (info.mWidgetRect.width() < info.mRect.width() || info.mWidgetRect.height() < info.mRect.height()) {
                float clipX = info.mWidgetRect.width() / info.mRect.width();
                float clipY = info.mWidgetRect.height() / info.mRect.height();
                clipX = clipX > 1.0f ? 1.0f : clipX;
                clipY = clipY > 1.0f ? 1.0f : clipY;
                final float cx = clipX;
                final float cy = clipY;
                final START c = info.mScaleType == ImageView.ScaleType.FIT_START ? new START() : (info.mScaleType == ImageView.ScaleType.FIT_END ? new END() : new OTHER());
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PhotoView.this.mTranslate.withClip(1.0f, 1.0f, -1.0f + cx, -1.0f + cy, PhotoView.this.mAnimDuring / 2, c);
                    }
                }, this.mAnimDuring / 2);
            }
            this.mCompleteCallBack = completeCallBack;
            this.mTranslate.start();
        }
    }

    public class OTHER
    implements ClipCalculate {
        @Override
        public float calculateTop() {
            return (((PhotoView)PhotoView.this).mImgRect.top + ((PhotoView)PhotoView.this).mImgRect.bottom) / 2.0f;
        }
    }

    public class END
    implements ClipCalculate {
        @Override
        public float calculateTop() {
            return ((PhotoView)PhotoView.this).mImgRect.bottom;
        }
    }

    public class START
    implements ClipCalculate {
        @Override
        public float calculateTop() {
            return ((PhotoView)PhotoView.this).mImgRect.top;
        }
    }

    public static interface ClipCalculate {
        public float calculateTop();
    }

    private class Transform
    implements Runnable {
        boolean isRuning;
        final OverScroller mTranslateScroller;
        final OverScroller mFlingScroller;
        final Scroller mScaleScroller;
        final Scroller mClipScroller;
        final Scroller mRotateScroller;
        ClipCalculate C;
        int mLastFlingX;
        int mLastFlingY;
        int mLastTranslateX;
        int mLastTranslateY;
        final RectF mClipRect = new RectF();
        final InterpolatorProxy mInterpolatorProxy = new InterpolatorProxy();

        Transform() {
            Context ctx = PhotoView.this.getContext();
            this.mTranslateScroller = new OverScroller(ctx, (Interpolator)this.mInterpolatorProxy);
            this.mScaleScroller = new Scroller(ctx, (Interpolator)this.mInterpolatorProxy);
            this.mFlingScroller = new OverScroller(ctx, (Interpolator)this.mInterpolatorProxy);
            this.mClipScroller = new Scroller(ctx, (Interpolator)this.mInterpolatorProxy);
            this.mRotateScroller = new Scroller(ctx, (Interpolator)this.mInterpolatorProxy);
        }

        public void setInterpolator(Interpolator interpolator) {
            this.mInterpolatorProxy.setTargetInterpolator(interpolator);
        }

        void withTranslate(int deltaX, int deltaY) {
            this.mLastTranslateX = 0;
            this.mLastTranslateY = 0;
            this.mTranslateScroller.startScroll(0, 0, deltaX, deltaY, PhotoView.this.mAnimDuring);
        }

        void withScale(float form, float to) {
            this.mScaleScroller.startScroll((int)(form * 10000.0f), 0, (int)((to - form) * 10000.0f), 0, PhotoView.this.mAnimDuring);
        }

        void withClip(float fromX, float fromY, float deltaX, float deltaY, int d, ClipCalculate c) {
            this.mClipScroller.startScroll((int)(fromX * 10000.0f), (int)(fromY * 10000.0f), (int)(deltaX * 10000.0f), (int)(deltaY * 10000.0f), d);
            this.C = c;
        }

        void withRotate(int fromDegrees, int toDegrees) {
            this.mRotateScroller.startScroll(fromDegrees, 0, toDegrees - fromDegrees, 0, PhotoView.this.mAnimDuring);
        }

        void withRotate(int fromDegrees, int toDegrees, int during) {
            this.mRotateScroller.startScroll(fromDegrees, 0, toDegrees - fromDegrees, 0, during);
        }

        void withFling(float velocityX, float velocityY) {
            int overY;
            this.mLastFlingX = velocityX < 0.0f ? Integer.MAX_VALUE : 0;
            int distanceX = (int)(velocityX > 0.0f ? Math.abs(((PhotoView)PhotoView.this).mImgRect.left) : ((PhotoView)PhotoView.this).mImgRect.right - ((PhotoView)PhotoView.this).mWidgetRect.right);
            distanceX = velocityX < 0.0f ? Integer.MAX_VALUE - distanceX : distanceX;
            int minX = velocityX < 0.0f ? distanceX : 0;
            int maxX = velocityX < 0.0f ? Integer.MAX_VALUE : distanceX;
            int overX = velocityX < 0.0f ? Integer.MAX_VALUE - minX : distanceX;
            this.mLastFlingY = velocityY < 0.0f ? Integer.MAX_VALUE : 0;
            int distanceY = (int)(velocityY > 0.0f ? Math.abs(((PhotoView)PhotoView.this).mImgRect.top) : ((PhotoView)PhotoView.this).mImgRect.bottom - ((PhotoView)PhotoView.this).mWidgetRect.bottom);
            distanceY = velocityY < 0.0f ? Integer.MAX_VALUE - distanceY : distanceY;
            int minY = velocityY < 0.0f ? distanceY : 0;
            int maxY = velocityY < 0.0f ? Integer.MAX_VALUE : distanceY;
            int n = overY = velocityY < 0.0f ? Integer.MAX_VALUE - minY : distanceY;
            if (velocityX == 0.0f) {
                maxX = 0;
                minX = 0;
            }
            if (velocityY == 0.0f) {
                maxY = 0;
                minY = 0;
            }
            this.mFlingScroller.fling(this.mLastFlingX, this.mLastFlingY, (int)velocityX, (int)velocityY, minX, maxX, minY, maxY, Math.abs(overX) < PhotoView.this.MAX_FLING_OVER_SCROLL * 2 ? 0 : PhotoView.this.MAX_FLING_OVER_SCROLL, Math.abs(overY) < PhotoView.this.MAX_FLING_OVER_SCROLL * 2 ? 0 : PhotoView.this.MAX_FLING_OVER_SCROLL);
        }

        void start() {
            this.isRuning = true;
            this.postExecute();
        }

        void stop() {
            PhotoView.this.removeCallbacks(this);
            this.mTranslateScroller.abortAnimation();
            this.mScaleScroller.abortAnimation();
            this.mFlingScroller.abortAnimation();
            this.mRotateScroller.abortAnimation();
            this.isRuning = false;
        }

        @Override
        public void run() {
            boolean endAnima = true;
            if (this.mScaleScroller.computeScrollOffset()) {
                PhotoView.this.mScale = (float)this.mScaleScroller.getCurrX() / 10000.0f;
                endAnima = false;
            }
            if (this.mTranslateScroller.computeScrollOffset()) {
                int tx = this.mTranslateScroller.getCurrX() - this.mLastTranslateX;
                int ty = this.mTranslateScroller.getCurrY() - this.mLastTranslateY;
                PhotoView.this.mTranslateX = PhotoView.this.mTranslateX + tx;
                PhotoView.this.mTranslateY = PhotoView.this.mTranslateY + ty;
                this.mLastTranslateX = this.mTranslateScroller.getCurrX();
                this.mLastTranslateY = this.mTranslateScroller.getCurrY();
                endAnima = false;
            }
            if (this.mFlingScroller.computeScrollOffset()) {
                int x = this.mFlingScroller.getCurrX() - this.mLastFlingX;
                int y = this.mFlingScroller.getCurrY() - this.mLastFlingY;
                this.mLastFlingX = this.mFlingScroller.getCurrX();
                this.mLastFlingY = this.mFlingScroller.getCurrY();
                PhotoView.this.mTranslateX = PhotoView.this.mTranslateX + x;
                PhotoView.this.mTranslateY = PhotoView.this.mTranslateY + y;
                endAnima = false;
            }
            if (this.mRotateScroller.computeScrollOffset()) {
                PhotoView.this.mDegrees = this.mRotateScroller.getCurrX();
                endAnima = false;
            }
            if (this.mClipScroller.computeScrollOffset() || PhotoView.this.mClip != null) {
                float sx = (float)this.mClipScroller.getCurrX() / 10000.0f;
                float sy = (float)this.mClipScroller.getCurrY() / 10000.0f;
                PhotoView.this.mTmpMatrix.setScale(sx, sy, (((PhotoView)PhotoView.this).mImgRect.left + ((PhotoView)PhotoView.this).mImgRect.right) / 2.0f, this.C.calculateTop());
                PhotoView.this.mTmpMatrix.mapRect(this.mClipRect, PhotoView.this.mImgRect);
                if (sx == 1.0f) {
                    this.mClipRect.left = ((PhotoView)PhotoView.this).mWidgetRect.left;
                    this.mClipRect.right = ((PhotoView)PhotoView.this).mWidgetRect.right;
                }
                if (sy == 1.0f) {
                    this.mClipRect.top = ((PhotoView)PhotoView.this).mWidgetRect.top;
                    this.mClipRect.bottom = ((PhotoView)PhotoView.this).mWidgetRect.bottom;
                }
                PhotoView.this.mClip = this.mClipRect;
            }
            if (!endAnima) {
                this.applyAnima();
                this.postExecute();
            } else {
                this.isRuning = false;
                boolean needFix = false;
                if (PhotoView.this.imgLargeWidth) {
                    if (((PhotoView)PhotoView.this).mImgRect.left > 0.0f) {
                        PhotoView.this.mTranslateX = (int)((float)PhotoView.this.mTranslateX - ((PhotoView)PhotoView.this).mImgRect.left);
                    } else if (((PhotoView)PhotoView.this).mImgRect.right < PhotoView.this.mWidgetRect.width()) {
                        PhotoView.this.mTranslateX = PhotoView.this.mTranslateX - (int)(PhotoView.this.mWidgetRect.width() - ((PhotoView)PhotoView.this).mImgRect.right);
                    }
                    needFix = true;
                }
                if (PhotoView.this.imgLargeHeight) {
                    if (((PhotoView)PhotoView.this).mImgRect.top > 0.0f) {
                        PhotoView.this.mTranslateY = (int)((float)PhotoView.this.mTranslateY - ((PhotoView)PhotoView.this).mImgRect.top);
                    } else if (((PhotoView)PhotoView.this).mImgRect.bottom < PhotoView.this.mWidgetRect.height()) {
                        PhotoView.this.mTranslateY = PhotoView.this.mTranslateY - (int)(PhotoView.this.mWidgetRect.height() - ((PhotoView)PhotoView.this).mImgRect.bottom);
                    }
                    needFix = true;
                }
                if (needFix) {
                    this.applyAnima();
                }
                PhotoView.this.invalidate();
                if (PhotoView.this.mCompleteCallBack != null) {
                    PhotoView.this.mCompleteCallBack.run();
                    PhotoView.this.mCompleteCallBack = null;
                }
            }
        }

        private void applyAnima() {
            PhotoView.this.mAnimMatrix.reset();
            PhotoView.this.mAnimMatrix.postTranslate(-((PhotoView)PhotoView.this).mBaseRect.left, -((PhotoView)PhotoView.this).mBaseRect.top);
            PhotoView.this.mAnimMatrix.postTranslate(((PhotoView)PhotoView.this).mRotateCenter.x, ((PhotoView)PhotoView.this).mRotateCenter.y);
            PhotoView.this.mAnimMatrix.postTranslate(-PhotoView.this.mHalfBaseRectWidth, -PhotoView.this.mHalfBaseRectHeight);
            PhotoView.this.mAnimMatrix.postRotate(PhotoView.this.mDegrees, ((PhotoView)PhotoView.this).mRotateCenter.x, ((PhotoView)PhotoView.this).mRotateCenter.y);
            PhotoView.this.mAnimMatrix.postScale(PhotoView.this.mScale, PhotoView.this.mScale, ((PhotoView)PhotoView.this).mScaleCenter.x, ((PhotoView)PhotoView.this).mScaleCenter.y);
            PhotoView.this.mAnimMatrix.postTranslate((float)PhotoView.this.mTranslateX, (float)PhotoView.this.mTranslateY);
            PhotoView.this.executeTranslate();
        }

        private void postExecute() {
            if (this.isRuning) {
                PhotoView.this.post(this);
            }
        }
    }

    private class InterpolatorProxy
    implements Interpolator {
        private Interpolator mTarget = new DecelerateInterpolator();

        private InterpolatorProxy() {
        }

        public void setTargetInterpolator(Interpolator interpolator) {
            this.mTarget = interpolator;
        }

        public float getInterpolation(float input) {
            if (this.mTarget != null) {
                return this.mTarget.getInterpolation(input);
            }
            return input;
        }
    }
}

