/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.imagecompresser;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Engine {
    private File mSrcImg;
    private File mTargetImg;
    private ExifInterface srcExif;
    private int srcWidth;
    private int srcHeight;

    public Engine(File srcImg, File targetImg) throws IOException {
        if (this.isJpeg(srcImg)) {
            this.srcExif = new ExifInterface(srcImg.getAbsolutePath());
        }
        this.mSrcImg = srcImg;
        this.mTargetImg = targetImg;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)srcImg.getAbsolutePath(), (BitmapFactory.Options)options);
        this.srcWidth = options.outWidth;
        this.srcHeight = options.outHeight;
    }

    private boolean isJpeg(File photo) {
        return photo.getAbsolutePath().contains("jpeg") || photo.getAbsolutePath().contains("jpg");
    }

    public File compress() throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.computeSize();
        Bitmap tagBitmap = BitmapFactory.decodeFile((String)this.mSrcImg.getAbsolutePath(), (BitmapFactory.Options)options);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        tagBitmap = this.rotatingImage(tagBitmap);
        tagBitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)stream);
        BitmapUtils.recycleBmp(tagBitmap);
        FileOutputStream fos = new FileOutputStream(this.mTargetImg);
        fos.write(stream.toByteArray());
        fos.flush();
        fos.close();
        stream.close();
        return this.mTargetImg;
    }

    private int computeSize() {
        this.srcWidth = this.srcWidth % 2 == 1 ? this.srcWidth + 1 : this.srcWidth;
        this.srcHeight = this.srcHeight % 2 == 1 ? this.srcHeight + 1 : this.srcHeight;
        this.srcWidth = this.srcWidth > this.srcHeight ? this.srcHeight : this.srcWidth;
        this.srcHeight = this.srcWidth > this.srcHeight ? this.srcWidth : this.srcHeight;
        double scale = (double)this.srcWidth / (double)this.srcHeight;
        int mSampleSize = scale <= 1.0 && scale > 0.5625 ? (this.srcHeight < 1664 ? 1 : (this.srcHeight >= 1664 && this.srcHeight < 4990 ? 2 : (this.srcHeight >= 4990 && this.srcHeight < 10240 ? 4 : (this.srcHeight / 1280 == 0 ? 1 : this.srcHeight / 1280)))) : (scale <= 0.5625 && scale > 0.5 ? (this.srcHeight / 1280 == 0 ? 1 : this.srcHeight / 1280) : (int)Math.ceil((double)this.srcHeight / (1280.0 / scale)));
        return mSampleSize;
    }

    private Bitmap rotatingImage(Bitmap bitmap) {
        if (this.srcExif == null) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        int angle = 0;
        int orientation = this.srcExif.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                angle = 90;
                break;
            }
            case 3: {
                angle = 180;
                break;
            }
            case 8: {
                angle = 270;
            }
        }
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }
}

