/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.service.KitService;
import com.xdja.im.core.utils.PingNet;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;

public class NetworkStatusReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            String state = intent.getStringExtra("pushcode");
            if ("10000".equals(state) && ImUiKit.getInstance().isInit()) {
                Intent serviceIntent = new Intent(context, KitService.class);
                serviceIntent.setAction("im.action.state");
                context.startService(serviceIntent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dealNetState(Context context) {
        if (ImUiKit.getInstance().isInit()) {
            if (NetworkUtil.isNetworkConnected(context)) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (NetworkStatusReceiver.this.isNetConnected()) {
                            try {
                                NetworkHelper.getHelper().receiveNetState(0);
                                IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                                networkStateEvent.setState(0);
                                BusProvider.getInstance().post(networkStateEvent);
                                LogUtil.d("NetworkHelper.NET_OK");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            try {
                                NetworkHelper.getHelper().receiveNetState(1);
                                IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                                networkStateEvent.setState(1);
                                BusProvider.getInstance().post(networkStateEvent);
                                LogUtil.d("NetworkHelper.NO_SERVER");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }).start();
            } else {
                try {
                    NetworkHelper.getHelper().receiveNetState(2);
                    IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                    networkStateEvent.setState(2);
                    BusProvider.getInstance().post(networkStateEvent);
                    LogUtil.d("NetworkHelper.NET_DISABLED");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                NetworkHelper.getHelper().receiveNetState(0);
                IMProxyEvent.NetworkStateEvent networkStateEvent = new IMProxyEvent.NetworkStateEvent();
                networkStateEvent.setState(0);
                BusProvider.getInstance().post(networkStateEvent);
                LogUtil.d("NetworkHelper.NET_OK");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized boolean isNetConnected() {
        try {
            String imUrl = ImUiKit.getInstance().getComponent().configCache().getServer().getImUrl();
            int state = PingNet.pingIpAddress(imUrl);
            LogUtil.d("state" + state);
            return state == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

