/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.utils;

import android.database.Cursor;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.body.IMFileBody;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IMFileTools {
    private static final String CONTACT_FILES_AUTHORITY = "com.android.contacts.files";
    private static final String DOWNLOAD_FILES_AUTHORITY = "com.android.providers.downloads.documents";
    private static final String CONTACT_FILES_PATH = "/Android/data/com.android.contacts/cache/";
    public static final String[] mImageSuffix = new String[]{".bmp", ".png", ".jpg", ".jpeg", ".gif"};
    public static final String[] mDocSuffix = new String[]{".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", ".pdf", ".wps", ".pps", ".txt"};
    public static final String[] mZipSuffix = new String[]{".rar", ".tar", ".zip", ".gz"};
    public static final String[] mApkSuffix = new String[]{".apk"};
    public static String[] mVideoSuffix = new String[]{".asf", ". asx", ".avi", ".fvi", ".lsf", ".lsx", ".mng", ".mov", ".movie", ".mp4", ".mpe", ".mpeg", ".mpg", ".mpg4", ".pvx", ".qt", ".rv", ".vdo", ".viv", ".vivo", ".wm", ".wmx", ".wv", ".wvx"};
    public static String[] mVoiceSuffix = new String[]{".aif", ".aifc", ".aiff", ".snd", ".smz", ".smd", ".als", ".au", ".awb", ".rm", ".ram", ".ra", ".es", ".esl", ".imy", ".qcp", ".pae", ".pac", ".it", ".xmz", ".xm", ".nsnd", ".mpga", ".mp3", ".wmv", ".wma", ".wax", ".mp2", ".mod", ".mio", ".wav", ".vql", ".vqf", ".midi", ".mid", ".mdz", ".vqe", ".vox", ".vib", ".ma5", ".ma3", ".ma2", ".ult", ".tsi", ".stm", ".ma1", ".m3url", ".m3u", ".s3z", ".s3m", ".rpm", ".m15", ".itz", ".rmf", ".rmvb", ".rmm", ".aac", ".3gpp", ".amr", ".flac", ".ota", ".kar", ".rtttl", ".xmf", ".mxmf", ".m4a", ".sid", ".gsm", ".mka", ".pls", ".sd2"};
    public static final String[] mImageArgs = new String[]{"image/bmp", "image/png", "image/jpeg", "image/jpeg", "image/gif"};
    public static final String[] mDocMimeArgs = new String[]{"application/msword", "application/vnd.ms-excel", "application/mspowerpoint", "application/pdf", "application/vnd.ms-works", "application/vnd.ms-powerpoint", "text/plain"};
    public static final String[] mDocSuffixArgs = new String[]{".docx", ".pptx", ".xlsx"};
    public static final String[] mZipMimeArgs = new String[]{"application/zip"};
    public static final String[] mZipSuffixArgs = new String[]{".tar", ".rar", ".gz"};
    public static String[] mFilterType = new String[]{"audio/", "video/", "text/x-vcard", "application/", "web/", "*/*"};
    public static String[] mShareType = new String[]{"audio/", "text/x-vcard", "application/", "*/*"};
    private static final String[] mImageSelectionArgs = new String[mImageSuffix.length];
    private static final String[] mDocSelectionArgs = new String[mDocSuffix.length];
    private static final String[] mZipSelectionArgs = new String[mZipSuffix.length];
    private static final String[] mApkSelectionArgs = new String[mApkSuffix.length];
    private static final long ONE_DAY_TIME_MILLIS = 86400000L;
    public static final int TIME_WITHIN_TODAY = 0;
    public static final int TIME_YESTERDAY = 1;
    public static final int TIME_WITHIN_WEEK = 2;
    public static final int TIME_WITHIN_MONTH = 3;
    public static final int TIME_WITHIN_MONTH_AGO = 4;

    private static String buildImageSelection() {
        StringBuilder selection = new StringBuilder();
        for (int i = 0; i < mImageArgs.length; ++i) {
            if (i > 0) {
                selection.append(" OR ");
            }
            selection.append("mime_type =? ");
            IMFileTools.mImageSelectionArgs[i] = mImageArgs[i];
        }
        return selection.toString();
    }

    private static String buildDocSelection() {
        StringBuilder selection = new StringBuilder();
        for (int i = 0; i < mDocMimeArgs.length; ++i) {
            if (i > 0) {
                selection.append(" OR ");
            }
            selection.append("mime_type =?");
            IMFileTools.mDocSelectionArgs[i] = mDocMimeArgs[i];
        }
        int size = mDocMimeArgs.length;
        for (int i = 0; i < mDocSuffixArgs.length; ++i) {
            selection.append(" OR ");
            selection.append("_data LIKE ? ");
            IMFileTools.mDocSelectionArgs[size + i] = "%" + mDocSuffixArgs[i];
        }
        return selection.toString();
    }

    private static String buildZipSelection() {
        StringBuilder selection = new StringBuilder();
        selection.append("mime_type =? ");
        IMFileTools.mZipSelectionArgs[0] = mZipMimeArgs[0];
        int size = mZipMimeArgs.length;
        for (int i = 0; i < mZipSuffixArgs.length; ++i) {
            selection.append(" OR ");
            selection.append("_data LIKE ? ");
            IMFileTools.mZipSelectionArgs[size + i] = "%" + mZipSuffixArgs[i];
        }
        return selection.toString();
    }

    private static String buildApkSelection() {
        StringBuilder selection = new StringBuilder();
        for (int i = 0; i < mApkSuffix.length; ++i) {
            if (i > 0) {
                selection.append(" OR ");
            }
            selection.append("_data LIKE ? ");
            IMFileTools.mApkSelectionArgs[i] = "%" + mApkSuffix[i];
        }
        return selection.toString();
    }

    private static boolean isImageType(String path) {
        return IMFileTools.matchStringInArray(path, mImageSuffix);
    }

    private static boolean isVideoType(String path) {
        return IMFileTools.matchStringInArray(path, mVideoSuffix);
    }

    private static boolean isAudioType(String path) {
        return IMFileTools.matchStringInArray(path, mVoiceSuffix);
    }

    private static boolean isDocType(String path) {
        return IMFileTools.matchStringInArray(path, mDocSuffix);
    }

    private static boolean isZipType(String path) {
        return IMFileTools.matchStringInArray(path, mZipSuffix);
    }

    private static boolean isApkType(String path) {
        return IMFileTools.matchStringInArray(path, mApkSuffix);
    }

    private static boolean matchStringInArray(String path, String[] arry) {
        String pathLower = path.toLowerCase(Locale.getDefault());
        for (String suffix : arry) {
            if (!pathLower.endsWith(suffix) || pathLower.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String getSuffixFromFilepath(String filepath) {
        if (TextUtils.isEmpty((CharSequence)filepath)) {
            return "";
        }
        int pos = filepath.lastIndexOf(46);
        if (pos != -1) {
            return filepath.substring(pos + 1, filepath.length());
        }
        return "";
    }

    private static String getDocFileTypeFromFilepath(String filepath) {
        String docFileType = null;
        String suffix = IMFileTools.getSuffixFromFilepath(filepath);
        if (suffix != null) {
            docFileType = "docx".equals(suffix = suffix.toLowerCase(Locale.getDefault())) || "doc".equals(suffix) ? "WORD" : ("xlsx".equals(suffix) || "xls".equals(suffix) ? "EXCEL" : ("ppsx".equals(suffix) || "pps".equals(suffix) ? "PPS" : ("pptx".equals(suffix) || "ppt".equals(suffix) ? "PPT" : ("pdf".equals(suffix) || "wps".equals(suffix) ? "PDF" : suffix.toUpperCase(Locale.getDefault())))));
        }
        return docFileType;
    }

    private static int getDocFileType(String filepath) {
        int fileType = 0;
        String suffix = IMFileTools.getSuffixFromFilepath(filepath);
        if (suffix != null) {
            fileType = "docx".equals(suffix = suffix.toLowerCase(Locale.getDefault())) || "doc".equals(suffix) ? 6 : ("xlsx".equals(suffix) || "xls".equals(suffix) ? 8 : ("ppsx".equals(suffix) || "pps".equals(suffix) || "pdf".equals(suffix) || "wps".equals(suffix) ? 9 : ("pptx".equals(suffix) || "ppt".equals(suffix) ? 7 : ("txt".equals(suffix) ? 5 : 11))));
        }
        return fileType;
    }

    private static String getZipFileTypeFromFilepath(String filepath) {
        String docFileType = null;
        String suffix = IMFileTools.getSuffixFromFilepath(filepath);
        if (suffix != null) {
            if ("tar".equals(suffix = suffix.toLowerCase(Locale.getDefault())) || "gtar".equals(suffix)) {
                docFileType = "TAR";
            } else if ("zip".equals(suffix)) {
                docFileType = "ZIP";
            } else if ("7z".equals(suffix)) {
                docFileType = "7Z";
            } else if ("rar".equals(suffix)) {
                docFileType = "RAR";
            } else if ("gz".equals(suffix) || "tgz".equals(suffix)) {
                docFileType = "GZ";
            }
        }
        return docFileType;
    }

    public static Map<String, List<FileItem>> queryLocalImages() {
        HashMap<String, List<FileItem>> imageMap = new HashMap<String, List<FileItem>>();
        String[] projection = new String[]{"_data", "_size", "date_modified", "mime_type"};
        String sortOrder = "date_modified desc";
        Cursor cursor = ImUiKit.getInstance().getContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, sortOrder);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String parentName;
                File parentFile;
                File pathFile;
                long fileSize;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (TextUtils.isEmpty((CharSequence)filePath) || (fileSize = (pathFile = new File(filePath)).length()) <= 0L || !pathFile.canRead() || (parentFile = new File(filePath).getParentFile()) == null || TextUtils.isEmpty((CharSequence)(parentName = parentFile.getName()))) continue;
                FileItem localFileInfo = new FileItem(IMFileTools.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 3);
                if (imageMap.containsKey(parentName)) {
                    ((List)imageMap.get(parentName)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                imageMap.put(parentName, fileInfoList);
            }
            cursor.close();
        }
        return imageMap;
    }

    public static Map<String, List<FileItem>> queryLocalAudios() {
        HashMap<String, List<FileItem>> audioMap = new HashMap<String, List<FileItem>>();
        String[] str = new String[]{"_id", "_data", "_size", "date_modified"};
        Cursor cursor = ImUiKit.getInstance().getContext().getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, str, null, null, "date_modified desc");
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String parentName;
                File parentFile;
                long fileSize;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (TextUtils.isEmpty((CharSequence)filePath) || (fileSize = new File(filePath).length()) <= 0L) continue;
                FileItem FileItem2 = new FileItem(IMFileTools.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 1);
                String path = cursor.getString(cursor.getColumnIndex("_data"));
                File pathFile = new File(path);
                if (!pathFile.canRead() || (parentFile = new File(path).getParentFile()) == null || TextUtils.isEmpty((CharSequence)(parentName = parentFile.getName()))) continue;
                if (audioMap.containsKey(parentName)) {
                    ((List)audioMap.get(parentName)).add(FileItem2);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(FileItem2);
                audioMap.put(parentName, fileInfoList);
            }
            cursor.close();
        }
        return audioMap;
    }

    public static Map<String, List<FileItem>> queryLocalVideos() {
        HashMap<String, List<FileItem>> videoMap = new HashMap<String, List<FileItem>>();
        String[] str = new String[]{"_id", "_data", "_size", "date_modified", "description"};
        Cursor cursor = ImUiKit.getInstance().getContext().getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, str, null, null, "date_modified desc");
        if (cursor != null) {
            while (cursor.moveToNext()) {
                File parentFile;
                File pathFile;
                long fileSize;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                String desc = cursor.getString(cursor.getColumnIndex("description"));
                if (TextUtils.isEmpty((CharSequence)filePath) || (fileSize = (pathFile = new File(filePath)).length()) <= 0L || !pathFile.canRead() || (parentFile = new File(filePath).getParentFile()) == null) continue;
                FileItem localFileInfo = new FileItem(IMFileTools.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 2);
                localFileInfo.setExtraInfo(desc);
                String parentName = parentFile.getName();
                if (videoMap.containsKey(parentName)) {
                    ((List)videoMap.get(parentName)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                videoMap.put(parentName, fileInfoList);
            }
            cursor.close();
        }
        return videoMap;
    }

    public static Map<String, List<FileItem>> queryLocalDocuments() {
        HashMap<String, List<FileItem>> documentMap = new HashMap<String, List<FileItem>>();
        String[] projection = new String[]{"_data", "_size", "date_modified", "mime_type"};
        String sortOrder = "date_modified desc";
        Cursor cursor = ImUiKit.getInstance().getContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, IMFileTools.buildDocSelection(), mDocSelectionArgs, sortOrder);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String fileType;
                File pathFile;
                long fileSize;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (TextUtils.isEmpty((CharSequence)filePath) || (fileSize = (pathFile = new File(filePath)).length()) <= 0L || !pathFile.canRead() || TextUtils.isEmpty((CharSequence)(fileType = IMFileTools.getDocFileTypeFromFilepath(filePath)))) continue;
                FileItem localFileInfo = new FileItem(IMFileTools.getNameFromFilepath(filePath), filePath, fileSize, dateTime, IMFileTools.getDocFileType(filePath));
                if (documentMap.containsKey(fileType)) {
                    ((List)documentMap.get(fileType)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                documentMap.put(fileType, fileInfoList);
            }
            cursor.close();
        }
        return documentMap;
    }

    public static Map<String, List<FileItem>> queryLocalApplication() {
        HashMap<String, List<FileItem>> applicationMap = new HashMap<String, List<FileItem>>();
        String[] str = new String[]{"_data", "_size", "date_modified"};
        Cursor cursor = ImUiKit.getInstance().getContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), str, IMFileTools.buildApkSelection(), mApkSelectionArgs, "date_modified desc");
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String fileType;
                File parentFile;
                File pathFile;
                long fileSize;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (TextUtils.isEmpty((CharSequence)filePath) || (fileSize = (pathFile = new File(filePath)).length()) <= 0L || !pathFile.canRead() || (parentFile = new File(filePath).getParentFile()) == null || TextUtils.isEmpty((CharSequence)(fileType = IMFileTools.getSuffixFromFilepath(filePath)))) continue;
                String parentName = parentFile.getName();
                FileItem localFileInfo = new FileItem(IMFileTools.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 4);
                if (applicationMap.containsKey(parentName)) {
                    ((List)applicationMap.get(parentName)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                applicationMap.put(parentName, fileInfoList);
            }
            cursor.close();
        }
        return applicationMap;
    }

    public static Map<String, List<FileItem>> queryOtherFiles() {
        HashMap<String, List<FileItem>> othersMap = new HashMap<String, List<FileItem>>();
        String[] projection = new String[]{"_data", "_size", "date_modified", "mime_type"};
        String sortOrder = "date_modified desc ";
        Cursor cursor = ImUiKit.getInstance().getContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, null, null, sortOrder);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String fileType;
                File pathFile;
                long fileSize;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (TextUtils.isEmpty((CharSequence)filePath) || (fileSize = (pathFile = new File(filePath)).length()) <= 0L || !pathFile.canRead() || TextUtils.isEmpty((CharSequence)(fileType = IMFileTools.getZipFileTypeFromFilepath(filePath)))) continue;
                fileType = fileType.toUpperCase(Locale.getDefault());
                FileItem localFileInfo = new FileItem(IMFileTools.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 10);
                if (othersMap.containsKey(fileType)) {
                    ((List)othersMap.get(fileType)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                othersMap.put(fileType, fileInfoList);
            }
            cursor.close();
        }
        return othersMap;
    }

    public static Map<String, List<FileItem>> getLastFileList(List<IMMessage> imMessageList) {
        LinkedHashMap<String, List<FileItem>> lastFileMap = new LinkedHashMap<String, List<FileItem>>();
        for (IMMessage file : imMessageList) {
            if (file == null || !file.isFileIMMessage()) continue;
            String mapKey = String.valueOf(IMFileTools.getTimeLineType(file.getIMMessageTime()));
            IMFileBody fileBody = (IMFileBody)file.getMessageBody();
            FileItem localFileInfo = new FileItem(fileBody.getDisplayName(), fileBody.getLocalPath(), fileBody.getFileSize(), file.getIMMessageTime(), fileBody.getType());
            if (lastFileMap.containsKey(mapKey)) {
                ((List)lastFileMap.get(mapKey)).add(localFileInfo);
                continue;
            }
            ArrayList<FileItem> localFileList = new ArrayList<FileItem>();
            localFileList.add(localFileInfo);
            lastFileMap.put(mapKey, localFileList);
        }
        return lastFileMap;
    }

    private static String getNameFromFilepath(String filepath) {
        int pos = filepath.lastIndexOf(File.separator);
        if (pos != -1) {
            return filepath.substring(pos + 1);
        }
        return "";
    }

    public static int getTimeLineType(long millis) {
        int timeLineType = millis > IMFileTools.getTimeToMorning() ? 0 : (millis > IMFileTools.getTimeToYesterdayMorning() ? 1 : (millis > IMFileTools.getTimeToWeekMorning() ? 2 : (millis > IMFileTools.getTimeToMonthMorning() ? 3 : 4)));
        return timeLineType;
    }

    private static long getTimeToMorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private static long getTimeToYesterdayMorning() {
        return IMFileTools.getTimeToMorning() - 86400000L;
    }

    private static long getTimeToWeekMorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTimeInMillis();
    }

    private static long getTimeToMonthMorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTimeInMillis();
    }

    public static int getFileTypeFromFilepath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return 0;
        }
        if (IMFileTools.isImageType(filePath)) {
            return 3;
        }
        if (IMFileTools.isVideoType(filePath)) {
            return 2;
        }
        if (IMFileTools.isAudioType(filePath)) {
            return 1;
        }
        if (IMFileTools.isDocType(filePath)) {
            return IMFileTools.getDocFileType(filePath);
        }
        if (IMFileTools.isApkType(filePath)) {
            return 4;
        }
        if (IMFileTools.isZipType(filePath)) {
            return 10;
        }
        return 0;
    }

    public static int getFileIconResId(int fileType) {
        int resId;
        switch (fileType) {
            case 1: {
                resId = R.mipmap.im_uikit_ic_music;
                break;
            }
            case 2: {
                resId = R.mipmap.im_uikit_ic_video;
                break;
            }
            case 3: {
                resId = R.mipmap.im_uikit_ic_jpg;
                break;
            }
            case 6: {
                resId = R.mipmap.im_uikit_ic_doc;
                break;
            }
            case 5: {
                resId = R.mipmap.im_uikit_ic_text;
                break;
            }
            case 8: {
                resId = R.mipmap.im_uikit_ic_excel;
                break;
            }
            case 9: {
                resId = R.mipmap.im_uikit_ic_pdf;
                break;
            }
            case 7: {
                resId = R.mipmap.im_uikit_ic_ppt;
                break;
            }
            case 4: {
                resId = R.mipmap.im_uikit_ic_apk;
                break;
            }
            case 10: {
                resId = R.mipmap.im_uikit_ic_others;
                break;
            }
            default: {
                resId = R.mipmap.im_uikit_ic_others;
            }
        }
        return resId;
    }
}

