/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.ui.viewholder;

import android.app.Activity;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.album.ImageDataSource;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.ui.viewholder.BaseViewHolder;
import com.xdja.im.uikit.R;

public class ImageViewHolder
extends BaseViewHolder {
    private ImageView mTargetImg = (ImageView)this.findViewById(R.id.img_local_image);
    public CheckBox mSelectChx = (CheckBox)this.findViewById(R.id.chx_item_select);
    private View mMaskView = this.findViewById(R.id.mask);

    public ImageViewHolder(final Activity activity, View itemView) {
        super(activity, itemView);
        this.mSelectChx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            }
        });
        this.mSelectChx.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int selectLimit = ImagePickerManager.getInstance().getConfig().getMaxSelectNum();
                if (ImageViewHolder.this.mSelectChx.isChecked() && ImageDataSource.getInstance().getSelects().size() >= selectLimit) {
                    ImageViewHolder.this.mSelectChx.setChecked(false);
                    ImageViewHolder.this.mMaskView.setVisibility(8);
                    CommonTool.showToast(String.format(activity.getString(R.string.im_uikit_img_select_limit), selectLimit));
                    return;
                }
                if (ImageViewHolder.this.mSelectChx.isChecked()) {
                    ImageViewHolder.this.mMaskView.setVisibility(0);
                } else {
                    ImageViewHolder.this.mMaskView.setVisibility(8);
                }
                if (ImageViewHolder.this.mItemDataChangedListener != null) {
                    ImageViewHolder.this.mItemDataChangedListener.onDataChanged(ImageViewHolder.this.getLayoutPosition(), ImageViewHolder.this.mSelectChx.isChecked());
                }
            }
        });
    }

    @Override
    public void bindData(final ImageItem data) {
        if (data == null) {
            this.mTargetImg.setImageResource(R.mipmap.im_uikit_pic_default);
            return;
        }
        boolean isSelected = ImageDataSource.getInstance().getSelects().contains(data);
        this.mSelectChx.setChecked(isSelected);
        if (isSelected) {
            this.mMaskView.setVisibility(0);
        } else {
            this.mMaskView.setVisibility(8);
        }
        this.mTargetImg.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageViewHolder.this.mItemClickListener != null) {
                    ImageViewHolder.this.mItemClickListener.onItemClick(ImageViewHolder.this.getLayoutPosition(), data);
                }
            }
        });
        try {
            Glide.with((Activity)this.mActivity).load(data.getPath()).error(R.mipmap.im_uikit_pic_default).into(this.mTargetImg);
        }
        catch (Exception e) {
            this.mTargetImg.setImageResource(R.mipmap.im_uikit_pic_default);
        }
        catch (OutOfMemoryError e) {
            this.mTargetImg.setImageResource(R.mipmap.im_uikit_pic_default);
        }
    }
}

