/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.handler;

import com.xdja.im.lib.filemanage.error.OkException;
import com.xdja.im.lib.filemanage.error.OkHandler;
import com.xdja.im.lib.filemanage.error.OkNetMatcher;
import com.xdja.im.uikit.utils.log.LogUtil;
import rx.Subscriber;

public class OkSubscriber<T>
extends Subscriber<T> {
    private final OkHandler<OkException> handler;

    public OkSubscriber(OkHandler<OkException> handler) {
        this.handler = handler;
    }

    public void onCompleted() {
        LogUtil.i("", "---------------------onCompleted-------------------");
    }

    public void onError(Throwable e) {
        LogUtil.e("", "---------------------onError-------------------");
        if (e == null) {
            return;
        }
        if (e instanceof OkException) {
            OkException oe = (OkException)e;
            if (oe.getOkMessage() != null && oe.getOkMessage().contains("ExtCertPathValidatorException")) {
                oe.setOkCode("CODE_SSLHANDLE_FAILD");
                oe.setOkMessage(OkNetMatcher.USSLHANDLE_FAILD_USERMSG);
            }
            if (this.handler != null) {
                this.handler.handle(oe);
            }
        } else {
            LogUtil.e("", e.getMessage());
        }
    }

    public void onNext(T t) {
        LogUtil.i("", "---------------------onNext-------------------");
    }

    public void onStart() {
        super.onStart();
        LogUtil.i("", "---------------------onStart-------------------");
    }
}

