/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.util;

import android.content.ClipData;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.SystemClock;
import android.provider.ContactsContract;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.model.LocalPictureInfo;
import com.xdja.im.lib.filemanage.model.MediaFileInfo;
import com.xdja.im.lib.filemanage.model.ShareInfo;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.share.util.ShareUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.model.IMMessage;
import com.xdja.imsdk.model.body.IMFileBody;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class IMFileUtils {
    private static final String CONTACT_FILES_AUTHORITY = "com.android.contacts.files";
    private static final String DOWNLOAD_FILES_AUTHORITY = "com.android.providers.downloads.documents";
    private static final String CONTACT_FILES_PATH = "/Android/data/com.android.contacts/cache/";
    public static final String[] mImageSuffix = new String[]{".bmp", ".png", ".jpg", ".jpeg", ".jpe", ".gif"};
    public static final String[] mDocSuffix = new String[]{".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", ".pdf", ".wps", ".pps", ".txt"};
    public static final String[] mZipSuffix = new String[]{".rar", ".tar", ".zip", ".gz"};
    public static final String[] mApkSuffix = new String[]{".apk"};
    public static String[] mVideoSuffix = new String[]{".asf", ". asx", ".avi", ".fvi", ".lsf", ".lsx", ".mng", ".mov", ".movie", ".mp4", ".mpe", ".mpeg", ".mpg", ".mpg4", ".pvx", ".qt", ".rv", ".vdo", ".viv", ".vivo", ".wm", ".wmx", ".wv", ".wvx", ".3gp"};
    public static String[] mVoiceSuffix = new String[]{".aif", ".aifc", ".aiff", ".snd", ".smz", ".smd", ".als", ".au", ".awb", ".rm", ".ram", ".ra", ".es", ".esl", ".imy", ".qcp", ".pae", ".pac", ".it", ".xmz", ".xm", ".nsnd", ".mpga", ".mp3", ".wmv", ".wma", ".wax", ".mp2", ".mod", ".mio", ".wav", ".vql", ".vqf", ".midi", ".mid", ".mdz", ".vqe", ".vox", ".vib", ".ma5", ".ma3", ".ma2", ".ult", ".tsi", ".stm", ".ma1", ".m3url", ".m3u", ".s3z", ".s3m", ".rpm", ".m15", ".itz", ".rmf", ".rmvb", ".rmm", ".aac", ".3gpp", ".amr", ".flac", ".ota", ".kar", ".rtttl", ".xmf", ".mxmf", ".m4a", ".sid", ".gsm", ".mka", ".pls", ".sd2"};
    public static final String[] mImageArgs = new String[]{"image/bmp", "image/png", "image/jpeg", "image/jpeg", "image/jpe", "image/gif"};
    public static final String[] mDocMimeArgs = new String[]{"application/msword", "application/vnd.ms-excel", "application/mspowerpoint", "application/pdf", "application/vnd.ms-works", "application/vnd.ms-powerpoint", "text/plain"};
    public static final String[] mDocSuffixArgs = new String[]{".docx", ".pptx", ".xlsx"};
    public static final String[] mZipMimeArgs = new String[]{"application/zip"};
    public static final String[] mZipSuffixArgs = new String[]{".tar", ".rar", ".gz"};
    public static String[] mFilterType = new String[]{"audio/", "video/", "text/x-vcard", "application/", "*/*"};
    public static String[] mShareType = new String[]{"audio/", "text/x-vcard", "application/", "*/*"};
    private static final String[] mImageSelectionArgs = new String[mImageSuffix.length];
    private static final String[] mDocSelectionArgs = new String[mDocSuffix.length];
    private static final String[] mZipSelectionArgs = new String[mZipSuffix.length];
    private static final String[] mApkSelectionArgs = new String[mApkSuffix.length];
    private static final long ONE_DAY_TIME_MILLIS = 86400000L;
    public static final int TIME_WITHIN_TODAY = 0;
    public static final int TIME_YESTERDAY = 1;
    public static final int TIME_WITHIN_WEEK = 2;
    public static final int TIME_WITHIN_MONTH = 3;
    public static final int TIME_WITHIN_MONTH_AGO = 4;

    private static String buildImageSelection() {
        StringBuilder selection = new StringBuilder();
        for (int i = 0; i < mImageArgs.length; ++i) {
            if (i > 0) {
                selection.append(" OR ");
            }
            selection.append("mime_type =? ");
            IMFileUtils.mImageSelectionArgs[i] = mImageArgs[i];
        }
        return selection.toString();
    }

    private static String buildDocSelection() {
        StringBuilder selection = new StringBuilder();
        for (int i = 0; i < mDocMimeArgs.length; ++i) {
            if (i > 0) {
                selection.append(" OR ");
            }
            selection.append("mime_type =?");
            IMFileUtils.mDocSelectionArgs[i] = mDocMimeArgs[i];
        }
        int size = mDocMimeArgs.length;
        for (int i = 0; i < mDocSuffixArgs.length; ++i) {
            selection.append(" OR ");
            selection.append("_data LIKE ? ");
            IMFileUtils.mDocSelectionArgs[size + i] = "%" + mDocSuffixArgs[i];
        }
        return selection.toString();
    }

    private static String buildZipSelection() {
        StringBuilder selection = new StringBuilder();
        for (int i = 0; i < mZipMimeArgs.length; ++i) {
            if (i > 0) {
                selection.append(" OR ");
            }
            selection.append("mime_type =? ");
            IMFileUtils.mZipSelectionArgs[i] = mZipMimeArgs[i];
        }
        int size = mZipMimeArgs.length;
        for (int i = 0; i < mZipSuffixArgs.length; ++i) {
            selection.append(" OR ");
            selection.append("_data LIKE ? ");
            IMFileUtils.mZipSelectionArgs[size + i] = "%" + mZipSuffixArgs[i];
        }
        return selection.toString();
    }

    private static String buildApkSelection() {
        StringBuilder selection = new StringBuilder();
        for (int i = 0; i < mApkSuffix.length; ++i) {
            if (i > 0) {
                selection.append(" OR ");
            }
            selection.append("_data LIKE ? ");
            IMFileUtils.mApkSelectionArgs[i] = "%" + mApkSuffix[i];
        }
        return selection.toString();
    }

    private static boolean isImageType(String path) {
        return IMFileUtils.matchStringInArray(path, mImageSuffix);
    }

    private static boolean isVideoType(String path) {
        return IMFileUtils.matchStringInArray(path, mVideoSuffix);
    }

    private static boolean isAudioType(String path) {
        return IMFileUtils.matchStringInArray(path, mVoiceSuffix);
    }

    private static boolean isDocType(String path) {
        return IMFileUtils.matchStringInArray(path, mDocSuffix);
    }

    private static boolean isZipType(String path) {
        return IMFileUtils.matchStringInArray(path, mZipSuffix);
    }

    private static boolean isApkType(String path) {
        return IMFileUtils.matchStringInArray(path, mApkSuffix);
    }

    private static boolean matchStringInArray(String path, String[] arry) {
        String pathLower = path.toLowerCase(Locale.getDefault());
        for (String suffix : arry) {
            if (!pathLower.endsWith(suffix) || pathLower.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String getSuffixFromFilepath(String filepath) {
        int pos = filepath.lastIndexOf(46);
        if (pos != -1) {
            return filepath.substring(pos + 1, filepath.length());
        }
        return null;
    }

    private static String getDocFileTypeFromFilepath(String filepath) {
        String docFileType = null;
        String suffix = IMFileUtils.getSuffixFromFilepath(filepath);
        if (suffix != null) {
            docFileType = "docx".equals(suffix = suffix.toLowerCase(Locale.getDefault())) || "doc".equals(suffix) ? "WORD" : ("xlsx".equals(suffix) || "xls".equals(suffix) ? "EXCEL" : ("ppsx".equals(suffix) || "pps".equals(suffix) ? "PPS" : ("pptx".equals(suffix) || "ppt".equals(suffix) ? "PPT" : ("pdf".equals(suffix) || "wps".equals(suffix) ? "PDF" : suffix.toUpperCase(Locale.getDefault())))));
        }
        return docFileType;
    }

    private static int getDocFileType(String filepath) {
        int fileType = 0;
        String suffix = IMFileUtils.getSuffixFromFilepath(filepath);
        if (suffix != null) {
            fileType = "docx".equals(suffix = suffix.toLowerCase(Locale.getDefault())) || "doc".equals(suffix) ? 6 : ("xlsx".equals(suffix) || "xls".equals(suffix) ? 8 : ("ppsx".equals(suffix) || "pps".equals(suffix) || "pdf".equals(suffix) || "wps".equals(suffix) ? 9 : ("pptx".equals(suffix) || "ppt".equals(suffix) ? 7 : ("txt".equals(suffix) ? 5 : 11))));
        }
        return fileType;
    }

    public static int getFileTypeFromFilepath(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return 0;
        }
        if (IMFileUtils.isImageType(filePath)) {
            return 3;
        }
        if (IMFileUtils.isVideoType(filePath)) {
            return 2;
        }
        if (IMFileUtils.isAudioType(filePath)) {
            return 1;
        }
        if (IMFileUtils.isDocType(filePath)) {
            return IMFileUtils.getDocFileType(filePath);
        }
        if (IMFileUtils.isApkType(filePath)) {
            return 4;
        }
        if (IMFileUtils.isZipType(filePath)) {
            return 10;
        }
        return 0;
    }

    public static List<LocalPictureInfo> queryLocalPictures() {
        Uri mImageUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        ContentResolver mContentResolver = ActomaController.getApp().getContentResolver();
        String[] projection = new String[]{"_id", "_display_name", "_data", "_size", "width", "height", "mime_type"};
        String sortOrder = "date_modified desc";
        Cursor cursor = mContentResolver.query(mImageUri, projection, null, null, sortOrder);
        ArrayList<LocalPictureInfo> localPicInfoList = new ArrayList<LocalPictureInfo>();
        if (cursor != null) {
            while (cursor.moveToNext()) {
                int width = cursor.getInt(cursor.getColumnIndex("width"));
                int height = cursor.getInt(cursor.getColumnIndex("height"));
                String path = cursor.getString(cursor.getColumnIndex("_data"));
                String name = cursor.getString(cursor.getColumnIndex("_display_name"));
                int size = cursor.getInt(cursor.getColumnIndex("_size"));
                String suffix = cursor.getString(cursor.getColumnIndex("mime_type"));
                suffix = suffix.substring(suffix.indexOf("/") + 1);
                if (width > 0 && height > 0) {
                    LocalPictureInfo info = new LocalPictureInfo(name, path, size);
                    info.setSuffix(suffix);
                    localPicInfoList.add(info);
                    continue;
                }
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                if (options.outWidth <= 0 || options.outHeight <= 0) continue;
                LocalPictureInfo info = new LocalPictureInfo(name, path, size);
                info.setSuffix(suffix);
                localPicInfoList.add(info);
            }
            cursor.close();
        }
        return localPicInfoList;
    }

    public static Map<String, List<FileItem>> queryLocalImages() {
        HashMap<String, List<FileItem>> imageMap = new HashMap<String, List<FileItem>>();
        String[] projection = new String[]{"_data", "_size", "date_modified", "mime_type"};
        String sortOrder = "date_modified desc";
        Cursor cursor = ActomaController.getApp().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, IMFileUtils.buildImageSelection(), mImageSelectionArgs, sortOrder);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String parentName;
                File parentFile;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long fileSize = cursor.getLong(cursor.getColumnIndex("_size"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (fileSize <= 0L || TextUtils.isEmpty((CharSequence)filePath) || (parentFile = new File(filePath).getParentFile()) == null || TextUtils.isEmpty((CharSequence)(parentName = parentFile.getName()))) continue;
                FileItem localFileInfo = new FileItem(IMFileUtils.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 3);
                if (imageMap.containsKey(parentName)) {
                    ((List)imageMap.get(parentName)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                imageMap.put(parentName, fileInfoList);
            }
            cursor.close();
        }
        return imageMap;
    }

    public static Map<String, List<FileItem>> queryLocalAudios() {
        HashMap<String, List<FileItem>> audioMap = new HashMap<String, List<FileItem>>();
        String[] str = new String[]{"_id", "_data", "_size", "date_modified"};
        Cursor cursor = ActomaController.getApp().getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, str, null, null, "date_modified desc");
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String parentName;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long fileSize = cursor.getLong(cursor.getColumnIndex("_size"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (fileSize <= 0L || TextUtils.isEmpty((CharSequence)filePath)) continue;
                FileItem localFileInfo = new FileItem(IMFileUtils.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 1);
                String path = cursor.getString(cursor.getColumnIndex("_data"));
                File parentFile = new File(path).getParentFile();
                if (parentFile == null || TextUtils.isEmpty((CharSequence)(parentName = parentFile.getName()))) continue;
                if (audioMap.containsKey(parentName)) {
                    ((List)audioMap.get(parentName)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                audioMap.put(parentName, fileInfoList);
            }
            cursor.close();
        }
        return audioMap;
    }

    public static Map<String, List<FileItem>> queryLocalVideos() {
        HashMap<String, List<FileItem>> videoMap = new HashMap<String, List<FileItem>>();
        String[] str = new String[]{"_id", "_data", "_size", "date_modified", "description", "duration"};
        Cursor cursor = ActomaController.getApp().getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, str, null, null, "date_modified desc");
        if (cursor != null) {
            while (cursor.moveToNext()) {
                File parentFile;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long fileSize = cursor.getLong(cursor.getColumnIndex("_size"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                String desc = cursor.getString(cursor.getColumnIndex("description"));
                long duration = cursor.getLong(cursor.getColumnIndex("duration"));
                if (fileSize <= 0L || TextUtils.isEmpty((CharSequence)filePath) || (parentFile = new File(filePath).getParentFile()) == null) continue;
                FileItem localFileInfo = new FileItem(IMFileUtils.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 2);
                localFileInfo.setDuration(duration);
                localFileInfo.setExtraInfo(desc);
                String parentName = parentFile.getName();
                if (videoMap.containsKey(parentName)) {
                    ((List)videoMap.get(parentName)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                videoMap.put(parentName, fileInfoList);
            }
            cursor.close();
        }
        return videoMap;
    }

    public static Map<String, List<FileItem>> queryLocalDocuments() {
        HashMap<String, List<FileItem>> documentMap = new HashMap<String, List<FileItem>>();
        String[] projection = new String[]{"_data", "_size", "date_modified", "mime_type"};
        String sortOrder = "date_modified desc";
        Cursor cursor = ActomaController.getApp().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, IMFileUtils.buildDocSelection(), mDocSelectionArgs, sortOrder);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String fileType;
                long fileSize = cursor.getLong(cursor.getColumnIndex("_size"));
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (fileSize <= 0L || TextUtils.isEmpty((CharSequence)filePath) || TextUtils.isEmpty((CharSequence)(fileType = IMFileUtils.getDocFileTypeFromFilepath(filePath)))) continue;
                FileItem localFileInfo = new FileItem(IMFileUtils.getNameFromFilepath(filePath), filePath, fileSize, dateTime, IMFileUtils.getDocFileType(filePath));
                if (documentMap.containsKey(fileType)) {
                    ((List)documentMap.get(fileType)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                documentMap.put(fileType, fileInfoList);
            }
            cursor.close();
        }
        return documentMap;
    }

    public static Map<String, List<FileItem>> queryLocalApplication() {
        HashMap<String, List<FileItem>> applicationMap = new HashMap<String, List<FileItem>>();
        String[] str = new String[]{"_data", "_size", "date_modified"};
        Cursor cursor = ActomaController.getApp().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), str, IMFileUtils.buildApkSelection(), mApkSelectionArgs, "date_modified desc");
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String fileType;
                File parentFile;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long fileSize = cursor.getLong(cursor.getColumnIndex("_size"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (fileSize <= 0L || TextUtils.isEmpty((CharSequence)filePath) || (parentFile = new File(filePath).getParentFile()) == null || TextUtils.isEmpty((CharSequence)(fileType = IMFileUtils.getSuffixFromFilepath(filePath)))) continue;
                String parentName = parentFile.getName();
                FileItem localFileInfo = new FileItem(IMFileUtils.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 4);
                if (applicationMap.containsKey(parentName)) {
                    ((List)applicationMap.get(parentName)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                applicationMap.put(parentName, fileInfoList);
            }
            cursor.close();
        }
        return applicationMap;
    }

    public static Map<String, List<FileItem>> queryOtherFiles() {
        HashMap<String, List<FileItem>> othersMap = new HashMap<String, List<FileItem>>();
        String[] projection = new String[]{"_data", "_size", "date_modified", "mime_type"};
        String sortOrder = "date_modified desc ";
        Cursor cursor = ActomaController.getApp().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, IMFileUtils.buildZipSelection(), mZipSelectionArgs, sortOrder);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String fileType;
                String filePath = cursor.getString(cursor.getColumnIndex("_data"));
                long fileSize = cursor.getLong(cursor.getColumnIndex("_size"));
                long dateTime = cursor.getLong(cursor.getColumnIndex("date_modified")) * 1000L;
                if (fileSize <= 0L || TextUtils.isEmpty((CharSequence)filePath) || TextUtils.isEmpty((CharSequence)(fileType = IMFileUtils.getSuffixFromFilepath(filePath)))) continue;
                fileType = fileType.toUpperCase(Locale.getDefault());
                FileItem localFileInfo = new FileItem(IMFileUtils.getNameFromFilepath(filePath), filePath, fileSize, dateTime, 10);
                if (othersMap.containsKey(fileType)) {
                    ((List)othersMap.get(fileType)).add(localFileInfo);
                    continue;
                }
                ArrayList<FileItem> fileInfoList = new ArrayList<FileItem>();
                fileInfoList.add(localFileInfo);
                othersMap.put(fileType, fileInfoList);
            }
            cursor.close();
        }
        return othersMap;
    }

    public static Map<String, List<FileItem>> getLastFileList(List<IMMessage> imMessageList) {
        LinkedHashMap<String, List<FileItem>> lastFileMap = new LinkedHashMap<String, List<FileItem>>();
        for (IMMessage file : imMessageList) {
            if (file == null || !file.isFileIMMessage()) continue;
            String mapKey = String.valueOf(IMFileUtils.getTimeLineType(file.getIMMessageTime()));
            IMFileBody fileBody = (IMFileBody)file.getMessageBody();
            FileItem localFileInfo = new FileItem(fileBody.getDisplayName(), fileBody.getLocalPath(), fileBody.getFileSize(), file.getIMMessageTime(), fileBody.getType());
            if (lastFileMap.containsKey(mapKey)) {
                ((List)lastFileMap.get(mapKey)).add(localFileInfo);
                continue;
            }
            ArrayList<FileItem> localFileList = new ArrayList<FileItem>();
            localFileList.add(localFileInfo);
            lastFileMap.put(mapKey, localFileList);
        }
        return lastFileMap;
    }

    private static String getNameFromFilepath(String filepath) {
        int pos = filepath.lastIndexOf(File.separator);
        if (pos != -1) {
            return filepath.substring(pos + 1);
        }
        return "";
    }

    public static int getTimeLineType(long millis) {
        int timeLineType = millis > IMFileUtils.getTimeToMorning() ? 0 : (millis > IMFileUtils.getTimeToYesterdayMorning() ? 1 : (millis > IMFileUtils.getTimeToWeekMorning() ? 2 : (millis > IMFileUtils.getTimeToMonthMorning() ? 3 : 4)));
        return timeLineType;
    }

    private static long getTimeToMorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private static long getTimeToNight() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 24);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private static long getTimeToYesterdayMorning() {
        return IMFileUtils.getTimeToMorning() - 86400000L;
    }

    private static long getTimeToWeekMorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTimeInMillis();
    }

    public static long getTimeTOWeekNight() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime().getTime() + 604800000L;
    }

    private static long getTimeToMonthMorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTimeInMillis();
    }

    private static long getTimeToMonthNight() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 24);
        return cal.getTimeInMillis();
    }

    private static long getTimeToTwoMonthMorning() {
        return IMFileUtils.getTimeToMonthMorning() - 2592000000L;
    }

    public static FileItem queryLocalFiles(Context context, Uri fileUri) {
        if (fileUri == null) {
            return null;
        }
        String scheme = fileUri.getScheme();
        if (scheme == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)fileUri)) {
            String type;
            String[] split;
            String docId;
            if (IMFileUtils.isExternalStorageDocument(fileUri)) {
                docId = DocumentsContract.getDocumentId((Uri)fileUri);
                split = docId.split(":");
                if (split.length < 2) {
                    return null;
                }
                type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return IMFileUtils.getFileItem(Environment.getExternalStorageDirectory() + File.separator + split[1]);
                }
            }
            if (IMFileUtils.isDownloadsDocument(fileUri)) {
                String id2 = DocumentsContract.getDocumentId((Uri)fileUri);
                String downloadUri = "content://downloads/public_downloads";
                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)downloadUri), (long)Long.valueOf(id2));
                return IMFileUtils.getFileItemByUri(context, contentUri, null, null);
            }
            if (IMFileUtils.isMediaDocument(fileUri)) {
                docId = DocumentsContract.getDocumentId((Uri)fileUri);
                split = docId.split(":");
                if (split.length < 2) {
                    return null;
                }
                type = split[0];
                Uri contentUri = null;
                switch (type) {
                    case "image": {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                    case "video": {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                    case "audio": {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return IMFileUtils.getFileItemByUri(context, contentUri, selection, selectionArgs);
            }
            return null;
        }
        if (scheme.equals("content")) {
            if (IMFileUtils.isVcardUri(fileUri)) {
                return IMFileUtils.getFileItem(IMFileUtils.getVCardFilePath(context, fileUri));
            }
            if (IMFileUtils.isShareVcsUri(fileUri) && Build.VERSION.SDK_INT > 23) {
                String path = context.getExternalCacheDir().getPath() + File.separator + fileUri.getLastPathSegment();
                try {
                    InputStream inputStream = context.getContentResolver().openInputStream(fileUri);
                    FileOutputStream fileOutputStream = new FileOutputStream(path);
                    byte[] buf = new byte[1024];
                    while (inputStream.read(buf) != -1) {
                        fileOutputStream.write(buf);
                    }
                    fileOutputStream.close();
                    inputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return IMFileUtils.getFileItem(path);
            }
            return IMFileUtils.getFileItemByUri(context, fileUri, null, null);
        }
        if ("file".equalsIgnoreCase(fileUri.getScheme())) {
            if (IMFileUtils.isGooglePhotosUri(fileUri)) {
                return IMFileUtils.getFileItem(fileUri.getLastPathSegment());
            }
            return IMFileUtils.getFileItem(fileUri.getPath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File saveFirstFrame(String path) {
        MediaMetadataRetriever media = null;
        try {
            media = new MediaMetadataRetriever();
            media.setDataSource(path);
        }
        catch (IllegalArgumentException e) {
            LogUtil.d("share file", "\u4fdd\u5b58\u77ed\u89c6\u9891\u7b2c\u4e00\u5e27\u5931\u8d25\uff0c\u77ed\u89c6\u9891\u8def\u5f84\u9519\u8bef");
        }
        if (media == null) {
            return null;
        }
        Bitmap bitmap = media.getFrameAtTime(0L);
        String fileName = UUID.randomUUID().toString();
        BufferedOutputStream bos = null;
        File firstFrameFile = new File(ToolUtil.getVideoPath(), fileName);
        try {
            bos = new BufferedOutputStream(new FileOutputStream(firstFrameFile));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 20, (OutputStream)bos);
        }
        catch (Exception e) {
            LogUtil.e("share file", "Get video first frame fail");
            File file = null;
            return file;
        }
        finally {
            try {
                if (bos != null) {
                    bos.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return firstFrameFile;
    }

    public static int getVideoDuration(String path) {
        int dur = 0;
        try {
            MediaMetadataRetriever media = new MediaMetadataRetriever();
            media.setDataSource(path);
            String duration = media.extractMetadata(9);
            dur = Integer.valueOf(duration);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileItem getFileItemByUri(Context context, Uri fileUri, String selection, String[] selectionArgs) {
        String path = null;
        long size = 0L;
        long date = 0L;
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(fileUri, null, selection, selectionArgs, null);
            if (cursor == null) {
                FileItem fileItem = null;
                return fileItem;
            }
            if (!cursor.moveToFirst()) {
                FileItem fileItem = null;
                return fileItem;
            }
            int pathIndex = cursor.getColumnIndex("_data");
            int sizeIndex = cursor.getColumnIndex("_size");
            int dateIndex = cursor.getColumnIndex("date_modified");
            path = pathIndex == -1 ? null : cursor.getString(pathIndex);
            size = sizeIndex == -1 ? 0L : cursor.getLong(sizeIndex);
            long l = date = dateIndex == -1 ? 0L : cursor.getLong(dateIndex);
            if (TextUtils.isEmpty((CharSequence)path)) {
                String displayName;
                if (!fileUri.toString().contains("android.providers.downloads")) {
                    FileItem fileItem = null;
                    return fileItem;
                }
                int displayIndex = cursor.getColumnIndex("_display_name");
                String string2 = displayName = displayIndex == -1 ? null : cursor.getString(displayIndex);
                if (TextUtils.isEmpty((CharSequence)displayName)) {
                    FileItem fileItem = null;
                    return fileItem;
                }
                path = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + Environment.DIRECTORY_DOWNLOADS + File.separator + displayName;
                FileItem fileItem = IMFileUtils.getFileItem(path);
                return fileItem;
            }
        }
        if (TextUtils.isEmpty(path) || size == 0L) {
            return null;
        }
        return IMFileUtils.initFileItem(path, size, date);
    }

    public static FileItem getFileItem(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        long size = file.length();
        long date = file.lastModified();
        return IMFileUtils.initFileItem(path, size, date);
    }

    private static FileItem initFileItem(@NonNull String path, long size, long date) {
        int fileType = 11;
        if (IMFileUtils.isImageType(path)) {
            fileType = 3;
        } else if (IMFileUtils.isDocType(path)) {
            fileType = IMFileUtils.getDocFileType(path);
        } else if (IMFileUtils.isZipType(path)) {
            fileType = 10;
        } else if (IMFileUtils.isApkType(path)) {
            fileType = 4;
        } else if (IMFileUtils.isVideoFileType(path)) {
            fileType = 2;
        } else if (IMFileUtils.isAudioFileType(path)) {
            fileType = 1;
        }
        return new FileItem(IMFileUtils.getNameFromFilepath(path), path, size, date, fileType);
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return DOWNLOAD_FILES_AUTHORITY.equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    private static boolean isVcardUri(Uri uri) {
        String path = ContactsContract.Contacts.CONTENT_VCARD_URI.getAuthority();
        return TextUtils.equals((CharSequence)path, (CharSequence)uri.getAuthority());
    }

    private static boolean isShareVcsUri(Uri uri) {
        return uri.getAuthority().contains("com.android.calendar");
    }

    public static boolean isVideoFileType(String path) {
        return path != null && !TextUtils.isEmpty((CharSequence)path) && IMFileUtils.matchStringInArray(path, mVideoSuffix);
    }

    public static boolean isAudioFileType(String path) {
        return path != null && !TextUtils.isEmpty((CharSequence)path) && IMFileUtils.matchStringInArray(path, mVoiceSuffix);
    }

    private static boolean isObjectNotEmpty(Object o) {
        return o != null && !o.toString().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVCardFilePath(Context context, Uri contactUri) {
        if (contactUri == null) {
            return null;
        }
        ContentResolver cr = context.getContentResolver();
        try (Cursor cursor = null;){
            String disname;
            cursor = cr.query(contactUri, null, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                String string2 = null;
                return string2;
            }
            int disnameIndex = cursor.getColumnIndex("_display_name");
            String string3 = disname = disnameIndex != -1 ? cursor.getString(disnameIndex) : null;
            if (TextUtils.isEmpty((CharSequence)disname)) {
                String string4 = null;
                return string4;
            }
            String shareDirectory = "";
            shareDirectory = Build.VERSION.SDK_INT >= 24 ? Environment.getExternalStorageDirectory().getAbsolutePath() + "/" : ToolUtil.getShareDirectory();
            File parentFile = new File(shareDirectory);
            if (!parentFile.exists()) {
                parentFile.mkdir();
            }
            String path = shareDirectory + disname;
            IMFileUtils.createVCard(context, path, contactUri);
            String string5 = path;
            return string5;
        }
        return null;
    }

    private static void createVCard(Context context, String path, Uri contactUri) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            byte[] data = new byte[1024];
            AssetFileDescriptor afd = context.getContentResolver().openAssetFileDescriptor(contactUri, "r");
            if (afd != null) {
                int len;
                FileInputStream fs = afd.createInputStream();
                while ((len = fs.read(data)) != -1) {
                    fos.write(data, 0, len);
                }
                fos.close();
                fs.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getImagePathFormUri(Context context, Uri uri) {
        String path = null;
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return null;
        }
        if (scheme.equals("content")) {
            try (Cursor cursor = null;){
                cursor = context.getContentResolver().query(uri, null, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) {
                    String string2 = null;
                    return string2;
                }
                int pathIndex = cursor.getColumnIndex("_data");
                path = pathIndex == -1 ? null : cursor.getString(pathIndex);
                if (!TextUtils.isEmpty((CharSequence)path)) return path;
                int displayIndex = cursor.getColumnIndex("_display_name");
                String displayName = displayIndex == -1 ? null : cursor.getString(displayIndex);
                String string3 = IMFileUtils.getSpecialImagePath(uri, displayName);
                return string3;
            }
        } else {
            if (!scheme.equals("file")) return path;
            return uri.toString().replace("file://", "");
        }
    }

    private static String getSpecialImagePath(Uri imageUri, String displayName) {
        String authority;
        switch (authority = imageUri.getAuthority()) {
            case "com.android.contacts.files": {
                return IMFileUtils.getContactFilesPath(displayName);
            }
            case "com.android.providers.downloads.documents": {
                return IMFileUtils.getDownLoadImagePath(displayName);
            }
        }
        return null;
    }

    private static String getContactFilesPath(String displayName) {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + CONTACT_FILES_PATH + displayName;
    }

    private static String getDownLoadImagePath(String displayName) {
        if (TextUtils.isEmpty((CharSequence)displayName)) {
            return null;
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + Environment.DIRECTORY_DOWNLOADS + File.separator + displayName;
    }

    public static boolean isImageFileType(String path) {
        return path != null && !TextUtils.isEmpty((CharSequence)path) && IMFileUtils.matchStringInArray(path, mImageSuffix);
    }

    public static MediaFileInfo obtainVideoFileWithPath(String suffix, FileItem info) {
        File firstFrame = IMFileUtils.saveFirstFrame(info.getFilePath());
        if (firstFrame == null) {
            return null;
        }
        int duration = IMFileUtils.getVideoDuration(info.getFilePath());
        MediaFileInfo videoFileInfo = new MediaFileInfo();
        videoFileInfo.setAmountOfTime(duration / 1000);
        videoFileInfo.setFilePath(firstFrame.getPath());
        videoFileInfo.setFileName(firstFrame.getName());
        videoFileInfo.setSuffix(suffix);
        videoFileInfo.setFileType(2);
        videoFileInfo.setFileSize(info.getFileSize());
        FileInfo extraInfo = new FileInfo();
        extraInfo.setFilePath(info.getFilePath());
        extraInfo.setFileName(info.getFileName());
        extraInfo.setFileSize(info.getFileSize());
        videoFileInfo.setRawFileInfo(extraInfo);
        return videoFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImagePath(Context context, String string2) {
        Uri uri = Uri.parse((String)Uri.decode((String)string2));
        String path = "";
        if (Build.VERSION.SDK_INT > 25) {
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                path = context.getExternalCacheDir().getPath() + File.separator + "shareTmp" + SystemClock.currentThreadTimeMillis();
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                }
                inputStream = context.getContentResolver().openInputStream(uri);
                fileOutputStream = new FileOutputStream(path);
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) != -1) {
                    fileOutputStream.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    fileOutputStream.close();
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            path = IMFileUtils.getImagePathFormUri(context, uri);
        }
        return path;
    }

    @RequiresApi(api=16)
    public static String filterFileType(Intent intent) {
        String type = intent.getType();
        if (!TextUtils.isEmpty((CharSequence)type) && type.startsWith("text/")) {
            Uri textUri = intent.getData();
            Uri uri = (Uri)intent.getParcelableExtra("android.intent.extra.STREAM");
            if (IMFileUtils.isObjectNotEmpty(textUri) || IMFileUtils.isObjectNotEmpty(uri)) {
                type = "file/";
            } else {
                Uri fileuri;
                ClipData.Item item;
                ClipData shareClip = intent.getClipData();
                if (shareClip != null && (item = shareClip.getItemAt(0)) != null && (fileuri = item.getUri()) != null) {
                    type = "file/";
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)type)) {
            for (String aMShareType : mFilterType) {
                if (!type.startsWith(aMShareType)) continue;
                type = "file/";
                break;
            }
        }
        return IMFileUtils.filterWebType(type, intent);
    }

    private static String filterWebType(String type, Intent intent) {
        ShareInfo shareInfo = ShareUtils.getShareInfo(intent);
        if (shareInfo.getShareType() == 3) {
            return "web/";
        }
        return type;
    }
}

