/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.text.TextUtils;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.util.HmacSHA1Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.json.JSONException;
import org.json.JSONObject;

public final class FilesController {
    private static final int MAX_FILE_NAME_LENGTH = 128;
    public static final int TIME_OUT_UNIT = 30000;
    public static final String HEAD_TICKET = "ticket";

    private FilesController() {
    }

    public static final synchronized FilesController getInstance() {
        return FilesControllerHolder.sInstance;
    }

    @Nullable
    public static String getSuffix(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return fileName.substring(index);
    }

    public String[] requestSign(UserCache userCache, String type, String fileId) throws JSONException, IOException {
        String url = userCache.get().getFastDfsAddr();
        if (!url.endsWith("/")) {
            url = url + File.separator;
        }
        Request request = new Request.Builder().url(url + "time").build();
        OkHttpClient okHttpClient = this.getOkHttpClients(userCache);
        Response response = okHttpClient.newCall(request).execute();
        String[] signResults = null;
        if (response.isSuccessful()) {
            signResults = new String[3];
            try {
                String sign;
                long timestramp = 0L;
                String result = response.body().string();
                LogUtil.d("result:  " + result);
                JSONObject jsonObject = new JSONObject(result);
                if (jsonObject.has("timestamp")) {
                    timestramp = jsonObject.getLong("timestamp");
                }
                timestramp += 1200000L;
                String data = "";
                if (type.equals("4")) {
                    data = userCache.get().getFastUserId() + timestramp;
                } else if (type.equals("5")) {
                    data = "/info/" + fileId + timestramp;
                } else if (type.equals("6")) {
                    data = fileId + timestramp;
                } else if (type.equals("9")) {
                    data = "/delete/" + fileId + timestramp;
                }
                signResults[0] = sign = HmacSHA1Util.hamcsha1((String)data, (String)userCache.get().getFastUserSecret());
                signResults[1] = String.valueOf(timestramp);
                signResults[2] = userCache.get().getFastUserId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return signResults;
    }

    private OkHttpClient getOkHttpClients(final UserCache userCache) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (userCache.get() != null && !TextUtils.isEmpty((CharSequence)userCache.get().getFileKeystorePsd()) && userCache.get().getFileKeystoreId() > 0) {
            builder.sslSocketFactory(this.makeSSLSocketFactory(userCache));
        }
        builder.connectTimeout(30000L, TimeUnit.MILLISECONDS).readTimeout(30000L, TimeUnit.MILLISECONDS).writeTimeout(30000L, TimeUnit.MILLISECONDS).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Request.Builder builder = request.newBuilder();
                builder.header(FilesController.HEAD_TICKET, userCache.get().getTicket());
                return chain.proceed(builder.build());
            }
        }).addInterceptor((Interceptor)new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                LogUtil.d(message);
            }
        }).setLevel(HttpLoggingInterceptor.Level.BODY));
        return builder.build();
    }

    private SSLSocketFactory makeSSLSocketFactory(UserCache userCache) {
        if (userCache == null || userCache.get() == null || userCache.get().getFileKeystoreId() == 0) {
            return null;
        }
        SSLContext sslContext = this.getSSLContext(userCache, this.readKeyStore(userCache, userCache.get().getFileKeystoreId(), ImUiKit.getInstance().getContext()));
        if (sslContext == null) {
            return null;
        }
        return sslContext.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private KeyStore readKeyStore(UserCache userCache, @RawRes int res, @NonNull Context context) {
        InputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            if (TextUtils.isEmpty((CharSequence)userCache.get().getFileKeystorePsd())) {
                KeyStore keyStore2 = null;
                return keyStore2;
            }
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inputStream = context.getResources().openRawResource(res);
            keyStore.load(inputStream, userCache.get().getFileKeystorePsd().toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return keyStore;
    }

    @Nullable
    private SSLContext getSSLContext(UserCache userCache, @Nullable KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, userCache.get().getFileKeystorePsd().toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        return sslContext;
    }

    private static class FilesControllerHolder {
        private static FilesController sInstance = new FilesController();

        private FilesControllerHolder() {
        }
    }
}

