/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.vu;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.filemanage.commend.IHistoryFileListAdapterCommand;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterSuperView;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.log.LogUtil;
import rx.Subscriber;

public class ViewHistoryFileContent
extends AdapterSuperView<IHistoryFileListAdapterCommand, TalkMessageBean>
implements AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean> {
    private TextView mFileNameTv;
    private ImageView mFileIconIv;
    private TextView mFileSizeTv;
    private TextView mFileDateTv;
    private CheckBox mFileSelectCb;
    private TextView mFileDownloadBtn;
    private ProgressBar mFileDownloadPb;
    private LinearLayout mParentLayout;
    private TextView mFileOutDateTv;
    private TextView mFileFromTv;
    private LinearLayout mFileDateLayout;
    private long lastTime;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_history_filelist_item;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        if (view != null) {
            this.mParentLayout = (LinearLayout)view.findViewById(R.id.history_file_content_layout);
            this.mFileNameTv = (TextView)view.findViewById(R.id.tv_file_title);
            this.mFileIconIv = (ImageView)view.findViewById(R.id.img_file_icon);
            this.mFileSizeTv = (TextView)view.findViewById(R.id.tv_file_desc);
            this.mFileDateTv = (TextView)view.findViewById(R.id.tv_file_date);
            this.mFileSelectCb = (CheckBox)view.findViewById(R.id.history_file_select);
            this.mFileDownloadBtn = (TextView)view.findViewById(R.id.history_file_op);
            this.mFileDownloadPb = (ProgressBar)view.findViewById(R.id.pb_file_download);
            this.mFileOutDateTv = (TextView)view.findViewById(R.id.tv_file_out_date);
            this.mFileFromTv = (TextView)view.findViewById(R.id.tv_file_from);
            this.mFileDateLayout = (LinearLayout)view.findViewById(R.id.layout_history_date_from);
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.initView(position);
    }

    private void initView(final int groupPosition) {
        if (this.dataSource != null) {
            FileInfo fileInfo = ((TalkMessageBean)this.dataSource).getFileInfo();
            int resId = HistoryFileUtils.getIconWithSuffix((TalkMessageBean)this.dataSource);
            this.mFileIconIv.setImageResource(resId);
            this.mFileNameTv.setText((CharSequence)fileInfo.getFileName());
            this.mFileSizeTv.setText((CharSequence)FileSizeUtils.FormetFileSize(fileInfo.getFileSize()));
            this.mFileDateTv.setText((CharSequence)DateUtils.displayShowTime((Context)this.getActivity(), ((TalkMessageBean)this.dataSource).getShowTime()));
            this.mFileOutDateTv.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_history_file_outdate), DateUtils.stringOfOverdue((Context)this.getActivity(), ((TalkMessageBean)this.dataSource).getShowTime())));
            if (HistoryFileUtils.isSendReadReceipt((TalkMessageBean)this.dataSource)) {
                ((IHistoryFileListAdapterCommand)this.getCommand()).sendReadReceipt((TalkMessageBean)this.dataSource);
            }
            this.isDownload(!((TalkMessageBean)this.dataSource).hasFileOperate());
            this.clickBtnState(((TalkMessageBean)this.dataSource).getFileInfo().getFileState());
            this.mFileDownloadBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    long currentTime = SystemClock.elapsedRealtime();
                    if (currentTime - ViewHistoryFileContent.this.lastTime < 500L) {
                        return;
                    }
                    ViewHistoryFileContent.this.lastTime = currentTime;
                    if (!HistoryFileUtils.isFileExist((TalkMessageBean)ViewHistoryFileContent.this.dataSource) && DateUtils.isOverdue(((TalkMessageBean)ViewHistoryFileContent.this.dataSource).getShowTime())) {
                        new XToast((Context)ViewHistoryFileContent.this.getActivity()).display(ViewHistoryFileContent.this.getActivity().getString(R.string.im_uikit_history_select_all_overdue));
                        return;
                    }
                    FileInfo fInfo = ((TalkMessageBean)ViewHistoryFileContent.this.dataSource).getFileInfo();
                    int fileState = fInfo.getFileState();
                    if (NetworkHelper.getHelper().networkUseless() && (fileState == 4 || fileState == 1)) {
                        Toast.makeText((Context)ViewHistoryFileContent.this.getActivity(), (CharSequence)ViewHistoryFileContent.this.getStringRes(R.string.im_uikit_network_disabled), (int)0).show();
                        return;
                    }
                    if (ViewHistoryFileContent.this.updateFileState(fInfo, fileState) == -1) {
                        return;
                    }
                    ViewHistoryFileContent.this.clickBtnState(((TalkMessageBean)ViewHistoryFileContent.this.dataSource).getFileInfo().getFileState());
                    ((IHistoryFileListAdapterCommand)ViewHistoryFileContent.this.getCommand()).clickToDownloadOfOpen((TalkMessageBean)ViewHistoryFileContent.this.dataSource);
                }
            });
            this.mFileSelectCb.setChecked(((TalkMessageBean)this.dataSource).isChecked());
            this.mFileSelectCb.setClickable(false);
            this.mFileSelectCb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    ((TalkMessageBean)ViewHistoryFileContent.this.dataSource).setChecked(isChecked);
                    if (isChecked) {
                        HistoryModeUtils.getInstance().putFileToSelectedCache(((TalkMessageBean)ViewHistoryFileContent.this.dataSource).getId(), (TalkMessageBean)ViewHistoryFileContent.this.dataSource);
                    } else {
                        HistoryModeUtils.getInstance().removeToSelectedCache(((TalkMessageBean)ViewHistoryFileContent.this.dataSource).getId());
                    }
                    ((IHistoryFileListAdapterCommand)ViewHistoryFileContent.this.getCommand()).toRefreshSelectHint();
                }
            });
            this.mParentLayout.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    ((IHistoryFileListAdapterCommand)ViewHistoryFileContent.this.getCommand()).longClickOnItem(groupPosition, (TalkMessageBean)ViewHistoryFileContent.this.dataSource);
                    return true;
                }
            });
            this.mParentLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    v.setTag(R.id.history_file_select, (Object)ViewHistoryFileContent.this.mFileSelectCb);
                    if (!((TalkMessageBean)ViewHistoryFileContent.this.dataSource).hasFileOperate()) {
                        int fileState;
                        FileInfo fInfo = ((TalkMessageBean)ViewHistoryFileContent.this.dataSource).getFileInfo();
                        if (ViewHistoryFileContent.this.updateFileState(fInfo, fileState = fInfo.getFileState()) == -1) {
                            return;
                        }
                        ViewHistoryFileContent.this.clickBtnState(((TalkMessageBean)ViewHistoryFileContent.this.dataSource).getFileInfo().getFileState());
                    }
                    ((IHistoryFileListAdapterCommand)ViewHistoryFileContent.this.getCommand()).onClickItem(v, groupPosition, (TalkMessageBean)ViewHistoryFileContent.this.dataSource);
                }
            });
            this.setSenderName();
        }
    }

    private int updateFileState(FileInfo fInfo, int fileState) {
        switch (fileState) {
            case 1: {
                if (((TalkMessageBean)this.dataSource).getMessageState() == 7) {
                    new XToast((Context)this.getActivity()).display(R.string.im_uikit_history_file_recall);
                    return -1;
                }
                fInfo.setFileState(3);
                break;
            }
            case 3: {
                fInfo.setFileState(4);
                break;
            }
            case 4: {
                if (((TalkMessageBean)this.dataSource).getMessageState() == 7) {
                    new XToast((Context)this.getActivity()).display(R.string.im_uikit_history_file_recall);
                    return -1;
                }
                fInfo.setFileState(3);
                break;
            }
            case 5: {
                fInfo.setFileState(3);
            }
        }
        return 0;
    }

    private void isDownload(boolean isDownload) {
        this.mFileSelectCb.setVisibility(isDownload ? 8 : 0);
        this.mFileDownloadBtn.setVisibility(isDownload ? 0 : 8);
        this.mFileDownloadPb.setVisibility(isDownload ? 0 : 8);
    }

    private void clickBtnState(int state) {
        Drawable btnDrawable = null;
        if (((TalkMessageBean)this.dataSource).isMine()) {
            this.mFileDateLayout.setVisibility(0);
            this.mFileOutDateTv.setVisibility(8);
            this.mFileFromTv.setVisibility(0);
            this.mFileDownloadPb.setVisibility(8);
            btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_lookup : R.drawable.im_uikit_history_lookup_light);
        } else if (DateUtils.isOverdue(((TalkMessageBean)this.dataSource).getShowTime()) && !HistoryFileUtils.isFileExist((TalkMessageBean)this.dataSource)) {
            this.mFileDateLayout.setVisibility(0);
            this.mFileOutDateTv.setVisibility(0);
            this.mFileDownloadPb.setVisibility(8);
            btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
            this.mFileDownloadBtn.setEnabled(true);
        } else {
            LogUtil.d("", "zhu->UI Content:progress=" + ((TalkMessageBean)this.dataSource).getFileInfo().getTranslatePercent() + ",state=" + state);
            this.mFileDownloadBtn.setEnabled(true);
            switch (state) {
                case 1: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
                    this.mFileDateLayout.setVisibility(0);
                    this.mFileDownloadPb.setVisibility(8);
                    this.mFileOutDateTv.setVisibility(0);
                    break;
                }
                case 3: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_pause : R.drawable.im_uikit_history_pause_light);
                    this.mFileDateLayout.setVisibility(8);
                    this.mFileDownloadPb.setVisibility(0);
                    this.mFileOutDateTv.setVisibility(0);
                    break;
                }
                case 2: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_lookup : R.drawable.im_uikit_history_lookup_light);
                    this.mFileDateLayout.setVisibility(0);
                    this.mFileDownloadPb.setVisibility(8);
                    this.mFileOutDateTv.setVisibility(8);
                    break;
                }
                case 4: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_resume : R.drawable.im_uikit_history_resume_light);
                    this.mFileDateLayout.setVisibility(8);
                    this.mFileDownloadPb.setVisibility(0);
                    this.mFileOutDateTv.setVisibility(0);
                    break;
                }
                case 5: {
                    btnDrawable = this.getDrawableRes(UniversalUtil.getThemeStyle(this.getContext()) == 0 ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
                    this.mFileDateLayout.setVisibility(0);
                    this.mFileDownloadPb.setVisibility(8);
                    this.mFileOutDateTv.setVisibility(0);
                }
            }
        }
        this.mFileDownloadBtn.setBackground(btnDrawable);
        this.mFileDownloadPb.setProgress(((TalkMessageBean)this.dataSource).getFileInfo().getTranslatePercent());
    }

    private void setSenderName() {
        if (((TalkMessageBean)this.dataSource).isGroupMsg()) {
            String senderName = String.format(this.getStringRes(R.string.im_uikit_history_file_come_from), this.getStringRes(R.string.im_uikit_group_chat));
            this.mFileFromTv.setText((CharSequence)senderName);
        } else {
            IMUiKitProxyImpl.getInstance().getAccount(((TalkMessageBean)this.dataSource).isMine() ? ((TalkMessageBean)this.dataSource).getTo() : ((TalkMessageBean)this.dataSource).getFrom(), 1, new Subscriber<AccountBean>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    e.printStackTrace();
                }

                public void onNext(AccountBean accountBean) {
                    String senderName = String.format(ViewHistoryFileContent.this.getStringRes(((TalkMessageBean)ViewHistoryFileContent.this.dataSource).isMine() ? R.string.im_uikit_history_file_come_to : R.string.im_uikit_history_file_come_from), accountBean.getDisplayName());
                    ViewHistoryFileContent.this.mFileFromTv.setText((CharSequence)senderName);
                }
            });
        }
    }
}

