/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.share.util;

import android.text.util.Linkify;
import android.util.Pair;
import android.util.Patterns;
import com.xdja.im.lib.share.model.HyperLinkBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HyperLinkUtil {
    private static final int LINK_WEB = 1;
    private static final int LINK_EMAIL = 2;
    private static final int LINK_PHONE = 4;
    private static final String[] webPrefix = new String[]{"http://", "https://", "rtsp://"};
    private static final String[] emailPrefix = new String[]{"mailto:"};
    private static final String GOOD_IRI_CHAR = "a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef";
    private static final Pattern IP_ADDRESS = Pattern.compile("((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9]))");
    private static final String GOOD_GTLD_CHAR = "a-zA-Z\uf900-\ufdcf\ufdf0-\uffef";
    private static final String GTLD = "[a-zA-Z\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    private static final String IRI = "[a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]){0,1}";
    private static final String HOST_NAME = "([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\uf900-\ufdcf\ufdf0-\uffef]{2,63}";
    private static final Pattern DOMAIN_NAME = Pattern.compile("(([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]([a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef\\-]{0,61}[a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef]){0,1}\\.)+[a-zA-Z\uf900-\ufdcf\ufdf0-\uffef]{2,63}|" + IP_ADDRESS + ")");
    private static final Pattern WEB_URL = Pattern.compile("((?:(http|https|Http|Https|rtsp|Rtsp):\\/\\/(?:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,64}(?:\\:(?:[a-zA-Z0-9\\$\\-\\_\\.\\+\\!\\*\\'\\(\\)\\,\\;\\?\\&\\=]|(?:\\%[a-fA-F0-9]{2})){1,25})?\\@)?)?(?:" + DOMAIN_NAME + ")(?:\\:\\d{1,5})?)(\\/(?:(?:[" + "a-zA-Z0-9\uf900-\ufdcf\ufdf0-\uffef" + "\\;\\/\\?\\:\\@\\&\\=\\#\\~\\-\\.\\+\\!\\*\\'\\(\\)\\,\\_])|(?:\\%[a-fA-F0-9]{2}))*)?(?:\\b|$)");
    private static final Pattern A_LABEL = Pattern.compile("<a[^>]+?href=[\"']?([^\"']+)[\"']?[^>]*>([^<]+)([^>]*)</a>");

    public static List<HyperLinkBean> parseContent(String content, int type) {
        ArrayList<HyperLinkBean> links = new ArrayList<HyperLinkBean>();
        if ((type & 1) != 0) {
            HyperLinkUtil.getWebOrEmailLink(links, content, WEB_URL, webPrefix, Linkify.sUrlMatchFilter);
        }
        if ((type & 2) != 0) {
            HyperLinkUtil.getWebOrEmailLink(links, content, Patterns.EMAIL_ADDRESS, emailPrefix, null);
        }
        if ((type & 4) != 0) {
            HyperLinkUtil.getPhoneLink(links, content, Patterns.PHONE, Linkify.sPhoneNumberMatchFilter);
        }
        return HyperLinkUtil.hyperlinkFilter(links);
    }

    public static Pair<String, List<HyperLinkBean>> parseALabelLink(String s) {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher matcher = A_LABEL.matcher(s);
        if (matcher.find() && matcher.groupCount() >= 3) {
            ArrayList<HyperLinkBean> links = new ArrayList<HyperLinkBean>();
            HyperLinkBean hyperLink = new HyperLinkBean();
            String label = matcher.group(0);
            String link = matcher.group(1);
            String text = matcher.group(2);
            hyperLink.setHyperlink(link);
            int start = s.length() - label.length();
            int end = start + text.length();
            hyperLink.setStartPosition(start);
            hyperLink.setEndPosition(end);
            hyperLink.setLinkType(1);
            links.add(hyperLink);
            String result = s.substring(0, start) + text;
            return new Pair((Object)result, links);
        }
        return null;
    }

    public static String parseALabelText(String s) {
        Matcher matcher;
        String result = s;
        if (s != null && s.length() > 0 && (matcher = A_LABEL.matcher(s)).find() && matcher.groupCount() >= 3) {
            String label = matcher.group(0);
            String text = matcher.group(2);
            result = s.substring(0, s.length() - label.length()) + text;
        }
        return result;
    }

    public static boolean isALabelLink(String s) {
        if (s == null || s.length() <= 0) {
            return false;
        }
        Matcher matcher = A_LABEL.matcher(s);
        return matcher.find() && matcher.groupCount() >= 3;
    }

    private static void getWebOrEmailLink(List<HyperLinkBean> links, String s, Pattern pattern, String[] schemes, Linkify.MatchFilter matchFilter) {
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)s, start, end)) continue;
            HyperLinkBean hyperLink = new HyperLinkBean();
            String link = HyperLinkUtil.createLink(matcher.group(0), schemes);
            hyperLink.setHyperlink(link);
            hyperLink.setStartPosition(start);
            hyperLink.setEndPosition(end);
            if (pattern == WEB_URL) {
                hyperLink.setLinkType(1);
            } else if (pattern == Patterns.EMAIL_ADDRESS) {
                hyperLink.setLinkType(2);
            }
            links.add(hyperLink);
        }
    }

    private static String createLink(String group, String[] prefixes) {
        boolean isHasPrefix = false;
        for (String prefixe : prefixes) {
            if (!group.regionMatches(true, 0, prefixe, 0, prefixe.length())) continue;
            isHasPrefix = true;
            break;
        }
        if (!isHasPrefix) {
            group = prefixes[0] + group;
        }
        return group;
    }

    private static void getPhoneLink(List<HyperLinkBean> links, String s, Pattern pattern, Linkify.MatchFilter matchFilter) {
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)s, start, end)) continue;
            HyperLinkBean hyperLink = new HyperLinkBean();
            String link = matcher.group(0);
            hyperLink.setHyperlink(link);
            hyperLink.setStartPosition(start);
            hyperLink.setEndPosition(end);
            hyperLink.setLinkType(4);
            links.add(hyperLink);
        }
    }

    private static List<HyperLinkBean> hyperlinkFilter(List<HyperLinkBean> linkList) {
        int len = linkList.size();
        int i = 0;
        linkList = HyperLinkUtil.sortAllLink(linkList);
        while (i < len - 1) {
            HyperLinkBean a = linkList.get(i);
            HyperLinkBean b = linkList.get(i + 1);
            int index = -1;
            if (a.getStartPosition() <= b.getStartPosition() && a.getEndPosition() >= b.getStartPosition()) {
                if (a.getEndPosition() >= b.getEndPosition()) {
                    index = i + 1;
                } else if (a.getEndPosition() - a.getStartPosition() > b.getEndPosition() - b.getStartPosition()) {
                    index = i + 1;
                } else if (a.getEndPosition() - a.getStartPosition() < b.getEndPosition() - b.getStartPosition()) {
                    index = i;
                }
                if (index != -1) {
                    linkList.remove(index);
                    --len;
                    continue;
                }
            }
            ++i;
        }
        return linkList;
    }

    private static List<HyperLinkBean> sortAllLink(List<HyperLinkBean> linkList) {
        Comparator<HyperLinkBean> comparator = new Comparator<HyperLinkBean>(){

            @Override
            public int compare(HyperLinkBean lhs, HyperLinkBean rhs) {
                if (lhs.getStartPosition() < rhs.getStartPosition()) {
                    return -1;
                }
                if (lhs.getStartPosition() > rhs.getStartPosition()) {
                    return 1;
                }
                if (lhs.getEndPosition() < rhs.getEndPosition()) {
                    return -1;
                }
                if (lhs.getEndPosition() > rhs.getEndPosition()) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(linkList, comparator);
        return linkList;
    }
}

