/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.action.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.PowerManager;
import com.xdja.im.lib.audio.manager.TelphoneState;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.lib.filemanage.util.ActomaController;

public class MediaManger {
    private static String TAG = "MediaManger";
    private static final int VERSION = Build.VERSION.SDK_INT;
    private static MediaManger mediaManger;
    private static AudioManager mAudioManager;
    private PowerManager.WakeLock mWakeLock;
    private boolean isWakeAcquire = false;
    private boolean isReceiverMode = false;
    private boolean isHeadsetOn = false;

    public boolean isReceiverMode() {
        return this.isReceiverMode;
    }

    public void setReceiverMode(boolean receiverMode) {
        this.isReceiverMode = receiverMode;
    }

    @SuppressLint(value={"InlinedApi"})
    private MediaManger() {
        try {
            Context context = ActomaController.getApp();
            mAudioManager = (AudioManager)context.getSystemService("audio");
            if (VERSION >= 21) {
                PowerManager pManager = (PowerManager)ActomaController.getApp().getSystemService("power");
                this.mWakeLock = pManager.newWakeLock(32, TAG);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MediaManger getInstance() {
        if (mediaManger != null && mAudioManager != null) return mediaManger;
        Class<MediaManger> clazz = MediaManger.class;
        synchronized (MediaManger.class) {
            if (mediaManger != null && mAudioManager != null) return mediaManger;
            mediaManger = new MediaManger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mediaManger;
        }
    }

    public void onSensorChanged(boolean isReceiverMode) {
        if (!AudioPlayerManager.getInstance().isPlaying()) {
            if (this.isWakeAcquire) {
                this.wakeLockBrightRelease();
            }
            return;
        }
        if (isReceiverMode) {
            this.setReceiverModeOn();
        } else {
            this.setReceiverModeOff();
        }
    }

    public void setHeadsetOn(boolean headsetOn) {
        this.isHeadsetOn = headsetOn;
    }

    public boolean isHeadsetOn() {
        return this.isHeadsetOn || mAudioManager.isWiredHeadsetOn();
    }

    public void restoreAudioMode() {
        if (!TelphoneState.getPhotoStateIsIdle(ActomaController.getApp()) || mAudioManager == null) {
            return;
        }
        mAudioManager.setMode(0);
    }

    public void setReceiverModeOn() {
        mAudioManager.setSpeakerphoneOn(false);
    }

    public void setReceiverModeOff() {
        mAudioManager.setMode(0);
    }

    public void wakeLockBrightAcquire() {
        if (this.mWakeLock != null && !this.mWakeLock.isHeld()) {
            this.isWakeAcquire = true;
            this.mWakeLock.setReferenceCounted(false);
            this.mWakeLock.acquire(600000L);
        }
    }

    public void wakeLockBrightRelease() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public void releaseWakeLock() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.isWakeAcquire = false;
            this.mWakeLock.release();
        }
    }

    public boolean isWakeAcquire() {
        return this.isWakeAcquire;
    }

    private static class SingletonInstance {
        private static final MediaManger mInstance = new MediaManger();

        private SingletonInstance() {
        }
    }
}

