/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.activity;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.core.model.message.NoDistrubBean;
import com.xdja.im.core.model.param.DisturbParam;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.lib.video.widget.CustomTimePicker;
import com.xdja.im.uikit.ImUiKitSetting;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseSettingActivity;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class DisturbActivity
extends ImBaseSettingActivity
implements View.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    private static final String TAG = DisturbActivity.class.getSimpleName();
    private CheckBox cbDistrubOn;
    private RelativeLayout rl4StartTime;
    private RelativeLayout rl4EndTime;
    private LinearLayout llShowDistrub;
    private TextView nodistrubStartTv;
    private TextView nodistrubEndTv;
    private DisturbParam param;

    @Override
    public int getLayoutView() {
        return R.layout.im_uikit_activity_distribute;
    }

    @Override
    public void initView() {
        this.cbDistrubOn = (CheckBox)this.findViewById(R.id.no_disturb_checkbox);
        this.rl4StartTime = (RelativeLayout)this.findViewById(R.id.nodistrub_begin_container);
        this.rl4EndTime = (RelativeLayout)this.findViewById(R.id.nodistrub_end_container);
        this.llShowDistrub = (LinearLayout)this.findViewById(R.id.nodistrub_time_layout);
        this.nodistrubStartTv = (TextView)this.findViewById(R.id.nodistrub_begin_text);
        this.nodistrubEndTv = (TextView)this.findViewById(R.id.nodistrub_end_text);
        this.cbDistrubOn.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.rl4StartTime.setOnClickListener((View.OnClickListener)this);
        this.rl4EndTime.setOnClickListener((View.OnClickListener)this);
        this.loadSettingParam();
    }

    protected void onPause() {
        super.onPause();
        if (this.param != null) {
            ImUiKitSetting.getInstance().setDisturbMode(this.param.isOpen());
            ImUiKitSetting.getInstance().setDisturbStart(this.param.getStartTime());
            ImUiKitSetting.getInstance().setDisturbEnd(this.param.getEndTime());
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.nodistrub_begin_container) {
            if (this.param != null) {
                NoDistrubBean bean = this.buildDisturbBean(true, this.param.getStartTime(), this.param.getEndTime());
                int hour = bean.getBeginHour();
                int min = bean.getBeginMinu();
                new CustomTimePicker((Context)this, new CustomTimePicker.TimerPickerCallBack(){

                    @Override
                    public void onTimeSelected(int hourOfDay, int minute) {
                        int start = hourOfDay * 3600 + minute * 60;
                        ImUiKitSetting.getInstance().setDisturbStart(start);
                        DisturbActivity.this.param.setStartTime(start);
                        NoDistrubBean b = DisturbActivity.this.buildDisturbBean(true, start, DisturbActivity.this.param.getEndTime());
                        DisturbActivity.this.nodistrubStartTv.setText((CharSequence)b.getBeginTime());
                    }
                }).createView(hour, min).show();
            }
        } else if (v.getId() == R.id.nodistrub_end_container && this.param != null) {
            NoDistrubBean bean = this.buildDisturbBean(true, this.param.getStartTime(), this.param.getEndTime());
            int hour = bean.getBeginHour();
            int min = bean.getBeginMinu();
            new CustomTimePicker((Context)this, new CustomTimePicker.TimerPickerCallBack(){

                @Override
                public void onTimeSelected(int hourOfDay, int minute) {
                    int end = hourOfDay * 3600 + minute * 60;
                    ImUiKitSetting.getInstance().setDisturbEnd(end);
                    DisturbActivity.this.param.setEndTime(end);
                    NoDistrubBean b = DisturbActivity.this.buildDisturbBean(true, DisturbActivity.this.param.getStartTime(), end);
                    DisturbActivity.this.nodistrubEndTv.setText((CharSequence)b.getEndTime());
                }
            }).createView(hour, min).show();
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (buttonView.getId() == R.id.no_disturb_checkbox) {
            if (isChecked) {
                this.llShowDistrub.setVisibility(0);
                this.param.setOpen(true);
            } else {
                this.llShowDistrub.setVisibility(8);
                this.param.setOpen(false);
            }
        }
    }

    private void loadSettingParam() {
        Observable.just((Object)"").subscribeOn(Schedulers.newThread()).flatMap((Func1)new Func1<String, Observable<SettingParam>>(){

            public Observable<SettingParam> call(String s) {
                SettingParam param = ImUiKitSetting.getInstance().getSettingParam();
                if (param == null) {
                    return Observable.error((Throwable)new IllegalArgumentException());
                }
                return Observable.just((Object)param);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<SettingParam>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                Log.e((String)TAG, (String)("Load disturb param failed." + e.getMessage()));
            }

            public void onNext(SettingParam settingParam) {
                DisturbActivity.this.param = settingParam.getDisturb();
                if (null != DisturbActivity.this.param) {
                    if (DisturbActivity.this.param.isOpen()) {
                        long startTime = DisturbActivity.this.param.getStartTime();
                        long endTime = DisturbActivity.this.param.getEndTime();
                        NoDistrubBean bean = DisturbActivity.this.buildDisturbBean(true, startTime, endTime);
                        DisturbActivity.this.cbDistrubOn.setChecked(true);
                        DisturbActivity.this.llShowDistrub.setVisibility(0);
                        DisturbActivity.this.nodistrubStartTv.setText((CharSequence)bean.getBeginTime());
                        DisturbActivity.this.nodistrubEndTv.setText((CharSequence)bean.getEndTime());
                    } else {
                        DisturbActivity.this.cbDistrubOn.setChecked(false);
                        DisturbActivity.this.llShowDistrub.setVisibility(8);
                    }
                } else {
                    DisturbActivity.this.cbDistrubOn.setChecked(false);
                    DisturbActivity.this.llShowDistrub.setVisibility(8);
                }
            }
        });
    }

    private NoDistrubBean buildDisturbBean(boolean isOpen, long start, long end) {
        NoDistrubBean bean = new NoDistrubBean();
        if (start == 0L && end == 0L) {
            return bean;
        }
        int startHour = (int)(start / 3600L);
        int startMin = (int)((start - (long)(startHour * 3600)) / 60L);
        int endHour = (int)(end / 3600L);
        int endMin = (int)((end - (long)(endHour * 3600)) / 60L);
        bean.setBeginHour(startHour);
        bean.setBeginMinu(startMin);
        bean.setEndHour(endHour);
        bean.setEndMinu(endMin);
        bean.setIsOpen(isOpen);
        return bean;
    }
}

