/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.action.options.ImOption;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRecyclerListDialog
extends Dialog {
    private RecyclerView mList;
    private BaseRecyclerListAdapter mAdapter;
    private List<ImOption> mOptions = new ArrayList<ImOption>();
    private int mItemPosition;
    private Context mContext;
    private onItemClickListener onItemClickListener;

    public void setOnItemClickListener(onItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public BaseRecyclerListDialog(@NonNull Context context) {
        super(context, R.style.im_uikit_BaseDialogStyle);
        this.mContext = context;
        this.setContentView(R.layout.im_uikit_dialg_option_recycler_list);
        this.setCancelable(true);
        this.initView();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            WindowManager.LayoutParams lp = this.getWindow().getAttributes();
            int screenWidth = this.getWindow().getWindowManager().getDefaultDisplay().getWidth();
            lp.width = (int)((double)screenWidth * 0.8);
            this.getWindow().setAttributes(lp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView() {
        this.mList = (RecyclerView)this.findViewById(R.id.lv_options);
        this.mAdapter = new BaseRecyclerListAdapter(this.mOptions);
        this.mList.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.mContext, 1));
        this.mList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.addOnItemClickListener(new onItemClickListener(){

            @Override
            public void onItemClick(View view, ImOption option, int itemPosition) {
                if (BaseRecyclerListDialog.this.onItemClickListener != null) {
                    BaseRecyclerListDialog.this.onItemClickListener.onItemClick(view, option, BaseRecyclerListDialog.this.mItemPosition);
                }
            }
        });
        this.addData(this.getOptions());
    }

    public void addData(List<ImOption> options) {
        if (options == null || options.size() == 0) {
            return;
        }
        this.mOptions.clear();
        this.mOptions.addAll(options);
        this.mAdapter.notifyDataSetChanged();
    }

    public void show(int position) {
        super.show();
        this.mItemPosition = position;
    }

    public abstract List<ImOption> getOptions();

    public static interface onItemClickListener {
        public void onItemClick(View var1, ImOption var2, int var3);
    }

    class BaseRecyclerListHolder
    extends RecyclerView.ViewHolder {
        TextView mOptionTv;

        public BaseRecyclerListHolder(View itemView) {
            super(itemView);
            this.mOptionTv = (TextView)itemView.findViewById(R.id.tv_option);
        }
    }

    class BaseRecyclerListAdapter
    extends RecyclerView.Adapter<BaseRecyclerListHolder> {
        private List<ImOption> mOptions;
        private onItemClickListener itemClickListener;

        public BaseRecyclerListAdapter(List<ImOption> mOptions) {
            this.mOptions = mOptions;
        }

        public void addOnItemClickListener(onItemClickListener onItemClickListener2) {
            this.itemClickListener = onItemClickListener2;
        }

        public BaseRecyclerListHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new BaseRecyclerListHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_uikit_item_dialog_option, parent, false));
        }

        public void onBindViewHolder(final BaseRecyclerListHolder holder, final int position) {
            final ImOption imOption = this.getItem(position);
            if (imOption != null) {
                holder.mOptionTv.setText((CharSequence)imOption.getValue());
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (BaseRecyclerListAdapter.this.itemClickListener != null) {
                            BaseRecyclerListAdapter.this.itemClickListener.onItemClick(holder.itemView, imOption, position);
                        }
                    }
                });
            }
        }

        public int getItemCount() {
            return this.mOptions.size();
        }

        private ImOption getItem(int position) {
            return this.mOptions.get(position);
        }
    }
}

