/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.fragment;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMContactEvent;
import com.xdja.im.core.model.event.IMNotificationEvent;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.event.IMProxyMessageEvent;
import com.xdja.im.core.model.event.IMProxySessionEvent;
import com.xdja.im.core.model.event.IMProxyUpdateSession;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.core.repository.interf.UserOperateRepository;
import com.xdja.im.core.repository.interf.datasource.CloudDataStore;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.core.utils.ToolUtils;
import com.xdja.im.lib.filemanage.util.ActomaController;
import com.xdja.im.uikit.IntentParam;
import com.xdja.im.uikit.base.ImBaseFragment;
import com.xdja.im.uikit.ui.adapter.SessionListAdapter;
import com.xdja.im.uikit.ui.presenter.SessionListPresenter;
import com.xdja.im.uikit.ui.view.ViewSessionList;
import com.xdja.im.uikit.ui.view.vu.SessionListVu;
import com.xdja.im.uikit.utils.AtPreferencesUtils;
import com.xdja.im.uikit.utils.PromptPictureUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import rx.Subscriber;

public class SessionListFragment
extends ImBaseFragment<SessionListPresenter, SessionListVu>
implements SessionListPresenter {
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    @Inject
    Lazy<DiskDataStore> diskDataStore;
    @Inject
    Lazy<CloudDataStore> cloudDataStore;
    @Inject
    Lazy<UserOperateRepository> userOperateRepositoryLazy;
    private SessionListAdapter mAdapter;
    private List<TalkSessionBean> mSessionList = new ArrayList<TalkSessionBean>();
    private int mTalkType = 0;
    private int mUnReadCount;
    private boolean isNotify = true;
    private MeetInfo mMeetInfo;
    private List<TalkSessionBean> copySessionList = new ArrayList<TalkSessionBean>();

    @Override
    @NonNull
    protected Class<? extends SessionListVu> getVuClass() {
        return ViewSessionList.class;
    }

    @Override
    @NonNull
    protected SessionListPresenter getPresenter() {
        return this;
    }

    @Override
    protected void preBindView(Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            this.mTalkType = arguments.getInt("talkType", 0);
        }
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        BusProvider.getInstance().register(this);
        if (this.mComponent == null) {
            return;
        }
        this.mComponent.inject(this);
        try {
            PromptPictureUtils.getInstance().registerContentObserver(this.getContext().getApplicationContext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mAdapter = new SessionListAdapter((Activity)this.getActivity(), this.mSessionList, this);
        ((SessionListVu)this.getVu()).setAdapter(this.mAdapter);
        this.startLoadSessionData();
    }

    public void onResume() {
        super.onResume();
        this.isNotify = true;
    }

    public void onPause() {
        super.onPause();
        this.isNotify = false;
    }

    private void calculateReadMessageCount(List<TalkSessionBean> sessionBeanList) {
        int unReadCount = 0;
        for (TalkSessionBean bean : sessionBeanList) {
            unReadCount += bean.getNotReadCount();
            SessionParam param = bean.getParam();
            if (null == param || !param.isDisturb()) continue;
            unReadCount -= bean.getNotReadCount();
        }
        IMUiKitProxyImpl.getInstance().updateUnReadMessageCount(unReadCount);
    }

    private void updateUnReadMessageCount(TalkSessionBean talkSessionBean) {
        int allUnreadCount = 0;
        if (talkSessionBean == null) {
            return;
        }
        for (TalkSessionBean bean : this.mSessionList) {
            allUnreadCount += bean.getNotReadCount();
            SessionParam param = bean.getParam();
            if (null == param || !param.isDisturb()) continue;
            allUnreadCount -= bean.getNotReadCount();
        }
        if (talkSessionBean.getParam() != null && talkSessionBean.getParam().isDisturb()) {
            LogUtil.e("ERROR: talkSessionBean  getParam has  disturb set");
        } else {
            allUnreadCount -= talkSessionBean.getNotReadCount();
        }
        talkSessionBean.setNotReadCount(0);
        if (allUnreadCount < 0) {
            LogUtil.e("ERROR: Update unRead message count " + allUnreadCount);
            return;
        }
        IMUiKitProxyImpl.getInstance().updateUnReadMessageCount(allUnreadCount);
    }

    @Override
    public void onListItemClick(int position) {
        TalkSessionBean talkSessionBean = this.mSessionList.get(position);
        if (talkSessionBean == null) {
            LogUtil.e("ERROR: obtain session info failed!!");
            return;
        }
        switch (talkSessionBean.getTalkType()) {
            case 0: 
            case 1: 
            case 2: 
            case 999: {
                IntentParam.startChatActivity(this.getContext(), talkSessionBean.getTalkerAccount(), talkSessionBean.getTalkType(), IMUiKitProxyImpl.getInstance().getCancelBottomMenuId(talkSessionBean.getTalkerAccount(), talkSessionBean.getTalkType()));
                break;
            }
            case 201: {
                if (talkSessionBean.getTalkerAccount().equals("20002")) {
                    IntentParam.startChatActivity(this.getContext(), talkSessionBean.getTalkerAccount(), talkSessionBean.getTalkType());
                    break;
                }
                IntentParam.startSystemAssistantActivity(this.getContext(), talkSessionBean.getTalkerAccount(), talkSessionBean.getTalkType());
                break;
            }
        }
        BusProvider.getInstance().post(new IMNotificationEvent(talkSessionBean));
        this.updateUnReadMessageCount(talkSessionBean);
    }

    private void startLoadSessionData() {
        ((SessionListVu)this.getVu()).setProgressBarVisibility(0);
        if (this.proxyRepository == null || this.proxyRepository.get() == null) {
            return;
        }
        ((ProxyRepository)this.proxyRepository.get()).getSessionListBeans("", 0, this.mTalkType, new Subscriber<List<TalkSessionBean>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                ((SessionListVu)SessionListFragment.this.getVu()).setProgressBarVisibility(8);
                LogUtil.e("ERROR: Load session data error. " + e.getMessage());
            }

            public void onNext(List<TalkSessionBean> sessionBeanList) {
                LogUtil.d("Load session data finished.");
                SessionListFragment.this.loadSessionParams(sessionBeanList);
            }
        });
    }

    private void loadSessionParams(final List<TalkSessionBean> sessionBeanList) {
        ((UserOperateRepository)this.userOperateRepositoryLazy.get()).getAllSessionParams(new Subscriber<List<SessionParam>>(){

            public void onCompleted() {
                ((SessionListVu)SessionListFragment.this.getVu()).setProgressBarVisibility(8);
            }

            public void onError(Throwable e) {
                SessionListFragment.this.updateSessionList(sessionBeanList);
                ((SessionListVu)SessionListFragment.this.getVu()).setProgressBarVisibility(8);
            }

            public void onNext(List<SessionParam> sessionParams) {
                if (sessionParams == null || sessionParams.isEmpty()) {
                    SessionListFragment.this.updateSessionList(sessionBeanList);
                    return;
                }
                for (int i = 0; i < sessionParams.size(); ++i) {
                    SessionParam param = sessionParams.get(i);
                    SessionListFragment.this.addParamToSessionList(param, sessionBeanList);
                }
                Collections.sort(sessionBeanList);
                SessionListFragment.this.updateSessionList(sessionBeanList);
            }
        });
    }

    private void addParamToSessionList(SessionParam param, List<TalkSessionBean> sessionBeanList) {
        TalkSessionBean tempBean = new TalkSessionBean();
        tempBean.setTalkFlag(param.getSessionFlag());
        int index = sessionBeanList.indexOf(tempBean);
        if (index >= 0) {
            TalkSessionBean talkSessionBean = sessionBeanList.get(index);
            talkSessionBean.setParam(param);
            if (TextUtils.isEmpty((CharSequence)talkSessionBean.getLastMsgAccount()) && talkSessionBean.getLastTime() > 0L && param.getDraftTime() > talkSessionBean.getLastTime()) {
                talkSessionBean.setLastTime(param.getDraftTime());
            }
            if (!TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > 0L) {
                talkSessionBean.setLastTime(param.getDraftTime());
            }
        } else if (param.getDraftTime() > 0L) {
            TalkSessionBean talkSessionBean = new TalkSessionBean();
            talkSessionBean.setTalkFlag(param.getSessionFlag());
            talkSessionBean.setLastTime(param.getDraftTime());
            talkSessionBean.setParam(param);
            sessionBeanList.add(talkSessionBean);
        }
    }

    private void createNewSession(final TalkSessionBean sessionBean) {
        ((DiskDataStore)this.diskDataStore.get()).loadSessionParam(sessionBean.getTalkFlag(), new Subscriber<SessionParam>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Load session param failed." + sessionBean.getTalkFlag());
                SessionListFragment.this.mSessionList.add(sessionBean);
                Collections.sort(SessionListFragment.this.mSessionList);
                SessionListFragment.this.mAdapter.notifyDataSetChanged();
                SessionListFragment.this.calculateReadMessageCount(SessionListFragment.this.mSessionList);
            }

            public void onNext(SessionParam sessionParam) {
                if (sessionParam != null) {
                    LogUtil.d("SessionParam:" + sessionParam.toString());
                    sessionBean.setParam(sessionParam);
                }
                SessionListFragment.this.mSessionList.add(sessionBean);
                SessionListFragment.this.removeExists(SessionListFragment.this.mSessionList);
                Collections.sort(SessionListFragment.this.mSessionList);
                SessionListFragment.this.mAdapter.notifyDataSetChanged();
                SessionListFragment.this.calculateReadMessageCount(SessionListFragment.this.mSessionList);
            }
        });
    }

    private void updateSessionList(List<TalkSessionBean> sessionBeanList) {
        this.mSessionList.clear();
        this.removeExists(sessionBeanList);
        this.mSessionList.addAll(sessionBeanList);
        this.mAdapter.notifyDataSetChanged();
        this.calculateReadMessageCount(this.mSessionList);
    }

    private void removeExists(List<TalkSessionBean> beans) {
        Iterator<TalkSessionBean> iterator = beans.iterator();
        while (iterator.hasNext()) {
            TalkSessionBean bean = iterator.next();
            int index = beans.indexOf(bean);
            if (index <= -1 || bean == beans.get(index)) continue;
            iterator.remove();
        }
    }

    @Override
    public void deleteSession(int position) {
        final TalkSessionBean sessionBean = (TalkSessionBean)this.mAdapter.getItem(position);
        if (sessionBean != null) {
            ((SessionListVu)this.getVu()).setProgressBarVisibility(0);
            ((ProxyRepository)this.proxyRepository.get()).deleteSession(sessionBean.getTalkFlag(), new Subscriber<Integer>(){

                public void onCompleted() {
                    LogUtil.d("Delete session successfully.");
                }

                public void onError(Throwable e) {
                    LogUtil.e("Delete session error." + e.getMessage());
                    ((SessionListVu)SessionListFragment.this.getVu()).setProgressBarVisibility(8);
                }

                public void onNext(Integer integer) {
                    if (integer == 0) {
                        ((SessionListVu)SessionListFragment.this.getVu()).setProgressBarVisibility(8);
                        SessionListFragment.this.mSessionList.remove(sessionBean);
                        SessionListFragment.this.mAdapter.notifyDataSetChanged();
                        IMUiKitProxyImpl.getInstance().onSessionDelete(sessionBean);
                        SessionListFragment.this.deleteSessionParam(sessionBean.getTalkFlag());
                        sessionBean.setNotReadCount(0);
                        SessionListFragment.this.updateUnReadMessageCount(sessionBean);
                        SessionListFragment.this.setAtType(sessionBean.getTalkerAccount(), sessionBean.getTalkType());
                    }
                }
            });
        }
    }

    @Override
    public void deleteSession(String sessionFlag) {
        if (TextUtils.isEmpty((CharSequence)sessionFlag)) {
            LogUtil.e("ERROR:Delete session, but sessionFlag is im_uikit_empty.");
            return;
        }
        final TalkSessionBean sessionBean = new TalkSessionBean();
        sessionBean.setTalkFlag(sessionFlag);
        ((ProxyRepository)this.proxyRepository.get()).deleteSession(sessionBean.getTalkFlag(), new Subscriber<Integer>(){

            public void onCompleted() {
                LogUtil.d("Delete session successfully.");
            }

            public void onError(Throwable e) {
                LogUtil.e("Delete session error." + e.getMessage());
                ((SessionListVu)SessionListFragment.this.getVu()).setProgressBarVisibility(8);
            }

            public void onNext(Integer integer) {
                if (integer == 0) {
                    ((SessionListVu)SessionListFragment.this.getVu()).setProgressBarVisibility(8);
                    SessionListFragment.this.mSessionList.remove(sessionBean);
                    SessionListFragment.this.mAdapter.notifyDataSetChanged();
                    SessionListFragment.this.deleteSessionParam(sessionBean.getTalkFlag());
                    SessionListFragment.this.setAtType(sessionBean.getTalkerAccount(), sessionBean.getTalkType());
                    sessionBean.setNotReadCount(0);
                    SessionListFragment.this.updateUnReadMessageCount(sessionBean);
                }
            }
        });
    }

    @Override
    public void deleteSessionParam(final String sessionFlag) {
        ((DiskDataStore)this.diskDataStore.get()).deleteSessionParam(sessionFlag, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Delete session param failed.");
            }

            public void onNext(Boolean aBoolean) {
                LogUtil.d("Delete session param successfully. sessionFlag:" + sessionFlag);
                IMProxyMessageEvent.RefreshMessageListEvent event = new IMProxyMessageEvent.RefreshMessageListEvent();
                event.setNeedClearInput(true);
                BusProvider.getInstance().post(event);
            }
        });
    }

    @Override
    public void setSessionTop(int position) {
        TalkSessionBean sessionBean = this.mSessionList.get(position);
        if (sessionBean == null || TextUtils.isEmpty((CharSequence)sessionBean.getTalkFlag())) {
            LogUtil.e("ERROR: set session top, but session info is null.");
            return;
        }
        this.setSessionTop(sessionBean.getTalkFlag());
    }

    private void setSessionTop(final @NonNull String talkFlag) {
        if (TextUtils.isEmpty((CharSequence)talkFlag)) {
            return;
        }
        ((CloudDataStore)this.cloudDataStore.get()).setCloudSessionTop(talkFlag, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: set session top error." + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    SessionListFragment.this.setLocalSessionTop(talkFlag, true);
                }
            }
        });
    }

    @Override
    public void deleteSessionTop(int position) {
        TalkSessionBean sessionBean = this.mSessionList.get(position);
        if (sessionBean == null || TextUtils.isEmpty((CharSequence)sessionBean.getTalkFlag())) {
            LogUtil.e("ERROR: set session top, but session info is null.");
            return;
        }
        this.deleteSessionTop(sessionBean.getTalkFlag());
    }

    private void deleteSessionTop(final @NonNull String talkFlag) {
        if (TextUtils.isEmpty((CharSequence)talkFlag)) {
            return;
        }
        ((CloudDataStore)this.cloudDataStore.get()).deleteSettingTopAtCloud(talkFlag, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: set session top error." + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    SessionListFragment.this.setLocalSessionTop(talkFlag, false);
                }
            }
        });
    }

    private void setLocalSessionTop(final @NonNull String talkFlag, final boolean isTop) {
        if (TextUtils.isEmpty((CharSequence)talkFlag)) {
            return;
        }
        ((DiskDataStore)this.diskDataStore.get()).setSessionTop(talkFlag, isTop, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: set session top error." + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                TalkSessionBean sessionBean = SessionListFragment.this.findTalkById(talkFlag);
                if (sessionBean == null || TextUtils.isEmpty((CharSequence)sessionBean.getTalkFlag())) {
                    LogUtil.e("ERROR: set session top, but session info is null.");
                    return;
                }
                SessionParam param = sessionBean.getParam();
                if (param == null) {
                    param = new SessionParam();
                    sessionBean.setParam(param);
                }
                param.setShowOnTopTime(System.currentTimeMillis());
                sessionBean.getParam().setTop(isTop);
                Collections.sort(SessionListFragment.this.mSessionList);
                SessionListFragment.this.mAdapter.notifyDataSetChanged();
            }
        });
    }

    @Override
    public TalkSessionBean isSessionTalk(int position) {
        TalkSessionBean sessionBean = this.mSessionList.get(position);
        if (sessionBean == null) {
            LogUtil.e("ERROR: set session top, but session info is null.");
            return null;
        }
        return sessionBean;
    }

    @Override
    public void setDisturb(int position) {
        TalkSessionBean sessionBean = this.mSessionList.get(position);
        if (sessionBean == null || TextUtils.isEmpty((CharSequence)sessionBean.getTalkFlag())) {
            LogUtil.e("ERROR: set session top, but session info is null.");
            return;
        }
        this.setDisturb(sessionBean.getTalkFlag());
    }

    private void setDisturb(final @NonNull String talkFlag) {
        if (TextUtils.isEmpty((CharSequence)talkFlag)) {
            return;
        }
        String[] message = talkFlag.split("_");
        String talkAccount = message[0];
        int type = Integer.parseInt(message[1]);
        ((CloudDataStore)this.cloudDataStore.get()).saveNoDisturb2Cloud(talkFlag, talkAccount, type, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    SessionListFragment.this.setLocalDisturb(talkFlag, true);
                }
            }
        });
    }

    @Override
    public void deleteDisturb(int position) {
        TalkSessionBean sessionBean = this.mSessionList.get(position);
        if (sessionBean == null || TextUtils.isEmpty((CharSequence)sessionBean.getTalkFlag())) {
            LogUtil.e("ERROR: set session top, but session info is null.");
            return;
        }
        this.deleteDisturb(sessionBean.getTalkFlag());
    }

    private void deleteDisturb(final @NonNull String talkFlag) {
        if (TextUtils.isEmpty((CharSequence)talkFlag)) {
            return;
        }
        String[] message = talkFlag.split("_");
        String talkAccount = message[0];
        int type = Integer.parseInt(message[1]);
        ((CloudDataStore)this.cloudDataStore.get()).deleteNoDisturbAtCloud(talkFlag, talkAccount, type, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    SessionListFragment.this.setLocalDisturb(talkFlag, false);
                }
            }
        });
    }

    public void setLocalDisturb(final @NonNull String talkFlag, final boolean isDisturb) {
        if (TextUtils.isEmpty((CharSequence)talkFlag)) {
            return;
        }
        ((DiskDataStore)this.diskDataStore.get()).setSessionDisturb(talkFlag, isDisturb, new Subscriber<Boolean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: set session disturb error." + e.getMessage());
            }

            public void onNext(Boolean aBoolean) {
                TalkSessionBean sessionBean = SessionListFragment.this.findTalkById(talkFlag);
                if (sessionBean == null || TextUtils.isEmpty((CharSequence)sessionBean.getTalkFlag())) {
                    LogUtil.e("ERROR: set session top, but session info is null.");
                    return;
                }
                SessionParam param = sessionBean.getParam();
                if (param == null) {
                    param = new SessionParam();
                    sessionBean.setParam(param);
                }
                sessionBean.getParam().setDisturb(isDisturb);
                Collections.sort(SessionListFragment.this.mSessionList);
                SessionListFragment.this.mAdapter.notifyDataSetChanged();
                SessionListFragment.this.calculateReadMessageCount(SessionListFragment.this.mSessionList);
            }
        });
    }

    @Override
    public boolean isDisturb(int position) {
        TalkSessionBean sessionBean = this.mSessionList.get(position);
        if (sessionBean == null) {
            LogUtil.e("ERROR: set session top, but session info is null.");
            return false;
        }
        if (sessionBean.getParam() == null) {
            return false;
        }
        return sessionBean.getParam().isDisturb();
    }

    @Override
    public MeetInfo ifShowMeetTip() {
        return this.mMeetInfo;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        try {
            BusProvider.getInstance().unregister(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TalkSessionBean addNewSession(TalkSessionBean eventBean, int index) {
        SessionParam param = this.mSessionList.get(index).getParam();
        if (param == null) {
            param = new SessionParam();
            param.setDraftContent("");
            param.setDraftTime(0L);
        }
        eventBean.setParam(param);
        return eventBean;
    }

    private TalkSessionBean updateSession(TalkSessionBean eventBean, int index) {
        TalkSessionBean bean = this.mSessionList.get(index);
        SessionParam param = bean.getParam();
        if (param == null) {
            param = new SessionParam();
        }
        if (eventBean.getParam() != null) {
            param.setDraftContent(eventBean.getParam().getDraftContent());
            param.setDraftTime(eventBean.getParam().getDraftTime());
            if (0L != eventBean.getParam().getDraftTime()) {
                bean.setLastTime(eventBean.getParam().getDraftTime());
            }
        } else {
            bean.setContent(eventBean.getContent());
            bean.setLastTime(eventBean.getLastTime());
            bean.setLastMsg(eventBean.getLastMsg());
            param.setDraftContent("");
            param.setDraftTime(0L);
        }
        bean.setParam(param);
        bean.setNotReadCount(0);
        return bean;
    }

    @Subscribe
    public void onCreateNewSession(IMProxySessionEvent.CreateNewSessionEvent event) {
        LogUtil.d("EVENT: onCreateNewSession.");
        TalkSessionBean talkSessionBean = event.getSessionBean();
        if (talkSessionBean == null) {
            LogUtil.e("ERROR: create new session failed.");
            return;
        }
        if (this.mSessionList.contains(talkSessionBean)) {
            LogUtil.w("This session is exits. do not need to create.");
            return;
        }
        this.createNewSession(talkSessionBean);
    }

    @Subscribe
    public void onDeleteSession(IMProxySessionEvent.DeleteSessionEvent event) {
        LogUtil.d("EVENT: onDeleteSession.");
        TalkSessionBean talkSessionBean = event.getSessionBean();
        if (talkSessionBean == null) {
            LogUtil.e("ERROR: delete session failed.");
            return;
        }
        String sessionFlag = ToolUtils.getSessionTag(talkSessionBean.getTalkerAccount(), talkSessionBean.getTalkType());
        this.deleteSessionParam(sessionFlag);
    }

    @Subscribe
    public void onRefreshSession(IMProxySessionEvent.RefreshSessionEvent event) {
        TalkSessionBean bean;
        LogUtil.d("EVENT: onRefreshSession");
        TalkSessionBean eventBean = event.getSessionBean();
        if (eventBean == null) {
            LogUtil.w("ERROR: refresh session, but bean is null.");
            return;
        }
        int index = this.mSessionList.indexOf(eventBean);
        if (index < 0 || index >= this.mSessionList.size()) {
            LogUtil.w("ERROR: Index outOfBounds error.");
            this.startLoadSessionData();
            return;
        }
        if (event.isUpdateData()) {
            this.isNotify = true;
            bean = this.updateSession(eventBean, index);
        } else {
            bean = this.addNewSession(eventBean, index);
        }
        this.mSessionList.set(index, bean);
        Collections.sort(this.mSessionList);
        this.mAdapter.notifyDataSetChanged();
        LogUtil.d("onRefreshSession is need notify:" + this.isNotify);
        this.calculateReadMessageCount(this.mSessionList);
    }

    @Subscribe
    public void onRefreshSessionList(IMProxySessionEvent.RefreshSessionListEvent event) {
        LogUtil.d("EVENT: onRefreshSessionList");
        this.startLoadSessionData();
    }

    @Subscribe
    public void onDissolutionGroupEvent(IMContactEvent.DissolutionGroupEvent event) {
        LogUtil.d("EVENT: dissolution group event.");
        LogUtil.d("Dissolution groupId " + event.getAccount());
        String sessionFlag = ToolUtils.getSessionTag(event.getAccount(), 2);
        this.deleteSession(sessionFlag);
    }

    @Subscribe
    public void onDataTimeChanged(IMProxyEvent.DataTimeChangedEvent event) {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void onDeleteAllMessage(IMProxySessionEvent.ClearUnReadMsgEvent event) {
        LogUtil.d("EVENT: onDeleteAllMessage");
        for (TalkSessionBean sessionBean : this.mSessionList) {
            if (!sessionBean.getTalkFlag().equals(event.getTalkId())) continue;
            this.updateUnReadMessageCount(sessionBean);
        }
    }

    @Subscribe
    public void NetworkStateChange(IMProxyEvent.NetworkStateEvent event) {
        Log.d((String)"---wz---", (String)("NetworkStateEvent : " + event.getState()));
        ((SessionListVu)this.getVu()).changeViewSate(event.getState());
        this.copySessionList.clear();
        this.copySessionList.addAll(this.mSessionList);
        this.loadSessionParams(this.copySessionList);
    }

    @Subscribe
    public void onRefreshMeetState(IMProxyMessageEvent.ChatMeetRefreshStateHintEvent event) {
        if (event == null || event.getMeetInfo() == null) {
            return;
        }
        MeetInfo meetInfo = event.getMeetInfo();
        if (meetInfo != null) {
            this.startLoadSessionData();
        }
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void onReceiveNewMessage(IMProxyMessageEvent.ReceiveNewMessageEvent event) {
        if (event == null) {
            return;
        }
        boolean isHaveAtMessage = false;
        for (TalkMessageBean talkMessageBean : event.getTalkMessageList()) {
            if (talkMessageBean.getMessageType() != 14) continue;
            isHaveAtMessage = true;
            break;
        }
        if (isHaveAtMessage) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void onUpdateSessionAccount(IMProxyUpdateSession updateSession) {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void onUpDateSessionConfig(IMProxyUpdateSession.UpDateSessionConfig upDateSessionConfig) {
        if (upDateSessionConfig == null) {
            return;
        }
        String talkFlag = upDateSessionConfig.getTalkFlag();
        boolean setting = upDateSessionConfig.isSetting();
        String message = upDateSessionConfig.getMessage();
        if (TextUtils.isEmpty((CharSequence)talkFlag) || TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (upDateSessionConfig.isSave()) {
            TalkSessionBean sessionBean = this.findTalkById(talkFlag);
            if (sessionBean == null || TextUtils.isEmpty((CharSequence)sessionBean.getTalkFlag())) {
                LogUtil.e("ERROR: set session top, but session info is null.");
                return;
            }
            SessionParam param = sessionBean.getParam();
            if (param == null) {
                param = new SessionParam();
                sessionBean.setParam(param);
            }
            if (message.equals("disturb")) {
                sessionBean.getParam().setDisturb(setting);
                Collections.sort(this.mSessionList);
                this.mAdapter.notifyDataSetChanged();
                this.calculateReadMessageCount(this.mSessionList);
            } else {
                param.setShowOnTopTime(System.currentTimeMillis());
                sessionBean.getParam().setTop(setting);
                Collections.sort(this.mSessionList);
                this.mAdapter.notifyDataSetChanged();
            }
        } else {
            this.setImUiKitSessionConfigUpdate(talkFlag, message, setting);
        }
    }

    public void setAtType(String mTalkId, int mTalkType) {
        if (mTalkType == 2) {
            AtPreferencesUtils.getWrapper(ActomaController.getAppConfigContext(), "at").setPreferenceBooleanValue(mTalkId, false);
        }
    }

    public void setImUiKitSessionConfigUpdate(String talkFlag, String type, boolean setting) {
        if (TextUtils.isEmpty((CharSequence)type) || TextUtils.isEmpty((CharSequence)talkFlag)) {
            return;
        }
        TalkSessionBean talkSessionBean = this.findTalkById(talkFlag);
        if (talkSessionBean != null) {
            SessionParam param = talkSessionBean.getParam();
            if (param == null) {
                param = new SessionParam();
                talkSessionBean.setParam(param);
            }
            if (type.equals("disturb")) {
                talkSessionBean.getParam().setDisturb(setting);
                Collections.sort(this.mSessionList);
                this.mAdapter.notifyDataSetChanged();
                this.calculateReadMessageCount(this.mSessionList);
            } else {
                talkSessionBean.getParam().setTop(setting);
                talkSessionBean.getParam().setShowOnTopTime(System.currentTimeMillis());
                Collections.sort(this.mSessionList);
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    private TalkSessionBean findTalkById(String flag) {
        if (this.mSessionList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.mSessionList.size(); ++i) {
            TalkSessionBean listBean = this.mSessionList.get(i);
            if (listBean == null || !listBean.getTalkFlag().equalsIgnoreCase(flag)) continue;
            return listBean;
        }
        return null;
    }
}

