/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassUtils {
    private ClassUtils() {
    }

    public static ClassUtils getInstance() {
        return Holder.instance;
    }

    public final List<Class> getActivitiesClass(Context context, List<Class> excludeList) {
        ArrayList<Class> returnClassList = new ArrayList<Class>();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 1);
            if (packageInfo.activities != null) {
                LogUtil.d("Found " + packageInfo.activities.length + " activity in the AndrodiManifest.xml");
                for (ActivityInfo ai : packageInfo.activities) {
                    try {
                        Class<?> c = Class.forName(ai.name);
                        if (!Activity.class.isAssignableFrom(c)) continue;
                        returnClassList.add(c);
                        LogUtil.d(ai.name + "...OK");
                    }
                    catch (ClassNotFoundException e) {
                        LogUtil.d("Class Not Found:" + ai.name);
                    }
                }
                LogUtil.d("Filter out, left " + returnClassList.size() + " activity," + Arrays.toString(returnClassList.toArray()));
                if (excludeList != null) {
                    returnClassList.removeAll(excludeList);
                    LogUtil.d("Exclude " + excludeList.size() + " activity," + Arrays.toString(excludeList.toArray()));
                }
                LogUtil.d("Return " + returnClassList.size() + " activity," + Arrays.toString(returnClassList.toArray()));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return returnClassList;
    }

    public final List<String> getActivitiesNames(Context context) {
        ArrayList<String> returnClassList = new ArrayList<String>();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 1);
            if (packageInfo.activities != null) {
                LogUtil.d("Found " + packageInfo.activities.length + " activity in the AndrodiManifest.xml");
                for (ActivityInfo ai : packageInfo.activities) {
                    try {
                        Class<?> c = Class.forName(ai.name);
                        if (!Activity.class.isAssignableFrom(c)) continue;
                        returnClassList.add(ai.name);
                        LogUtil.d(ai.name + "...OK");
                    }
                    catch (ClassNotFoundException e) {
                        LogUtil.d("Class Not Found:" + ai.name);
                    }
                }
                LogUtil.d("Filter out, left " + returnClassList.size() + " activity," + Arrays.toString(returnClassList.toArray()));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return returnClassList;
    }

    public boolean isRegisterActivity(Context context, String className) {
        boolean isRegister = false;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 1);
            if (packageInfo.activities != null) {
                for (ActivityInfo ai : packageInfo.activities) {
                    String activityName = ai.name;
                    if (!activityName.contains(className)) continue;
                    isRegister = true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return isRegister;
    }

    private static final class Holder {
        private static final ClassUtils instance = new ClassUtils();

        private Holder() {
        }
    }
}

