/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.xdja.im.lib.filemanage.util.ActomaController;

public class PromptPictureUtils
extends ContentObserver {
    public Uri imageUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    private static PromptPictureUtils promptPictureUtils;
    public boolean isImageChange = false;

    public PromptPictureUtils(Handler handler) {
        super(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PromptPictureUtils getInstance() {
        if (promptPictureUtils != null) return promptPictureUtils;
        Class<PromptPictureUtils> clazz = PromptPictureUtils.class;
        synchronized (PromptPictureUtils.class) {
            if (promptPictureUtils != null) return promptPictureUtils;
            promptPictureUtils = new PromptPictureUtils(new Handler());
            // ** MonitorExit[var0] (shouldn't be in output)
            return promptPictureUtils;
        }
    }

    public void onChange(boolean selfChange, Uri uri) {
        super.onChange(selfChange);
        if (MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString().equalsIgnoreCase(uri.toString())) {
            this.isImageChange = true;
        }
    }

    public void registerContentObserver(Context context) {
        if (context != null && context.getContentResolver() != null) {
            context.getContentResolver().registerContentObserver(this.imageUri, false, (ContentObserver)this);
        }
    }

    public void unRegisterContentObserver(Context context) {
        if (context != null && context.getContentResolver() != null) {
            try {
                context.getContentResolver().unregisterContentObserver((ContentObserver)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getLatestPhotoPath() {
        long imageDate = 0L;
        String path = null;
        if (this.isImageChange) {
            String[] projection = new String[]{"_id", "_display_name", "_data", "_size", "width", "height", "mime_type", "date_added"};
            String sortOrder = "date_modified desc";
            Cursor cursor = ActomaController.getAppConfigContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, sortOrder);
            if (cursor != null && cursor.moveToNext()) {
                path = cursor.getString(cursor.getColumnIndex("_data"));
                String dateAdd = cursor.getString(cursor.getColumnIndex("date_added"));
                if (!TextUtils.isEmpty((CharSequence)dateAdd)) {
                    imageDate = Long.valueOf(dateAdd);
                }
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        this.isImageChange = false;
        long curTime = System.currentTimeMillis() / 1000L;
        if (curTime - imageDate <= 30L) {
            return path;
        }
        return null;
    }
}

