/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.PromptPictureUtils;
import com.xdja.im.uikit.utils.image.BitmapUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;

public class PromptPictureView
extends LinearLayout {
    private ImageView mImageView;
    private String path;

    public PromptPictureView(Context context) {
        this(context, null);
    }

    public PromptPictureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PromptPictureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        View fastImageView = LayoutInflater.from((Context)context).inflate(R.layout.im_uikit_fast_image_view, null);
        this.mImageView = (ImageView)fastImageView.findViewById(R.id.image_fast_send);
        this.addView(fastImageView);
    }

    public void loadImage(String url) {
        this.path = url;
        try {
            File file = new File(url);
            LogUtil.d("PromptPictureView url " + url);
            if (file.exists()) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = 8;
                Bitmap bmp = BitmapFactory.decodeFile((String)url, (BitmapFactory.Options)options);
                LogUtil.d("PromptPictureView bmp " + bmp);
                if (bmp == null) {
                    this.setVisibility(8);
                    PromptPictureUtils.getInstance().isImageChange = true;
                    return;
                }
                Bitmap bmpCrop = BitmapUtils.imageCrop(bmp);
                if (bmpCrop == null) {
                    PromptPictureUtils.getInstance().isImageChange = true;
                    this.setVisibility(8);
                    return;
                }
                this.mImageView.setImageBitmap(bmpCrop);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PromptPictureView.this.setVisibility(8);
                    }
                }, 10000L);
            } else {
                PromptPictureUtils.getInstance().isImageChange = true;
                this.setVisibility(8);
                return;
            }
            PromptPictureUtils.getInstance().isImageChange = false;
        }
        catch (Exception e) {
            LogUtil.d("PromptPictureView exception");
            PromptPictureUtils.getInstance().isImageChange = true;
            this.setVisibility(8);
            return;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.setVisibility(8);
    }
}

