/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db;

import android.content.Context;
import android.content.ContextWrapper;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;

public class ImSdkContext
extends ContextWrapper {
    private Context context;
    private String account;

    public ImSdkContext(Context context, String account) {
        super(context);
        this.context = context;
        this.account = account;
    }

    public File getDatabasePath(String name) {
        if (this.context == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        String dirBuilder = this.context.getFilesDir().getParent() + File.separator + "XdjaIm" + File.separator + this.account;
        File dir = new File(dirBuilder);
        File file = new File(dir, name);
        boolean mkDir = false;
        if (!dir.exists()) {
            mkDir = dir.mkdirs();
        }
        if (mkDir && !file.exists()) {
            try {
                if (file.createNewFile()) {
                    return file;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        if (this.context == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        SQLiteDatabase result = SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), (SQLiteDatabase.CursorFactory)factory);
        return result;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        if (this.context == null || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        SQLiteDatabase result = SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), (SQLiteDatabase.CursorFactory)factory);
        return result;
    }
}

