/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.xdja.imsdk.db.bean.GroupReadDb;
import com.xdja.imsdk.db.builder.GroupReadBuilder;
import com.xdja.imsdk.db.dao.AbstractDao;
import com.xdja.imsdk.db.helper.UpdateArgs;
import java.util.HashMap;
import java.util.Map;

public class GroupReadDao
extends AbstractDao<GroupReadDb> {
    private static GroupReadDao instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupReadDao getInstance() {
        if (instance != null) return instance;
        Class<GroupReadDao> clazz = GroupReadDao.class;
        synchronized (GroupReadDao.class) {
            instance = new GroupReadDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public long insert(GroupReadDb readDb) {
        return this.insert(readDb, GroupReadBuilder.insertSql());
    }

    public void updateGroupRead(UpdateArgs args) {
        this.update(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> queryReadList(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        Cursor cursor = null;
        try {
            cursor = this.query(query);
            while (cursor != null && cursor.moveToNext()) {
                result.put("read", cursor.getString(cursor.getColumnIndex("READ_LIST")));
                result.put("unread", cursor.getString(cursor.getColumnIndex("UNREAD_LIST")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return result;
    }

    @Override
    protected GroupReadDb readEntry(Cursor cursor, int offset) {
        GroupReadDb entity = new GroupReadDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : Long.valueOf(cursor.getLong(offset + 1)), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), cursor.isNull(offset + 4) ? null : Long.valueOf(cursor.getLong(offset + 4)));
        return entity;
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, GroupReadDb entity) {
        Long insert_time;
        String unread_list;
        String read_list;
        Long group_server_id;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((group_server_id = entity.getGroup_server_id()) != null) {
            stmt.bindLong(2, group_server_id.longValue());
        }
        if ((read_list = entity.getRead_list()) != null) {
            stmt.bindString(3, read_list);
        }
        if ((unread_list = entity.getUnread_list()) != null) {
            stmt.bindString(4, unread_list);
        }
        if ((insert_time = entity.getInsert_time()) != null) {
            stmt.bindLong(5, insert_time.longValue());
        }
    }
}

