/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.file;

import android.text.TextUtils;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import java.io.File;

public class FileEntry {
    private String path;
    private String encryptPath;
    private String fid;
    private String name;
    private long size;
    private long tSize;
    private long encryptSize;
    private long id;
    private String tag;
    private ImSdkFileConstant.FileType type;
    private int msgType;
    private int state;
    private String md5;
    private int count;
    private String mSuffix;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getEncryptPath() {
        return this.encryptPath;
    }

    public void setEncryptPath(String encryptPath) {
        this.encryptPath = encryptPath;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public String getName() {
        if (TextUtils.isEmpty((CharSequence)this.name) && !TextUtils.isEmpty((CharSequence)this.path)) {
            this.name = this.path.substring(this.path.lastIndexOf(File.separator));
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long gettSize() {
        return this.tSize;
    }

    public void settSize(long tSize) {
        this.tSize = tSize;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public ImSdkFileConstant.FileType getType() {
        return this.type;
    }

    public void setType(ImSdkFileConstant.FileType type) {
        this.type = type;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getEncryptSize() {
        return this.encryptSize;
    }

    public void setEncryptSize(long encryptSize) {
        this.encryptSize = encryptSize;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isNormal() {
        return this.msgType == 0;
    }

    public boolean isImage() {
        return this.msgType == 3;
    }

    public boolean isVoice() {
        return this.msgType == 1;
    }

    public boolean isVideo() {
        return this.msgType == 2;
    }

    public boolean isPic() {
        return this.msgType == 5;
    }

    public boolean isMedia() {
        return this.msgType == 6;
    }

    public boolean isUnknow() {
        return this.msgType == 100;
    }

    public boolean isWeb() {
        return this.msgType == 4;
    }

    public boolean isShow() {
        return this.type == ImSdkFileConstant.FileType.IS_SHOW;
    }

    public boolean isHd() {
        return this.type == ImSdkFileConstant.FileType.IS_HD;
    }

    public boolean isRaw() {
        return this.type == ImSdkFileConstant.FileType.IS_RAW;
    }

    public int getPercent() {
        if (this.encryptSize > 0L) {
            return (int)(this.tSize / this.encryptSize * 100L);
        }
        return 0;
    }

    public boolean isFinish() {
        return this.count > 0;
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    public void setSuffix(String suffix) {
        this.mSuffix = suffix;
    }

    public String toString() {
        return "FileEntry{path='" + this.path + '\'' + ", encryptPath='" + this.encryptPath + '\'' + ", fid='" + this.fid + '\'' + ", name='" + this.name + '\'' + ", size=" + this.size + ", tSize=" + this.tSize + ", encryptSize=" + this.encryptSize + ", id=" + this.id + ", tag='" + this.tag + '\'' + ", type=" + (Object)((Object)this.type) + ", msgType=" + this.msgType + ", state=" + this.state + ", md5='" + this.md5 + '\'' + ", count='" + this.count + '\'' + ", suffix='" + this.mSuffix + '\'' + '}';
    }
}

