/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.constant.internal.HttpApiConstant;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.db.helper.OptHelper;
import com.xdja.imsdk.http.RequestInfo;
import com.xdja.imsdk.http.SecurityHttps;
import com.xdja.imsdk.http.callback.IHttpCallback;
import com.xdja.imsdk.http.callback.IPostCallback;
import com.xdja.imsdk.http.config.ImRequestConfig;
import com.xdja.imsdk.http.file.FileEntry;
import com.xdja.imsdk.http.file.callback.IFileDownloadCallback;
import com.xdja.imsdk.http.file.callback.IFileUploadCallback;
import com.xdja.imsdk.http.okhttp.ProgressListener;
import com.xdja.imsdk.http.okhttp.constant.OkHttpConstants;
import com.xdja.imsdk.http.okhttp.interceptor.FileChunkInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.FileIdInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.LoggingInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.NetworkStateInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.ProgressInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.RetryInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.SignInterceptor;
import com.xdja.imsdk.http.okhttp.interceptor.TicketInterceptor;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.HttpManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.util.CRC32Util;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.JsonUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

public class OkHttpManager
extends HttpManager {
    private static final OkHttpManager ourInstance = new OkHttpManager();
    private static final int MAX_FILE_NAME_LENGTH = 128;
    private OkHttpClient mClient;
    private OkHttpClient fileClient;

    public static OkHttpManager getInstance() {
        return ourInstance;
    }

    private OkHttpManager() {
    }

    private synchronized OkHttpClient getCurrentClient(boolean isFile) {
        if (isFile) {
            if (this.fileClient == null) {
                return this.getClient();
            }
            return this.fileClient;
        }
        return this.getClient();
    }

    private synchronized OkHttpClient getClient() {
        if (this.mClient == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.mClient;
    }

    private synchronized OkHttpClient getFileClient() {
        return this.fileClient;
    }

    private synchronized void resetClient() {
        this.mClient = null;
        this.fileClient = null;
    }

    @Override
    protected synchronized void initClient(Context context, int keyStoreId, String keyStorePassword) {
        if (this.mClient == null) {
            SecurityHttps.SSLParams sslParams = SecurityHttps.getSSLParams(context, keyStoreId, keyStorePassword);
            this.mClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).sslSocketFactory(sslParams.sSLSocketFactory).addInterceptor((Interceptor)new LoggingInterceptor()).addNetworkInterceptor((Interceptor)new NetworkStateInterceptor(new NetworkStateInterceptor.Callback(){

                @Override
                public void onState(int code) {
                    if (OkHttpManager.this.mCallback != null) {
                        OkHttpManager.this.mCallback.NetChanged(code);
                    }
                }
            })).build();
            this.notifyAll();
        }
    }

    @Override
    protected synchronized void initTwoClient(Context context, int keyStoreId, String keyStorePassword, int fileKeyStoreId, String fileKeyStorePassword) {
        SecurityHttps.SSLParams sslParams;
        if (this.fileClient == null) {
            sslParams = SecurityHttps.getSSLParams(context, fileKeyStoreId, fileKeyStorePassword);
            this.fileClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).sslSocketFactory(sslParams.sSLSocketFactory).addInterceptor((Interceptor)new LoggingInterceptor()).addNetworkInterceptor((Interceptor)new NetworkStateInterceptor(new NetworkStateInterceptor.Callback(){

                @Override
                public void onState(int code) {
                    if (OkHttpManager.this.mCallback != null) {
                        OkHttpManager.this.mCallback.NetChanged(code);
                    }
                }
            })).build();
            this.notifyAll();
        }
        if (this.mClient == null) {
            sslParams = SecurityHttps.getSSLParams(context, keyStoreId, keyStorePassword);
            this.mClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).sslSocketFactory(sslParams.sSLSocketFactory).addInterceptor((Interceptor)new LoggingInterceptor()).addNetworkInterceptor((Interceptor)new NetworkStateInterceptor(new NetworkStateInterceptor.Callback(){

                @Override
                public void onState(int code) {
                    if (OkHttpManager.this.mCallback != null) {
                        OkHttpManager.this.mCallback.NetChanged(code);
                    }
                }
            })).build();
            this.notifyAll();
        }
    }

    @Override
    protected void doImRequest(final JSONObject object, ImRequestConfig config, final IHttpCallback callback) {
        if (this.getCurrentClient(false) == null) {
            Logger.getLogger().e("OkHttp NOT INIT");
            return;
        }
        String postUrl = this.getPostUrl(config);
        if (TextUtils.isEmpty((CharSequence)postUrl)) {
            Logger.getLogger().e("Invalid http url");
            callback.onFailed(50100, object);
            return;
        }
        HttpUrl url = HttpUrl.parse((String)postUrl);
        if (url == null) {
            Logger.getLogger().e("Invalid http url");
            callback.onFailed(50100, object);
            return;
        }
        final String method = HttpApiConstant.IMRequestType.STATE.equals((Object)config.getpType()) ? "PUT" : "POST";
        OkHttpClient client = this.getCurrentClient(false).newBuilder().addInterceptor((Interceptor)new TicketInterceptor()).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Callback(){

            @Override
            @NonNull
            public Request createRequest(Request originalRequest) {
                return originalRequest.newBuilder().method(method, RequestBody.create((MediaType)OkHttpConstants.MEDIA_TYPE_JSON, (String)object.toString())).build();
            }
        })).build();
        Request request = new Request.Builder().url(url).method(method, RequestBody.create((MediaType)OkHttpConstants.MEDIA_TYPE_JSON, (String)object.toString())).tag((Object)config.getMsgId()).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.onFailed(50102, object);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                try {
                    String result = response.body().string();
                    if (response.isSuccessful()) {
                        callback.onSuccess(new JSONObject(result));
                    } else {
                        callback.onFailed(response.code(), object, result);
                    }
                }
                catch (IOException | JSONException e) {
                    e.printStackTrace();
                    Logger.getLogger().e("Request im json exception object : " + object + ", e : " + e);
                    callback.onFailed(50102, object);
                }
            }
        });
    }

    @Override
    public void postAsync(final @NonNull RequestInfo requestInfo, final IPostCallback callback) {
        if (this.getCurrentClient(false) == null) {
            Logger.getLogger().e("OkHttp NOT INIT");
            return;
        }
        String requestUrl = requestInfo.getUrl();
        if (TextUtils.isEmpty((CharSequence)requestUrl)) {
            Logger.getLogger().e("Invalid http url");
            callback.onFailed(50100, requestInfo);
            return;
        }
        HttpUrl url = HttpUrl.parse((String)requestUrl);
        if (url == null) {
            Logger.getLogger().e("Invalid http url");
            callback.onFailed(50100, requestInfo);
            return;
        }
        OkHttpClient client = this.getCurrentClient(false).newBuilder().addInterceptor((Interceptor)new TicketInterceptor()).build();
        Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)OkHttpConstants.MEDIA_TYPE_JSON, (String)requestInfo.getJson())).tag((Object)requestInfo.getTag()).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.onFailed(40000, requestInfo);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                if (response.isSuccessful()) {
                    callback.onSuccess(response.body().string(), requestInfo);
                } else {
                    callback.onFailed(response.code(), requestInfo);
                }
            }
        });
    }

    @Override
    public void postAsync(@NonNull String url, @Nullable Object content, final @NonNull HttpManager.HttpCallback callback) {
        if (this.getCurrentClient(false) == null) {
            Logger.getLogger().e("OkHttp NOT INIT");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            Logger.getLogger().e("Invalid http url");
            callback.onFailed();
            return;
        }
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            Logger.getLogger().e("Invalid http url");
            callback.onFailed();
            return;
        }
        OkHttpClient client = this.getCurrentClient(false).newBuilder().connectTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).addInterceptor((Interceptor)new TicketInterceptor()).build();
        Request request = new Request.Builder().url(httpUrl).post(RequestBody.create((MediaType)OkHttpConstants.MEDIA_TYPE_JSON, (String)JsonUtils.getGson().toJson(content))).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.onFailed();
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                if (response.isSuccessful()) {
                    callback.onSuccess(response.body().string());
                } else {
                    callback.onFailed();
                }
            }
        });
    }

    @Override
    public void uploadFile(final FileEntry entry, final IFileUploadCallback callback) {
        if (this.getCurrentClient(true) == null) {
            Logger.getLogger().e("OkHttp NOT INIT");
            return;
        }
        String dfsUrl = ImSdkConfigManager.getInstance().getFastDfsUpload();
        if (TextUtils.isEmpty((CharSequence)dfsUrl)) {
            Logger.getLogger().e("Invalid http url");
            callback.uploadFileError(50100, entry);
            return;
        }
        HttpUrl url = HttpUrl.parse((String)dfsUrl);
        if (url == null) {
            Logger.getLogger().e("Invalid http url");
            callback.uploadFileError(50100, entry);
            return;
        }
        final SignInterceptor signInterceptor = new SignInterceptor("4", entry.getFid());
        File file = new File(entry.getEncryptPath());
        final FileChunkInterceptor fileChunkInterceptor = new FileChunkInterceptor(file, new ProgressListener(){

            @Override
            public void update(long byteCount, int progress, boolean done) {
                entry.settSize(byteCount);
                callback.uploadFileProgressUpdate(progress, entry);
            }
        });
        OkHttpClient client = this.getCurrentClient(true).newBuilder().writeTimeout(5L, TimeUnit.MINUTES).addInterceptor((Interceptor)signInterceptor).addInterceptor((Interceptor)fileChunkInterceptor).addInterceptor((Interceptor)new FileIdInterceptor(new FileIdInterceptor.Callback(){

            @Override
            public void onFileIdObtained(String fileId) {
                entry.setFid(fileId);
                callback.uploadFileStart(entry);
            }
        })).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Callback(){

            @Override
            @NonNull
            public Request createRequest(Request originalRequest) {
                return originalRequest.newBuilder().url(signInterceptor.createSignUrl(originalRequest.url())).post(fileChunkInterceptor.createRequestBody()).build();
            }
        })).build();
        Request request = new Request.Builder().url(url).header("filename", this.getValidFileName(entry)).header("filesize", String.valueOf(entry.getEncryptSize())).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.uploadFileError(50035, entry);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                if (response.isSuccessful()) {
                    OkHttpManager.this.getFileInfo(entry, callback);
                } else {
                    callback.uploadFileError(50035, entry);
                }
            }
        });
    }

    private void getFileInfo(final FileEntry entry, final IFileUploadCallback callback) {
        if (this.getCurrentClient(true) == null) {
            Logger.getLogger().e("OkHttp NOT INIT");
            return;
        }
        String fileInfoUrl = ImSdkConfigManager.getInstance().getFastDfsInfo(entry.getFid());
        if (TextUtils.isEmpty((CharSequence)fileInfoUrl)) {
            Logger.getLogger().e("Invalid http url");
            callback.uploadFileError(50100, entry);
            return;
        }
        HttpUrl url = HttpUrl.parse((String)fileInfoUrl);
        if (url == null) {
            Logger.getLogger().e("Invalid http url");
            callback.uploadFileError(50100, entry);
            return;
        }
        OkHttpClient client = this.getCurrentClient(true).newBuilder().addInterceptor((Interceptor)new SignInterceptor("5", entry.getFid())).build();
        Request request = new Request.Builder().url(url).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                callback.uploadFileFinish(entry);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                if (response.isSuccessful()) {
                    String serverCrc32;
                    String localCrc32 = Long.toHexString(CRC32Util.getFileCRC32(entry.getEncryptPath()));
                    if (localCrc32.equals(serverCrc32 = JsonUtils.getString(response.body().string(), "crc32"))) {
                        callback.uploadFileFinish(entry);
                    } else {
                        callback.uploadFileError(50035, entry);
                        OkHttpManager.this.deleteFile(entry);
                    }
                } else {
                    callback.uploadFileFinish(entry);
                    Logger.getLogger().d("Get file info failed: url=" + response.request().url() + ", code=" + response.code() + ", message=" + response.body().string());
                }
            }
        });
    }

    private void deleteFile(final FileEntry entry) {
        if (this.getCurrentClient(true) == null) {
            Logger.getLogger().e("OkHttp NOT INIT");
            return;
        }
        String deleteUrl = ImSdkConfigManager.getInstance().getFastDfsDelete(entry.getFid());
        if (TextUtils.isEmpty((CharSequence)deleteUrl)) {
            Logger.getLogger().e("Invalid http url");
            return;
        }
        HttpUrl url = HttpUrl.parse((String)deleteUrl);
        if (url == null) {
            Logger.getLogger().e("Invalid http url");
            return;
        }
        OkHttpClient client = this.getCurrentClient(true).newBuilder().addInterceptor((Interceptor)new SignInterceptor("9", entry.getFid())).build();
        Request request = new Request.Builder().url(url).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                Logger.getLogger().w("Delete file failed: fileId=" + entry.getFid() + ", error=" + e);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                Logger.getLogger().i("Delete file result: fileId=" + entry.getFid() + ", code=" + response.code() + ", message=" + response.body().string());
            }
        });
    }

    @Override
    protected void pauseFileUpload(String tag) {
        this.cancel(tag);
    }

    @Override
    protected boolean isRepeatedDownload(@NonNull FileEntry entry) {
        String tag = String.valueOf(entry.getId());
        String url = ImSdkConfigManager.getInstance().getFastDfsDownload() + entry.getFid();
        Dispatcher dispatcher = this.getCurrentClient(true).dispatcher();
        for (Call call : dispatcher.queuedCalls()) {
            if (!tag.equals(call.request().tag()) || !url.equals(call.request().url().toString())) continue;
            return true;
        }
        for (Call call : dispatcher.runningCalls()) {
            if (!tag.equals(call.request().tag()) || !url.equals(call.request().url().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void downloadFile(final FileEntry entry, boolean isSupportRange, final IFileDownloadCallback callback) {
        long offset;
        if (this.getCurrentClient(true) == null) {
            Logger.getLogger().e("OkHttp NOT INIT");
            return;
        }
        String downloadUrl = ImSdkConfigManager.getInstance().getFastDfsDownload() + entry.getFid();
        if (TextUtils.isEmpty((CharSequence)downloadUrl)) {
            Logger.getLogger().e("Invalid http url");
            callback.downloadFileError(50100, entry);
            return;
        }
        HttpUrl url = HttpUrl.parse((String)downloadUrl);
        if (url == null) {
            Logger.getLogger().e("Invalid http url");
            callback.downloadFileError(50100, entry);
            return;
        }
        final File file = new File(entry.getEncryptPath());
        if (isSupportRange) {
            offset = entry.gettSize();
        } else {
            if (file.exists()) {
                FileUtils.deleteFile(entry.getEncryptPath());
            }
            offset = 0L;
        }
        final SignInterceptor signInterceptor = new SignInterceptor("6", entry.getFid());
        OkHttpClient client = this.getCurrentClient(true).newBuilder().addInterceptor((Interceptor)signInterceptor).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Callback(){

            @Override
            @NonNull
            public Request createRequest(Request originalRequest) {
                return originalRequest.newBuilder().url(signInterceptor.createSignUrl(originalRequest.url())).build();
            }
        })).addNetworkInterceptor((Interceptor)new ProgressInterceptor(offset, new ProgressListener(){

            @Override
            public void update(long byteCount, int progress, boolean done) {
                entry.settSize(byteCount);
                callback.downloadFileProgressUpdate(progress, entry);
            }
        })).build();
        String rangeValue = String.format(Locale.getDefault(), "bytes=%d-", offset);
        Request request = new Request.Builder().url(url).header("RANGE", rangeValue).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (call.isCanceled()) {
                    callback.downloadFilePause(entry);
                } else {
                    callback.downloadFileError(50036, entry);
                }
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) {
                if (response.isSuccessful()) {
                    ResponseBody body = response.body();
                    try {
                        FileUtils.save(body.byteStream(), body.contentLength(), file, offset);
                        OkHttpManager.this.getFileInfo(entry, callback);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        OkHttpManager.this.handleFileDownloadException(e, entry, callback);
                    }
                } else {
                    callback.downloadFileError(50036, entry);
                }
            }
        });
    }

    @Override
    public void downloadFilePause(FileEntry entry) {
        this.cancel(String.valueOf(entry.getId()));
    }

    @Override
    protected void getFileInfo(final @NonNull FileEntry entry, final @NonNull IFileDownloadCallback callback) {
        if (this.getCurrentClient(true) == null) {
            Logger.getLogger().e("OkHttp NOT INIT");
            return;
        }
        String fileUrl = ImSdkConfigManager.getInstance().getFastDfsInfo(entry.getFid());
        if (TextUtils.isEmpty((CharSequence)fileUrl)) {
            Logger.getLogger().e("Invalid http url");
            callback.downloadFileError(50100, entry);
            return;
        }
        HttpUrl url = HttpUrl.parse((String)fileUrl);
        if (url == null) {
            Logger.getLogger().e("Invalid http url");
            callback.downloadFileError(50100, entry);
            return;
        }
        OkHttpClient client = this.getCurrentClient(true).newBuilder().addInterceptor((Interceptor)new SignInterceptor("5", entry.getFid())).build();
        Request request = new Request.Builder().url(url).tag((Object)String.valueOf(entry.getId())).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (call.isCanceled()) {
                    Logger.getLogger().w("Download file -> get file info canceled: file=" + entry + ", exception=" + e);
                    callback.downloadFilePause(entry);
                } else {
                    Logger.getLogger().w("Download file -> get file info failed: file=" + entry + ", exception=" + e);
                    OkHttpManager.this.checkFileByMD5(entry, callback);
                }
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                if (response.isSuccessful()) {
                    String serverCrc32;
                    String localCrc32 = Long.toHexString(CRC32Util.getFileCRC32(entry.getEncryptPath()));
                    if (localCrc32.equals(serverCrc32 = JsonUtils.getString(response.body().string(), "crc32"))) {
                        callback.downloadFileFinish(entry);
                    } else {
                        Logger.getLogger().w("Download file -> crc32 check failed: file=" + entry + ", localCrc32=" + localCrc32 + ", serverCrc32=" + serverCrc32);
                        OkHttpManager.this.downloadFileAgain(entry, callback);
                    }
                } else {
                    Logger.getLogger().w("Download file -> get file info failed: file=" + entry + ", code=" + response.code() + ", message=" + response.body().string());
                    OkHttpManager.this.checkFileByMD5(entry, callback);
                }
            }
        });
    }

    @Override
    public void cancelRequest(Long msgId) {
        this.cancel(String.valueOf(msgId));
    }

    @Override
    public void cancelAll() {
        this.getClient().dispatcher().cancelAll();
        if (this.getFileClient() != null) {
            this.getFileClient().dispatcher().cancelAll();
        }
        this.resetClient();
    }

    private void cancel(String tag) {
        Dispatcher dispatcher = this.getClient().dispatcher();
        for (Call call : dispatcher.queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : dispatcher.runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        if (this.getFileClient() != null) {
            Dispatcher fileDispatcher = this.getFileClient().dispatcher();
            for (Call call : fileDispatcher.queuedCalls()) {
                if (!tag.equals(call.request().tag())) continue;
                call.cancel();
            }
            for (Call call : fileDispatcher.runningCalls()) {
                if (!tag.equals(call.request().tag())) continue;
                call.cancel();
            }
        }
    }

    @NonNull
    private String getValidFileName(@NonNull FileEntry entry) {
        String fileName = new File(entry.getEncryptPath()).getName();
        String suffix = FileUtils.getSuffix(fileName);
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            fileName = fileName + this.createFileSuffix(entry);
        }
        if (fileName.length() > 128) {
            fileName = fileName.substring(fileName.length() - 128);
        }
        try {
            fileName = URLEncoder.encode(fileName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return fileName;
    }

    @NonNull
    private String createFileSuffix(@NonNull FileEntry entry) {
        if (entry.getMsgType() == 1) {
            return ".amr";
        }
        if (entry.getMsgType() == 2) {
            if (entry.getType() == ImSdkFileConstant.FileType.IS_SHOW) {
                return ".jpg";
            }
            if (entry.getType() == ImSdkFileConstant.FileType.IS_RAW) {
                return ".mp4";
            }
        }
        if (entry.getMsgType() == 3 && (entry.getType() == ImSdkFileConstant.FileType.IS_SHOW || entry.getType() == ImSdkFileConstant.FileType.IS_HD)) {
            return ".jpg";
        }
        if (entry.getMsgType() == 5 && entry.getType() == ImSdkFileConstant.FileType.IS_SHOW) {
            return ".jpg";
        }
        if (entry.getMsgType() == 6 && entry.getType() == ImSdkFileConstant.FileType.IS_SHOW) {
            return ".jpg";
        }
        if (!TextUtils.isEmpty((CharSequence)entry.getSuffix())) {
            return "." + entry.getSuffix();
        }
        String fileType = FileUtils.getFileType(entry.getEncryptPath());
        if (!TextUtils.isEmpty((CharSequence)fileType)) {
            return "." + fileType;
        }
        return ".dat";
    }

    private void handleFileDownloadException(@NonNull IOException e, @NonNull FileEntry entry, @NonNull IFileDownloadCallback callback) {
        Logger.getLogger().w("Download file -> exception: file=" + entry + ", exception=" + e);
        if (e instanceof SocketTimeoutException) {
            this.retryFileDownload(entry, callback);
            callback.downloadNetChanged(40007, entry);
        } else if ("recvfrom failed: ETIMEDOUT (Connection timed out)".equals(e.getMessage()) || "Software caused connection abort".equals(e.getMessage())) {
            this.retryFileDownload(entry, callback);
            callback.downloadNetChanged(40004, entry);
        } else if (e instanceof FileNotFoundException) {
            callback.downloadFileError(50039, entry);
        } else {
            callback.downloadFilePause(entry);
        }
    }

    private void retryFileDownload(@NonNull FileEntry entry, @NonNull IFileDownloadCallback callback) {
        ImSdkDbUtils.update(OptHelper.getIns().getFTUpdate(entry.getType(), entry.gettSize(), entry.getState(), entry.getId()));
        this.downloadFile(entry, true, callback);
    }

    private void checkFileByMD5(@NonNull FileEntry entry, @NonNull IFileDownloadCallback callback) {
        if (ToolUtils.fileCorrect(entry.getEncryptPath(), entry.getMd5())) {
            callback.downloadFileFinish(entry);
        } else {
            Logger.getLogger().w("Download file -> MD5 check failed: file=" + entry);
            this.downloadFileAgain(entry, callback);
        }
    }

    private void downloadFileAgain(@NonNull FileEntry entry, @NonNull IFileDownloadCallback callback) {
        if (entry.isFinish()) {
            Logger.getLogger().e("Download file -> download again failed: file=" + entry);
            callback.downloadFileError(50036, entry);
        } else {
            Logger.getLogger().w("Download file -> download again: file=" + entry);
            entry.setCount(1);
            this.downloadFile(entry, false, callback);
        }
    }
}

