/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.support.annotation.NonNull;
import com.xdja.imsdk.http.okhttp.ProgressListener;
import com.xdja.imsdk.http.okhttp.body.ChunkProgressRequestBody;
import com.xdja.imsdk.logger.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class FileChunkInterceptor
implements Interceptor {
    @NonNull
    private File mFile;
    @NonNull
    private ProgressListener mProgressListener;
    private int mChunk;

    public FileChunkInterceptor(@NonNull File file, @NonNull ProgressListener callback) {
        this.mFile = file;
        this.mProgressListener = callback;
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request;
        Response response = null;
        this.mChunk = 0;
        while (this.mFile.length() - (long)(this.mChunk * 0x500000) > 0L && (response = chain.proceed(request = chain.request().newBuilder().post(this.createRequestBody()).build())).isSuccessful()) {
            ++this.mChunk;
        }
        if (response == null) {
            FileNotFoundException exception = new FileNotFoundException(this.mFile + " does not exist or length is 0");
            Logger.getLogger().e("Upload file error: " + exception);
            throw exception;
        }
        return response;
    }

    @NonNull
    public RequestBody createRequestBody() {
        return new ChunkProgressRequestBody(this.mFile, this.mChunk, this.mProgressListener);
    }
}

