/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import com.xdja.imsdk.logger.Logger;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class LoggingInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        long t1 = System.currentTimeMillis();
        Request request = chain.request();
        Logger.getLogger().d("Sending request: url=" + request.url() + ", headers=" + request.headers());
        Response response = null;
        response = chain.proceed(request);
        long t2 = System.currentTimeMillis();
        if (response != null) {
            Logger.getLogger().d("Received response: url=" + request.url() + ", code=" + response.code() + ", headers=" + response.headers() + ", time=" + (t2 - t1) + "ms");
        } else {
            Logger.getLogger().e("Received response: url=" + request.url() + ", response is null, time=" + (t2 - t1) + "ms");
        }
        return response;
    }
}

