/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp.interceptor;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xdja.imsdk.logger.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.json.JSONException;
import org.json.JSONObject;

public final class NetworkStateInterceptor
implements Interceptor {
    @NonNull
    private Callback mCallback;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public NetworkStateInterceptor(@NonNull Callback callback) {
        this.mCallback = callback;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        block15: {
            try {
                response = chain.proceed(chain.request());
                if (response != null && response.isSuccessful()) {
                    this.mCallback.onState(40000);
                    break block15;
                }
                if (response != null) {
                    ResponseBody responseBody = response.body();
                    long contentLength = responseBody.contentLength();
                    if (this.bodyEncoded(response.headers())) break block15;
                    BufferedSource source = responseBody.source();
                    source.request(Long.MAX_VALUE);
                    Buffer buffer = source.buffer();
                    Charset charset = UTF8;
                    MediaType contentType = responseBody.contentType();
                    if (contentType != null) {
                        try {
                            charset = contentType.charset(UTF8);
                        }
                        catch (UnsupportedCharsetException e) {
                            Logger.getLogger().e("NetworkStateInterceptor response fail ");
                            this.mCallback.onState(40004);
                            return response;
                        }
                    }
                    if (!NetworkStateInterceptor.isPlaintext(buffer)) {
                        Logger.getLogger().e("NetworkStateInterceptor response fail ");
                        this.mCallback.onState(40004);
                        return response;
                    }
                    if (contentLength != 0L) {
                        String result = buffer.clone().readString(charset);
                        Logger.getLogger().e("NetworkStateInterceptor response.url():" + response.request().url());
                        Logger.getLogger().e("NetworkStateInterceptor response.body():" + result);
                        if (this.networkOk(result)) {
                            Logger.getLogger().e("NetworkStateInterceptor response business fail " + result);
                            this.mCallback.onState(40000);
                        } else {
                            Logger.getLogger().e("NetworkStateInterceptor response fail " + result);
                            this.mCallback.onState(40004);
                        }
                    } else {
                        Logger.getLogger().e("NetworkStateInterceptor response fail ");
                        this.mCallback.onState(40004);
                    }
                    break block15;
                }
                Logger.getLogger().e("NetworkStateInterceptor response is null");
                this.mCallback.onState(40004);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (e instanceof SocketTimeoutException) {
                    this.mCallback.onState(40007);
                } else if (e instanceof UnknownHostException) {
                    this.mCallback.onState(40004);
                }
                throw e;
            }
        }
        return response;
    }

    private boolean networkOk(String responseStr) {
        try {
            JSONObject errorJsonObject = new JSONObject(responseStr);
            String errorCode = errorJsonObject.optString("code");
            if (TextUtils.isEmpty((CharSequence)errorCode)) {
                errorCode = errorJsonObject.optString("errCode");
            }
            if ("703".equals(errorCode) || "0x9008".equals(errorCode) || "504".equals(errorCode)) {
                return true;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity");
    }

    static boolean isPlaintext(Buffer buffer) throws EOFException {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public static interface Callback {
        public void onState(int var1);
    }
}

