/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.logger;

import android.util.Log;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.util.ToolUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static final String TAG = "XdjaImSdkLog";

    private Logger() {
    }

    public static Logger getLogger() {
        return Factory.INSTANCE;
    }

    public void v(Object str) {
        this.log(2, str, null);
    }

    public void d(Object str) {
        this.log(3, str, null);
    }

    public void i(Object str) {
        this.log(4, str, null);
    }

    public void w(Object str) {
        this.log(5, str, null);
    }

    public void w(Object str, Throwable tr) {
        this.log(5, str, null);
    }

    public void e(Object str) {
        this.log(6, str, null);
    }

    public void e(Object str, Throwable tr) {
        this.log(6, str, tr);
    }

    private void log(int priority, Object msg, Throwable throwable) {
        if (msg == null) {
            msg = " -- NULL EXCEPTION -- ";
        }
        if (ImSdkCallbackManager.getInstance().canLog()) {
            ImSdkCallbackManager.getInstance().callbackLog(priority, TAG, msg.toString(), throwable);
            return;
        }
        switch (priority) {
            case 2: {
                Log.v((String)TAG, (String)this.getFunctionName(msg));
                break;
            }
            case 3: {
                Log.d((String)TAG, (String)this.getFunctionName(msg));
                break;
            }
            case 4: {
                Log.i((String)TAG, (String)this.getFunctionName(msg));
                break;
            }
            case 5: {
                Log.w((String)TAG, (String)this.getFunctionName(msg));
                break;
            }
            case 6: {
                Log.e((String)TAG, (String)this.getFunctionName(msg));
            }
        }
    }

    private String getFunctionName(Object str) {
        StackTraceElement[] sts = Thread.currentThread().getStackTrace();
        if (sts == null) {
            return null;
        }
        for (StackTraceElement st : sts) {
            if (st.isNativeMethod() || st.getClassName().equals(Thread.class.getName()) || st.getClassName().equals(this.getClass().getName())) continue;
            Thread t = Thread.currentThread();
            long id = t.getId();
            String name = t.getName();
            return "[(" + id + ", " + name + "): " + st.getFileName() + ":" + st.getLineNumber() + " " + st.getMethodName() + "] - " + str.toString();
        }
        return null;
    }

    public String formatTime(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return dateFormat.format(new Date(time));
    }

    public String formatPositive(String content) {
        if (ToolUtils.isEmpty(content)) {
            return "";
        }
        if (content.length() < 10) {
            return content;
        }
        return content.substring(0, 10) + "...";
    }

    public String formatReverse(String content) {
        if (ToolUtils.isEmpty(content)) {
            return "";
        }
        if (content.length() < 10) {
            return content;
        }
        return content.substring(content.length() - 10, content.length()) + "...";
    }

    private static class Factory {
        private static final Logger INSTANCE = new Logger();

        private Factory() {
        }
    }
}

