package com.xdja.im.common.cache.impl;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.xdja.im.common.cache.entity.DeviceEntity;
import com.xdja.im.common.cache.entity.ServerEntity;
import com.xdja.im.common.cache.interf.ConfigCache;
import com.xdja.im.common.persistent.PropertyUtil;
import com.xdja.im.lib.filemanage.util.TextUtil;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

/**
 * @Package:com.xdja.im.common.cache
 * @Author:Lei
 * @Creation:2017-04-11 22:15
 * @Version 1.0
 * @Description:配置信息缓存实现
 */
public class ConfigCacheImpl implements ConfigCache {

    public static final String PRONAME = "im_uikit_config.conf";

    public static final String DEVICE_TYPE = "deviceType";
    public static final String PLATFORM_TYPE = "platformType";
    public static final String EXT_TYPE = "extType";
    public static final String HASAT = "hasAt";
    public static final String FILESIZE = "fileSize";
    public static final String FACESIZE = "faceSize";
    public static final String SESSIONFACESIZE = "sessionFaceSize";
    public static final String SERVER_IM_URL = "imUrl";
    public static final String SERVER_MX_URL = "mxUrl";
    public static final String SERVER_USER_ID = "userid";
    public static final String SERVER_USER_SECRET = "usersecret";
    public static final String SERVER_FASTDFS_ADDR = "fastDfsAddr";
    public static final String SERVER_FASTDFS_PORT = "fastDfsPort";

    public static final int DEFAULT_DEVICE_TYPE = 1; //默认设备类型：phone
    public static final int DEFAULT_PLATFORM_TYPE = 0; //默认平台类型：通用
    public static final int DEFAULT_EXT_TYPE = 0; //默认类型：OA
    public static final int DEFAULT_HASFORWARD = 0; //默认类型：需要
    public static final int DEFAULT_FILESIZE = 100; //文件大小
    public static final double DEFAULT_FACESIZE = 1.1; //表情大小
    public static final double DEFAULT_SESSIONFACESIZE = 0.8; //表情大小
    private Map<String, String> configEntity;

    private DeviceEntity deviceEntity;

    private ServerEntity serverEntity;

    private PropertyUtil propertyUtil;

    @Inject
    public ConfigCacheImpl(PropertyUtil propertyUtil) {
        this.propertyUtil = propertyUtil;
        if (configEntity == null || configEntity.isEmpty()) {
            configEntity = this.get();
        }
        deviceEntity = new DeviceEntity();
        int deviceId = DEFAULT_DEVICE_TYPE;
        int platform = DEFAULT_PLATFORM_TYPE;
        int extType = DEFAULT_EXT_TYPE;
        int hasAt = DEFAULT_HASFORWARD;
        int fileSize = DEFAULT_FILESIZE;
        double faceSize = DEFAULT_FACESIZE;
        double sessionFaceSize = DEFAULT_SESSIONFACESIZE;
        try {
            deviceId = TextUtils.isEmpty(configEntity.get(DEVICE_TYPE)) ? 1 :
                    Integer.valueOf(configEntity.get(DEVICE_TYPE));
            platform = TextUtils.isEmpty(configEntity.get(PLATFORM_TYPE)) ? 0 :
                    Integer.valueOf(configEntity.get(PLATFORM_TYPE));
            extType = TextUtils.isEmpty(configEntity.get(EXT_TYPE)) ? 0 :
                    Integer.valueOf(configEntity.get(EXT_TYPE));
            hasAt = TextUtils.isEmpty(configEntity.get(HASAT)) ? 0 :
                    Integer.valueOf(configEntity.get(HASAT));
            fileSize = TextUtils.isEmpty(configEntity.get(FILESIZE)) ? 100 : Integer.valueOf(configEntity.get(FILESIZE));
            faceSize = TextUtils.isEmpty(configEntity.get(FACESIZE)) ? 1.1 : Double.valueOf(configEntity.get(FACESIZE));
            sessionFaceSize = TextUtils.isEmpty(configEntity.get(FACESIZE)) ? 0.8 : Double.valueOf(configEntity.get(SESSIONFACESIZE));
        } catch (Exception e) {
            e.printStackTrace();
        }
        deviceEntity.setDeviceType(deviceId);
        deviceEntity.setPlatformType(platform);
        deviceEntity.setExtType(extType);
        deviceEntity.setHasAt(hasAt);
        deviceEntity.setFileSize(fileSize);
        deviceEntity.setFaceSize(faceSize);
        deviceEntity.setSessionFaceSize(sessionFaceSize);
        serverEntity = new ServerEntity();
        serverEntity.setImUrl(configEntity.get(SERVER_IM_URL));
        serverEntity.setMxUrl(configEntity.get(SERVER_MX_URL));
//        serverEntity.setUserId(configEntity.get(SERVER_USER_ID));
//        serverEntity.setUserSecret(configEntity.get(SERVER_USER_SECRET));
//        ServerAddr serverAddr = new ServerAddr(
//                configEntity.get(SERVER_FASTDFS_ADDR),
//                configEntity.get(SERVER_FASTDFS_PORT)
//        );
//        serverEntity.setFastDfsUrl(serverAddr);
    }

    @Nullable
    @Override
    public Map<String, String> get() {
        configEntity = new HashMap<>();
        this.propertyUtil.load(PRONAME);
        this.configEntity = this.propertyUtil.getAll();
        return configEntity;
    }

    @Override
    public DeviceEntity getDevice() {
        return deviceEntity;
    }

    @Override
    public ServerEntity getServer() {
        return serverEntity;
    }
}
