package com.xdja.im.core.model.account;

import java.io.Serializable;

/**
 * @Package: com.xdja.im.core.model.account
 * @Author: xdjaxa
 * @Creation: 2017-08-10 9:26
 * @Version V1.0
 * @Description:联系人描述信息
 */
public class AccountDesc implements Serializable {

    /**
     * 联系人类型，标识为群组或者个人
     */
    private AccountType type;
    /**
     * 成员个数，如果为群成员，则为群组人数
     */
    private int memberNum;
    /**
     * 描述信息
     */
    private String desc;

    public AccountType getType() {
        return type;
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    public int getMemberNum() {
        return memberNum;
    }

    public void setMemberNum(int memberNum) {
        this.memberNum = memberNum;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String toString() {
        return "AccountDesc{" +
                "type=" + type +
                ", memberNum=" + memberNum +
                ", desc='" + desc + '\'' +
                '}';
    }
}
