package com.xdja.im.core.model.event;

import com.xdja.im.core.model.account.AccountBean;

import java.util.List;

/**
 * @Package: com.xdja.im.core.model.event
 * @Author: xdjaxa
 * @Creation: 2017-08-22 16:39
 * @Version V1.0
 * @Description:
 */
public class IMContactEvent {

    public static class ContactEvent {

        private String account; //如果是联系人，则为账号；如果为群组，则为群ID

        public String getAccount() {
            return account;
        }

        public void setAccount(String account) {
            this.account = account;
        }
    }

    public static class GroupMemberEvent extends ContactEvent {

        /**
         * 操作类型：添加或删除群成员
         */
        private int type;
        /**
         * 群组联系人列表
         */
        private List<AccountBean> accountList;

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public List<AccountBean> getAccountList() {
            return accountList;
        }

        public void setAccountList(List<AccountBean> accountList) {
            this.accountList = accountList;
        }
    }

    /**
     * 创建群组事件
     */
    public static class CreateGroupEvent extends ContactEvent {

    }

    /**
     * 更新群组事件
     */
    public static class RefreshGroupEvent extends ContactEvent {

    }

    /**
     * 解散群组事件
     */
    public static class DissolutionGroupEvent extends ContactEvent {

    }

    public static class AtGroupEvent extends ContactEvent{

        private String account;

        private String groupId;

        @Override
        public String getAccount() {
            return account;
        }

        @Override
        public void setAccount(String account) {
            this.account = account;
        }

        public String getGroupId() {
            return groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }
    }
}
