package com.xdja.im.core.proxy;

import android.content.Context;
import android.support.annotation.NonNull;

import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.CommonCallback;
import com.xdja.im.core.callback.CustomComponentCallBack;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.NotificationChannelCallback;
import com.xdja.im.core.callback.OnAudioRecordCallback;
import com.xdja.im.core.callback.OnChatAt2GroupCallBack;
import com.xdja.im.core.callback.OnChatMeetCallBack;
import com.xdja.im.core.callback.OnChatSettingCallback;
import com.xdja.im.core.callback.OnChatUserInfoCallback;
import com.xdja.im.core.callback.OnImInitStateCallback;
import com.xdja.im.core.callback.OnOpenChatPageCallback;
import com.xdja.im.core.callback.OnShareOverCallback;
import com.xdja.im.core.callback.OnUserCanAccessToOptionCallBack;
import com.xdja.im.core.callback.SessionDeleteCallBack;
import com.xdja.im.core.callback.ShareSelectCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.callback.UpDateSessionConfigCallback;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.lib.action.bean.OptionBean;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.core.proxy
 * @Author: xdjaxa
 * @Creation: 2017-06-26 8:48
 * @Version V1.0
 * @Description:Ui Kit对外提供的接口
 */
public interface IMUiKitProxy {

    void setNotificationChannelCallback(NotificationChannelCallback callback);
    /**
     * 获取联系人账号接口
     *
     * @param callback
     */
    void setAccountCallback(AccountCallback callback);

    /**
     * 通知栏消息回调
     *
     * @param callback
     */
    void setNotificationCallback(NotificationCallback callback);

    /**
     * 未读消息数回调
     *
     * @param callback
     */
    void setUnReadMessageCallback(UnReadMessageCallback callback);
    /**
     * 通用回调接口
     *
     * @param callback
     */
    void setCommonCallback(CommonCallback callback);


    /**
     * 启动聊天设置界面回调
     *
     * @param callback
     */
    void setOpenChatSettingCallback(OnChatSettingCallback callback);
    /**
     * 打开用户信息界面
     *
     * @param callback
     */
    void setOpenChatUserInfoCallback(OnChatUserInfoCallback callback);

    /**
     * 打开聊天页面回调
     * 用于传参控制底部菜单显隐
     * @param callback
     */
    void setOnOpenChatPageCallback(OnOpenChatPageCallback callback);

    /**
     * 用户加入会议回掉
     *
     * @param callback
     */
    void setOnChatMeetCallBack(OnChatMeetCallBack callback);

    /**
     * 分享操作回掉
     *
     * @param callback
     */
    void setShareSelectCallback(ShareSelectCallback callback);

    /**
     * 注册回调录音按钮监听
     *
     * @param callback
     */
    void setOnAudioRecordCallback(OnAudioRecordCallback callback);

    /**
     * 分享完成操作回掉
     */
    void registerOnShareOverCallback(OnShareOverCallback callback);

    /**
     * 界面更新操作
     *
     */
    void setUpDateSessionConfig(UpDateSessionConfigCallback upDateSessionConfig);
    /**
     * 根据联系人账号，获取联系信息
     *
     * @param account 联系人账号
     * @param type    联系人类型
     * @return 联系人信息
     */
    void getAccount(String account, int type, Subscriber<AccountBean> subscriber);

    /**
     * 获取账号信息
     * @param account
     * @param type
     * @return
     */
    AccountBean getAccount(String account, int type);
    /**
     * 联系人状态变化通知事件
     *
     * @param account 联系人账号
     * @param action  {@link AccountAction}
     */
    void notifyAccountChanged(String account, AccountAction action);

    /**
     * 通知信息
     *
     * @param sessionBean
     * @param newMsgCnt
     * @param isDisturb
     * @return
     */
    boolean notify(TalkSessionBean sessionBean, int newMsgCnt, boolean isDisturb);

    /**
     * 更新未读消息数
     *
     * @param count 未读消息数
     */
    void updateUnReadMessageCount(int count);

    /**
     * 打开会话设置界面
     *
     * @param sessionId
     * @param sessionType
     */
    boolean openChatSettingCallback(String sessionId, int sessionType);
    /**
     * 打开用户信息界面
     *
     * @param account
     */
    boolean openChatUserInfoCallback(String account);
    /***
     *当前账号是否在群组中
     * */
    public boolean isShowGroupSetting(String groupId);

    /**
     * 启动位置界面
     * */
    void startLocation(String atNo);

    /**
     * 启动视频回传
     * */
    void startCallback(String atNo);
    void startCallback(String atNo,int type);
    /**
     * 启动语音
     * */
    void startVoice(String atNo , int type);

    void addMeetting(String account,String groupId);


    void callSessionContact(Context context,int type,String action);

    void callSessionSearch(Context context,String key,int type,String action);

    /**
     * 群成员设置回调
     */
    void setAt2GroupMembersCallback(OnChatAt2GroupCallBack callBack);

    void clearSessionCache();
    /**
     * 跳转群成员界面
     * @param groupId
     */
    void go2AtGroupMembersList(String groupId,String account);

    void shareOverCallback(Context context);

    void notifyGroupMembsItemClick(String mGroupId, String account, String nickName);

    void upDateConfigUi(@NonNull String type, @NonNull boolean setting, @NonNull String talkFlag);

    void setCustomComponentCallBack(CustomComponentCallBack callBack);

    /**
     * 自定义组件回调
     * @param talkId
     * @param talkType
     * @param optionBean
     */
    void onCustomComponentCallBack(Context context,String talkId, int talkType, OptionBean optionBean);

    /**
     * 自定义消息在会话列表展示内容回调
     * @param isMine 是否时自己发送的消息
     * @param jsonContent 三方自定义，如果不做处理，则显示默认数据（jsonContent携带数据）
     * @return
     */
    String onCustomMsgSessionShowTip(boolean isMine,String jsonContent);

    /**
     * 注册删除会话回调
     * @param sessionDeleteCallBack
     */
    void setSessionDeleteCallBack(SessionDeleteCallBack sessionDeleteCallBack);

    /**
     * 删除会话回调
     * @param sessionBean
     */
    void onSessionDelete(TalkSessionBean sessionBean);


    void cancelNotification(String anto, int type);

    /**
     * 用户是否可以进入底部菜单
     * @param onUserCanAccessToOptionCallBack 回调接口
     */
    void setUserAccessToOption(OnUserCanAccessToOptionCallBack onUserCanAccessToOptionCallBack);

    boolean isAccessToOption(OptionBean optionBean);

    void setOnImInitStateCallback(OnImInitStateCallback callback);

    void onInitFinished();

    void onInitFailed();

    int[] getCancelBottomMenuId(String sessionId, int sessionType);

    String getChannelId();


    /**
     * 获取当前音频状态，是否被占用
     * @return
     */
    boolean audioIsWorking();

}
