package com.xdja.im.core.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyUpdateSession;
import com.xdja.im.core.push.bean.MxPushBean;
import com.xdja.im.uikit.utils.log.LogUtil;

public class PushReceiver extends BroadcastReceiver {

    /**
     * action
     */
    public static final String ACTION = "com.xdja.apushsdk";

    /**
     * key c
     */
    public static final String CONTENT = "c";

    /**
     * topic
     */
    public static final String TOPIC = "topic";

    public static final String TOPIC_MX = "/mxs";

    @Override
    public void onReceive(Context context, Intent intent) {
        LogUtil.d("get session setting receiver");
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if (TextUtils.isEmpty(action) || !action.equals(ACTION)) {
            return;
        }
        String topic = intent.getStringExtra(TOPIC);
        int index = topic.lastIndexOf("/");
        if (index == -1) {
            return;
        }
        topic = topic.substring(index);

        if (!TextUtils.isEmpty(topic)) {
            String con = intent.getStringExtra(CONTENT);
            if (TextUtils.isEmpty(con)) {
                return;
            }

            //当主题为mxs时发送时间通知界面刷新
            if (topic.equals(TOPIC_MX)) {
                MxPushBean pushBean = new Gson().fromJson(con, MxPushBean.class);
                if (!TextUtils.isEmpty(pushBean.getMessage())) {
                    IMProxyUpdateSession.UpDateConfigInformation event = new IMProxyUpdateSession.UpDateConfigInformation();
                    event.setContent(pushBean);
                    BusProvider.getInstance().post(event);
                }
            }
        }
    }
}


