package com.xdja.im.core.repository.interf;

import java.util.Map;

/**
 * @Package: com.xdja.im.core.repository.interf
 * @Author: xdjaxa
 * @Creation: 2017-04-11 11:09
 * @Version V1.0
 * @Description:加解密模块接口定义
 */
public interface SecurityRepository {

    /**
     * 文本加密
     *
     * @param source  加密的文本
     * @param to      接收方
     * @param isGroup 是否群组
     * @return 加密后的文本
     */
    Map<String, Object> encryptText(String source, String to, boolean isGroup);

    /**
     * 文件加密
     *
     * @param source  加密的文件路径
     * @param dest    加密后的文件路径
     * @param to      接收方
     * @param isGroup 是否群组
     * @return 加密后的文件路径
     */
    Map<String, Object> encryptAsync(String source, String dest, String to, boolean isGroup);

    /**
     * 文本解密
     *
     * @param source  解密前的文本
     * @param to      接收方
     * @param isGroup 是否群组
     * @return 解密后的文本
     */
    Map<String, Object> decryptText(String source, long msgId, String from, String to, boolean isGroup);

    /**
     * 文件解密
     *
     * @param source  解密前的文件路径
     * @param dest    解密后的文件路径
     * @param to      接收方
     * @param isGroup 是否群组
     * @return 解密后的文件路径
     */
    Map<String, Object> decryptAsync(String source, String dest, String to, boolean isGroup);
}
