package com.xdja.im.lib.audio.manager;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Chronometer;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.uikit.R;


/**
 * 用于管理Dialog
 * 
 * @author cxp
 * 
 */
public class DialogManager {

	private ImageView mIcon;
	private ImageView mVoice;
	public TextView mLabel;
	public Chronometer mVoiceChronometer;

	private final Context mContext;

	private Dialog dialog;// 替换AlertDialog解决背景阴影的问题

	/**
	 * 构造方法 传入上下文
	 */
	public DialogManager(Context context) {
		this.mContext = context;
	}

	// 显示录音的对话框
	public void showRecordingDialog() {
		if (dialog == null) {
			dialog = new Dialog(mContext, R.style.im_uikit_AudioDialog);
		}

		dialog.setCancelable(false);//设置点击其他区域不消失
		LayoutInflater inflater = LayoutInflater.from(mContext);
		View view = inflater.inflate(R.layout.im_uikit_recorder_dialog, null);

		mIcon = (ImageView) view.findViewById(R.id.id_recorder_dialog_icon);
		mVoice = (ImageView) view.findViewById(R.id.id_recorder_dialog_voice);
		mLabel = (TextView) view.findViewById(R.id.id_recorder_dialog_label);
		mVoiceChronometer = (Chronometer)view.findViewById(R.id.id_recorder_Chronometer);
		
		dialog.setContentView(view);
		dialog.show();
	}

	public void recording() {
		if (dialog != null && dialog.isShowing()) { // 显示状态
			mIcon.setVisibility(View.VISIBLE);
			mVoice.setVisibility(View.VISIBLE);
			mLabel.setVisibility(View.VISIBLE);

			mIcon.setImageResource(R.mipmap.im_uikit_ic_message_vioce);
			mLabel.setText(R.string.im_uikit_slide_to_cancel);
		}
	}

	// 显示想取消的对话框
	public void wantToCancel() {
		if (dialog != null && dialog.isShowing()) { // 显示状态
			mIcon.setVisibility(View.VISIBLE);
			mVoice.setVisibility(View.GONE);
			mLabel.setVisibility(View.VISIBLE);

			mIcon.setImageResource(R.mipmap.im_uikit_ic_message_cancel);
			mLabel.setText(R.string.im_uikit_cancel_send);
		}
	}

	//最后十秒显示
	public void lastTenSeconds(String str) {
		if (dialog != null && dialog.isShowing()) { // 显示状态
			mIcon.setVisibility(View.GONE);
			mVoice.setVisibility(View.GONE);
			mLabel.setVisibility(View.VISIBLE);

			mLabel.setText(str);
		}
	}
	
	// 显示时间过短的对话框
	public void tooShort() {
		if (dialog != null && dialog.isShowing()) { // 显示状态
			mIcon.setVisibility(View.VISIBLE);
			mVoice.setVisibility(View.GONE);
			mLabel.setVisibility(View.VISIBLE);

			mIcon.setImageResource(R.mipmap.im_uikit_recording_voice_too_short);
			mLabel.setText(R.string.im_uikit_record_too_short);
		}
	}

	// 显示时间过短的Toast提示
	public void tooShort(Context context) {
		if (dialog != null) {
			CommonTool.showToast(R.string.im_uikit_record_too_short);
		}
	}

    public void tooShortToShow(Context context){
		CommonTool.showToast(R.string.im_uikit_record_too_short);
    }

	public void getAudioDeviceErrToShow(Context context) {
		CommonTool.showToast(R.string.im_uikit_obtion_audio_device_err);
	}
	
	public void getAudioPermissionErrToShow(Context context) {
		CommonTool.showToast(R.string.im_uikit_gaint_audio_permission_err);
	}

	// 显示取消的对话框
	public void dismissDialog() {
		if (dialog != null && dialog.isShowing()) { // 显示状态
			dialog.dismiss();
			dialog = null;
		}
	}

	// 显示更新音量级别的对话框
	public void updateVoiceLevel(int level) {
		if (dialog != null && dialog.isShowing()) { // 显示状态

			// 设置图片的id
			int resId = mContext.getResources().getIdentifier("im_uikit_v" + level,
					"mipmap", mContext.getPackageName());
			mVoice.setImageResource(resId);
		}
	}

	public boolean isShowing(){
		return dialog != null && dialog.isShowing();
	}
}
