package com.xdja.im.lib.camera;

import android.support.annotation.IntDef;

import com.xdja.im.uikit.ImUiKit;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package: com.xdja.im.lib.camera
 * @Author: xdjaxa
 * @Creation: 2017-04-25 21:00
 * @Version V1.0
 * @Description:
 */
public class CameraConfig {

    /**
     * 拍照图片是否可编辑，默认不可编辑
     */
    private boolean isCanEdit = false;

    /**
     * 裁剪后的图片是否是矩形，否者跟随裁剪框的形状
     */
    private boolean isSaveRectangle = false;
    /**
     * 裁剪保存宽度
     */
    private int outPutX = 800;
    /**
     * 裁剪保存高度
     */
    private int outPutY = 800;
    /**
     * 焦点框的宽度
     */
    private int focusWidth = 280;
    /**
     * 焦点框的高度
     */
    private int focusHeight = 280;

    /**
     *  ImSdk生成的缩略图的文件前缀名
     */
    public static final String THUMBNAIL_FILE_PREFIX = "th_";

    /**
     *  ImSdk生成的缩略图的文件后缀名
     */
    public static final String THUMBNAIL_FILE_SUFFIX = ".jpeg";

    /**
     * 图片缩略图缓存信息（就目前项目，路径必填）
     */
    private String cachePath;

    /**
     * 是否需要生成缩略图信息，默认生成缩略图
     */
    private boolean bNeedCreateThumb = true;

    /**
     * 最多选择张图片个数，默认9张
     */
    public static final int MAX_SELECT_NUM = 9;

    /**
     * 最大可选择发送文件大小，默认30M
     */
    public static final long MAX_SELECT_SIZE = ImUiKit.getInstance().getComponent().configCache().getDevice().getFileSize() * 1024 * 1024;

    /**
     * 图片类型
     */
    public static final int TYPE_IMAGE = 0x00;

    /**
     * 支持相机和图片
     */
    public static final int TYPE_WITH_CAMERA = 0x02;

    /**
     * 支持相机、图片、视频
     */
    public static final int TYPE_ALL = 0x01;

    @IntDef({TYPE_IMAGE, TYPE_WITH_CAMERA, TYPE_ALL})
    @Retention(RetentionPolicy.SOURCE)
    @interface TYPE {
    }

    /**
     * 图片大小限制
     */
    private long maxSize = MAX_SELECT_SIZE;

    public String getCachePath() {
        return cachePath;
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
    }

    public boolean isbNeedCreateThumb() {
        return bNeedCreateThumb;
    }

    public void setbNeedCreateThumb(boolean bNeedCreateThumb) {
        this.bNeedCreateThumb = bNeedCreateThumb;
    }
}
