package com.xdja.im.lib.file.widget.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;

public class ViewHolder extends RecyclerView.ViewHolder {

    private SparseArray<View> views;
    private View convertView;
    private Context context;

    public ViewHolder(Context context,View itemView) {
        super(itemView);

        this.context = context;
        convertView = itemView;
        views = new SparseArray<>();
    }

    public static ViewHolder createViewHolder(Context context, ViewGroup parent, int layoutId){
        View view = LayoutInflater.from(context).inflate(layoutId, parent, false);
        ViewHolder holder = new ViewHolder(context, view);
        return holder;
    }

    public <T extends View> T getView(int viewId){
        View view = views.get(viewId);
        if(view == null){
            view = convertView.findViewById(viewId);
            views.put(viewId,view);
        }

        return (T)view;
    }

    public View getConvertView(){
        return convertView;
    }

    public void setText(int tvId,String text){
        View tv = getView(tvId);
        if(tv instanceof TextView){
            ((TextView)tv).setText(text);
        }
    }

    public void setText(int tvId,int textId) {
        View tv = getView(tvId);
        if(tv instanceof TextView){
            ((TextView)tv).setText(textId);
        }
    }

    public void setImageWithResource(int ivId, int resourceId){
        View view = getView(ivId);
        if(view instanceof ImageView){
            ((ImageView)view).setImageResource(resourceId);
        }
    }

    public void setImageWithPath(int ivId, String path, int errorId){
        View view = getView(ivId);
        if(view instanceof ImageView){
            ImageView img = (ImageView)view;
            Glide.with(context)
                    .load(path)
                    .error(errorId)//R.mipmap.pic_default)
                    .centerCrop()
                    .override(360, 360)
                    .into(img);
        }
    }

    public void setChecked(int checkId, boolean isCheck){
        View view = getView(checkId);
        if(view instanceof CheckBox){
            ((CheckBox)view).setChecked(isCheck);
        }
    }
}
