package com.xdja.im.lib.filemanage.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.cache.interf.UserCache;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.filemanage.adapter.LastFileListAdapterPresenter;
import com.xdja.im.lib.filemanage.commend.ILastFileListCommand;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.presenter.IMFragmentPresenter;
import com.xdja.im.lib.filemanage.view.ILastFileListFragmentVu;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Created by xdjaxa on 2017/2/28.
 */
public class LastFileListFragment extends IMFragmentPresenter<ILastFileListCommand, ILastFileListFragmentVu>
        implements ILastFileListCommand {

    //事件总线
    BusProvider busProvider;

    private UserCache userCache;

    private LastFileListAdapterPresenter mAdapter;

    private Map<HistoryFileCategory, List<TalkMessageBean>> mDataMaps = new HashMap<>();

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);

        if (null == useCaseComponent) {
            LogUtil.e("LastFileListFragment", "useCaseComponent is null");
            return;
        }

        //初始化注入
        useCaseComponent.inject(this);

        //初始化事件总线
        busProvider = BusProvider.getInstance();
        busProvider.register(this);
//        userCache = useCaseComponent.userCache();

        mAdapter = new LastFileListAdapterPresenter(getActivity(), busProvider, userCache, mDataMaps);

//        useCaseComponent.inject(mAdapter);
        mAdapter.setActivity(getActivity());
        mAdapter.setListView(getVu().getListView());
        getVu().getListView().setAdapter(mAdapter);
    }

    public void notifyDataChange(Map<HistoryFileCategory, List<TalkMessageBean>> datas){
        getVu().showEmpty(datas.size() == 0);
        mDataMaps = datas;
        mAdapter.setDataSource(mDataMaps);
        mAdapter.notifyDataSetChanged();
    }

    @NonNull
    @Override
    protected Class<? extends ILastFileListFragmentVu> getVuClass() {
        return ViewLastFileListFragment.class;
    }

    @NonNull
    @Override
    protected ILastFileListCommand getCommand() {
        return this;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (null != busProvider) {
            //注销事件总线回调
            busProvider.unregister(this);
        }
        if (null != mAdapter) {
            mAdapter.onDestroy();
        }
    }
}
