package com.xdja.im.lib.filemanage.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;

import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.lib.filemanage.adapter.LastFilePageAdapter;
import com.xdja.im.lib.filemanage.commend.ILastFileListVu;
import com.xdja.im.lib.filemanage.commend.ILastFilePageCommand;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.presenter.IMFragmentPresenter;
import com.xdja.im.lib.filemanage.view.ViewLastFileList;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import rx.Subscriber;


/**
 * <p>Author: xdjaxa         </br>
 * <p>Date: 2016/12/2 16:53   </br>
 * <p>Package: com.xdja.imp.presenter.fragment</br>
 * <p>Description: 文件列表显示fragment          </br>
 */
public class LastFilePagePresenter extends IMFragmentPresenter<ILastFilePageCommand, ILastFileListVu>
        implements ILastFilePageCommand {

    private final int[] FILE_TYPE = new int[]{
            ConstDef.FILE_TYPE_VIDEO_AND_PHOTO, //视频和图片
            ConstDef.FILE_TYPE_TXT,             //文档
            ConstDef.FILE_TYPE_NORMAL           //其他
    };

    /** 最多可选择文件个数*/
    private static final int MAX_SELECT_COUNT = 9;
    private LastFileListFragment  lastOtherFragment;
    private LastFileListFragment  lastDocumentFragment;
    private LastPhotoAndVideoFragment lastPhotoAndVideoFragment;

    private Map<HistoryFileCategory, List<TalkMessageBean>> mPhotoAndVideoDatas = new HashMap<>();
    private Map<HistoryFileCategory, List<TalkMessageBean>> mDocumentDatas = new HashMap<>();
    private Map<HistoryFileCategory, List<TalkMessageBean>> mOtherDatas = new HashMap<>();

    BusProvider busProvider;

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == useCaseComponent) {
            LogUtil.e("LastFilePagePresenter", "useCaseComponent is null");
            return;
        }
        useCaseComponent.inject(this);
        busProvider = BusProvider.getInstance();
        busProvider.register(this);

        LastFilePageAdapter mAdapter = buildAdapter(getFragment());
        getVu().setFragmentAdapter(mAdapter);
    }

    @NonNull
    @Override
    protected Class<? extends ILastFileListVu> getVuClass() {
        return ViewLastFileList.class;
    }

    @NonNull
    @Override
    protected ILastFilePageCommand getCommand() {
        return this;
    }

    private LastFilePageAdapter buildAdapter(final List<Fragment> fragments){
        return new LastFilePageAdapter(getFragmentManager()) {
            @Override
            public Fragment getItem(int position) {
                return fragments.get(position);
            }

            @Override
            public int getCount() {
                return fragments.size();
            }
        };
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (busProvider != null) {
            busProvider.unregister(this);
        }
    }

    @NonNull
    private List<Fragment> getFragment() {
        List<Fragment> fragments = new ArrayList<>();
        for(int aFILE_TYPE : FILE_TYPE) {
            switch(aFILE_TYPE) {
                case ConstDef.FILE_TYPE_VIDEO_AND_PHOTO://图片
                    lastPhotoAndVideoFragment = new LastPhotoAndVideoFragment();
                    fragments.add(lastPhotoAndVideoFragment);
                    break;
                case ConstDef.FILE_TYPE_TXT:            //文档
                    lastDocumentFragment = new LastFileListFragment();
                    fragments.add(lastDocumentFragment);
                    break;
                case ConstDef.FILE_TYPE_NORMAL:         //其他
                    lastOtherFragment = new LastFileListFragment();
                    fragments.add(lastOtherFragment);
                    break;
                default:
                    break;
            }
        }
        return fragments;
    }

    //---------------------------------LastFilePagePresenter事件数据获取---------------------------------
    @Subscribe
    public void obtainDatas(IMProxyEvent.FileUpdateEvent event) {
        ImUiKit.getInstance()
                .getComponent()
                .proxyRepository().getAllHistoryFileInfoWithTalkId("", ConstDef.FILE_EXIT_ALL)
                .subscribe(new Subscriber<Map<HistoryFileCategory, List<TalkMessageBean>>>() {
                    @Override
                    public void onCompleted() {
                    }
                    @Override
                    public void onError(Throwable e) {
                    }
                    @Override
                    public void onNext(Map<HistoryFileCategory, List<TalkMessageBean>> dataMaps) {
                        for(Map.Entry<HistoryFileCategory, List<TalkMessageBean>> entry : dataMaps.entrySet()){
                            List<TalkMessageBean> talkMsgs = entry.getValue();
                            List<TalkMessageBean> filterMsgs1 = new LinkedList<TalkMessageBean>();
                            List<TalkMessageBean> filterMsgs2 = new LinkedList<TalkMessageBean>();
                            List<TalkMessageBean> filterMsgs3 = new LinkedList<TalkMessageBean>();
                            for(TalkMessageBean bean : talkMsgs){
                                FileInfo fileInfo = bean.getFileInfo();
                                int fileState;
                                if(fileInfo instanceof VideoFileInfo){
                                    fileState = ((VideoFileInfo) fileInfo).getRawFileInfo().getFileState();
                                } else if(fileInfo instanceof ImageFileInfo){
                                    if (((ImageFileInfo) fileInfo).isOriginal()) {
                                        fileState = ((ImageFileInfo) fileInfo).getRawFileInfo().getFileState();
                                    } else {
                                        fileState = fileInfo.getFileState();
                                    }
                                } else {
                                    fileState = fileInfo.getFileState();
                                }
                                if(fileState == ConstDef.INACTIVE
                                        || fileState == ConstDef.PAUSE
                                        || fileState == ConstDef.FAIL
                                        || fileState == ConstDef.LOADING
                                        || bean.getMessageState() == ConstDef.STATE_SEND_FAILED
                                        || bean.getMessageState() == ConstDef.STATE_SENDING){
                                    continue;
                                }

                                int fileType = FileUtils.getTypeWithSuffix(fileInfo.getFilePath());
                                if ((fileType == ConstDef.FILE_TYPE_NORMAL || fileType == ConstDef.FILE_NO_SUFFIX) && fileInfo.getFileType() != fileType){
                                    fileType = fileInfo.getFileType();
                                }
                                bean.getFileInfo().setFileType(fileType);
                                if(fileType == ConstDef.FILE_TYPE_PHOTO){
                                    filterMsgs1.add(bean);
                                } else if (fileType == ConstDef.FILE_TYPE_VIDEO){
                                    filterMsgs1.add(bean);
                                }else if(fileType == ConstDef.FILE_TYPE_TXT || fileType == ConstDef.FILE_TYPE_PDF ||
                                        fileType == ConstDef.FILE_TYPE_WORD || fileType == ConstDef.FILE_TYPE_PPT ||
                                        fileType == ConstDef.FILE_TYPE_EXCEL){
                                    filterMsgs2.add(bean);
                                } else {
                                    filterMsgs3.add(bean);
                                }
                            }
                            if(filterMsgs1.size() > 0) {
                                mPhotoAndVideoDatas.put(entry.getKey(), filterMsgs1);
                            }
                            if(filterMsgs2.size() > 0) {
                                mDocumentDatas.put(entry.getKey(), filterMsgs2);
                            }
                            if(filterMsgs3.size() > 0) {
                                mOtherDatas.put(entry.getKey(), filterMsgs3);
                            }
                        }
                        lastPhotoAndVideoFragment.notifyDataChange(mPhotoAndVideoDatas);
                        lastDocumentFragment.notifyDataChange(mDocumentDatas);
                        lastOtherFragment.notifyDataChange(mOtherDatas);
                    }
                });
    }
}
