package com.xdja.im.lib.filemanage.fragment;

import android.os.Bundle;
import android.support.annotation.NonNull;

import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.core.model.event.IMProxyEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.filemanage.adapter.LastPhotoAndVideoAdapter;
import com.xdja.im.lib.filemanage.commend.IPhotoAndVideoCommand;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;
import com.xdja.im.lib.filemanage.presenter.IMFragmentPresenter;
import com.xdja.im.lib.filemanage.view.IPhotoAndVideoFragmentVu;
import com.xdja.im.lib.filemanage.view.ViewPhotoAndVideo;
import com.xdja.im.uikit.utils.log.LogUtil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class LastPhotoAndVideoFragment extends IMFragmentPresenter<IPhotoAndVideoCommand, IPhotoAndVideoFragmentVu>
        implements IPhotoAndVideoCommand {

    BusProvider busProvider;

    private LastPhotoAndVideoAdapter adapter;

    private Map<HistoryFileCategory, List<TalkMessageBean>> mDatas = new HashMap<>();


    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (null == useCaseComponent) {
            LogUtil.e("LastPhotoAndVideoFragment", "useCaseComponent is null");
            return;
        }
        useCaseComponent.inject(this);
        busProvider = BusProvider.getInstance();
        busProvider.register(this);

        adapter = new LastPhotoAndVideoAdapter(busProvider, mDatas);
        adapter.setActivity(getActivity());
        adapter.setRecyclerView(getVu().getRecyclerView());
        adapter.setLayoutManager(4);
        getVu().setRecyclerViewAdapter(adapter);
        IMProxyEvent.FileUpdateEvent event = new IMProxyEvent.FileUpdateEvent();
        busProvider.post(event);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();

        if (busProvider != null) {
            busProvider.unregister(this);
        }
    }

    public void notifyDataChange(Map<HistoryFileCategory, List<TalkMessageBean>> datas){
        getVu().showEmpty(datas.size() == 0);
        mDatas = datas;
        adapter.setDataSources(datas);
        adapter.notifyDataSetChanged();

    }

    @NonNull
    @Override
    protected Class<? extends IPhotoAndVideoFragmentVu> getVuClass() {
        return ViewPhotoAndVideo.class;
    }

    @NonNull
    @Override
    protected IPhotoAndVideoCommand getCommand() {
        return this;
    }

}
