package com.xdja.im.lib.filemanage.view;

import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import com.xdja.im.lib.filemanage.adapter.BaseFileListAdapter;
import com.xdja.im.lib.filemanage.commend.IFileListCommand;
import com.xdja.im.lib.filemanage.widget.LazyLoadExpandableListView;
import com.xdja.im.uikit.R;


/**
 * <p>Author: leiliangliang   </br>
 * <p>Date: 2016/12/6 20:19   </br>
 * <p>Package: com.xdja.imp.ui</br>
 * <p>Description:            </br>
 */
public class ViewFileList extends FragmentSuperView<IFileListCommand>
        implements IFileListVu<IFileListCommand> {

    private LazyLoadExpandableListView mFileList;

    private LinearLayout mEmptyLayout;

    private ProgressBar mPbFileLoading;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_view_fragment_file_list;
    }

    @Override
    protected void injectView() {
        super.injectView();
        if (getView() != null) {
            mFileList = (LazyLoadExpandableListView) getView().findViewById(R.id.lv_file_list);
            mFileList.setGroupIndicator(getDrawableRes(R.drawable.im_uikit_item_group_indeicator_selector));
            mEmptyLayout = (LinearLayout) getView().findViewById(R.id.layout_empty);
            mPbFileLoading = (ProgressBar) getView().findViewById(R.id.pb_file_load);
        }
    }

    @Override
    public void setEmptyView() {
        mEmptyLayout.setVisibility(View.VISIBLE);
        mFileList.setEmptyView(mEmptyLayout);
        mPbFileLoading.setVisibility(View.GONE);
    }

    @Override
    public void setListAdapter(BaseFileListAdapter adapter) {
        mFileList.setAdapter(adapter);
        mPbFileLoading.setVisibility(View.GONE);
        adapter.notifyDataSetChanged();
    }

    @Override
    public LazyLoadExpandableListView getListView() {
        return mFileList;
    }
}
