package com.xdja.im.lib.historyfile.vu;

import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.filemanage.commend.IHistoryFileListAdapterCommand;
import com.xdja.im.lib.filemanage.presenter.BasePresenterActivity;
import com.xdja.im.lib.filemanage.util.DateUtils;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.lib.filemanage.util.UniversalUtil;
import com.xdja.im.lib.filemanage.util.XToast;
import com.xdja.im.lib.filemanage.view.AdapterSuperView;
import com.xdja.im.lib.filemanage.view.AdapterVu;
import com.xdja.im.lib.historyfile.util.HistoryModeUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.NetworkHelper;
import com.xdja.im.uikit.utils.log.LogUtil;

import rx.Subscriber;


/**
 * 项目名称：ActomaV2
 * 类描述：
 * 创建人：xdjaxa
 * 创建时间：2016/12/14 21:08
 * 修改人：xdjaxa
 * 修改时间：2016/12/14 21:08
 * 修改备注：
 */
public class ViewHistoryFileContent extends AdapterSuperView<IHistoryFileListAdapterCommand, TalkMessageBean>
        implements AdapterVu<IHistoryFileListAdapterCommand, TalkMessageBean> {

    private TextView mFileNameTv;

    private ImageView mFileIconIv;

    private TextView mFileSizeTv;

    private TextView mFileDateTv;

    private CheckBox mFileSelectCb;

    private TextView mFileDownloadBtn;

    private ProgressBar mFileDownloadPb;

    private LinearLayout mParentLayout;
    //add by zya ,add out of date for file and come from,20161221
    private TextView mFileOutDateTv;

    private TextView mFileFromTv;

    private LinearLayout mFileDateLayout;
    //end by zya ,20161221

    private long lastTime;

    public ViewHistoryFileContent() {
        super();
    }

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_history_filelist_item;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = getView();
        if (view != null) {
            mParentLayout = (LinearLayout) view.findViewById(R.id.history_file_content_layout);
            mFileNameTv = (TextView) view.findViewById(R.id.tv_file_title);
            mFileIconIv = (ImageView) view.findViewById(R.id.img_file_icon);
            mFileSizeTv = (TextView) view.findViewById(R.id.tv_file_desc);
            mFileDateTv = (TextView) view.findViewById(R.id.tv_file_date);
            mFileSelectCb = (CheckBox) view.findViewById(R.id.history_file_select);
            mFileDownloadBtn = (TextView) view.findViewById(R.id.history_file_op);
            mFileDownloadPb = (ProgressBar) view.findViewById(R.id.pb_file_download);
            //add by zya ,add out of date for file and come from,20161221
            mFileOutDateTv = (TextView) view.findViewById(R.id.tv_file_out_date);
            mFileFromTv = (TextView) view.findViewById(R.id.tv_file_from);
            mFileDateLayout = (LinearLayout) view.findViewById(R.id.layout_history_date_from);
            //end by zya ,20161221
        }
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        initView(position);
    }

    private void initView(final int groupPosition) {
        if (dataSource != null) {
            final FileInfo fileInfo = dataSource.getFileInfo();

            int resId = HistoryFileUtils.getIconWithSuffix(dataSource);
            mFileIconIv.setImageResource(resId);

            mFileNameTv.setText(fileInfo.getFileName());
            mFileSizeTv.setText(FileSizeUtils.FormetFileSize(fileInfo.getFileSize()));
            mFileDateTv.setText(DateUtils.displayShowTime(getActivity(), dataSource.getShowTime()));
            mFileOutDateTv.setText(String.format(getStringRes(R.string.im_uikit_history_file_outdate),
                    DateUtils.stringOfOverdue(getActivity(), dataSource.getShowTime())));

            if (HistoryFileUtils.isSendReadReceipt(dataSource)) {
                getCommand().sendReadReceipt(dataSource);
            }

            isDownload(!dataSource.hasFileOperate());
            clickBtnState(dataSource.getFileInfo().getFileState());

            mFileDownloadBtn.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    //fix bug 11490 by zya ,20170421
                    long currentTime = SystemClock.elapsedRealtime();
                    if (currentTime - lastTime < 500) {
                        return;
                    }
                    lastTime = currentTime;
                    //end by zya

                    if (!HistoryFileUtils.isFileExist(dataSource) && DateUtils.isOverdue(dataSource.getShowTime())) {
                        new XToast(getActivity()).display(getActivity().getString(R.string.im_uikit_history_select_all_overdue));
                        return;
                    }

                    FileInfo fInfo = dataSource.getFileInfo();
                    int fileState = fInfo.getFileState();

                    if (NetworkHelper.getHelper().networkUseless()) {

                        if (fileState == ConstDef.PAUSE || fileState == ConstDef.INACTIVE) {
                            Toast.makeText(getActivity(), getStringRes(R.string.im_uikit_network_disabled), Toast.LENGTH_SHORT).show();
                            return;
                        }
                    }

                    //modify by zya ,fix bug 11946 ,20170427
                    if (updateFileState(fInfo, fileState) == -1) {
                        return;
                    }
                    //end by zya

                    clickBtnState(dataSource.getFileInfo().getFileState());
                    getCommand().clickToDownloadOfOpen(dataSource);
                }
            });

            mFileSelectCb.setChecked(dataSource.isChecked());
            mFileSelectCb.setClickable(false);
            mFileSelectCb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    dataSource.setChecked(isChecked);
                    if (isChecked) {
                        HistoryModeUtils.getInstance().putFileToSelectedCache(dataSource.getId(), dataSource);
                    } else {
                        HistoryModeUtils.getInstance().removeToSelectedCache(dataSource.getId());
                    }
                    getCommand().toRefreshSelectHint();
                }
            });
            mParentLayout.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    getCommand().longClickOnItem(groupPosition, dataSource);
                    return true;
                }
            });
            mParentLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    v.setTag(R.id.history_file_select, mFileSelectCb);
                    if (!dataSource.hasFileOperate()) {
                        FileInfo fInfo = dataSource.getFileInfo();
                        int fileState = fInfo.getFileState();
                        if (updateFileState(fInfo, fileState) == -1) {
                            return;
                        }
                        clickBtnState(dataSource.getFileInfo().getFileState());
                    }
                    getCommand().onClickItem(v, groupPosition, dataSource);
                }
            });

            //add by zya 七天内的文件显示来自哪里,20161221
            setSenderName();
            //end by zya
        }
    }

    //add by zya for recall ,20170421
    private int updateFileState(FileInfo fInfo, int fileState) {
        switch (fileState) {
            case ConstDef.INACTIVE:
                if (dataSource.getMessageState() == ConstDef.STATE_RECALL_SUCCESS) {
                    //提示文件已经撤回
                    new XToast(getActivity()).display(R.string.im_uikit_history_file_recall);
                    return -1;
                } else {
                    fInfo.setFileState(ConstDef.LOADING);
                }
                break;
            case ConstDef.LOADING:
                fInfo.setFileState(ConstDef.PAUSE);
                break;
            case ConstDef.PAUSE:
                if (dataSource.getMessageState() == ConstDef.STATE_RECALL_SUCCESS) {
                    //提示文件已经撤回
                    new XToast(getActivity()).display(R.string.im_uikit_history_file_recall);
                    return -1;
                } else {
                    fInfo.setFileState(ConstDef.LOADING);
                }
                break;
            case ConstDef.FAIL:
                fInfo.setFileState(ConstDef.LOADING);
                break;

        }
        return 0;
    }//end by zya

    private void isDownload(boolean isDownload) {
        mFileSelectCb.setVisibility(isDownload ? View.GONE : View.VISIBLE);
        mFileDownloadBtn.setVisibility(isDownload ? View.VISIBLE : View.GONE);
        mFileDownloadPb.setVisibility(isDownload ? View.VISIBLE : View.GONE);
    }

    private void clickBtnState(int state) {
        Drawable btnDrawable = null;
        if (dataSource.isMine()) {
            //作为发送方
            mFileDateLayout.setVisibility(View.VISIBLE);
            mFileOutDateTv.setVisibility(View.GONE);
            mFileFromTv.setVisibility(View.VISIBLE);
            mFileDownloadPb.setVisibility(View.GONE);
            btnDrawable = getDrawableRes(UniversalUtil.getThemeStyle(getContext()) == BasePresenterActivity
                    .THEME_DARK ? R.drawable.im_uikit_history_lookup : R.drawable.im_uikit_history_lookup_light);
        } else {
            //作为接收方
            if (DateUtils.isOverdue(dataSource.getShowTime()) && !HistoryFileUtils.isFileExist(dataSource)) {
                mFileDateLayout.setVisibility(View.VISIBLE);
                mFileOutDateTv.setVisibility(View.VISIBLE);
                mFileDownloadPb.setVisibility(View.GONE);
                //if(isOpen()){
                //过期查看
                //    btnDrawable = getDrawableRes(UniversalUtil.getThemeStyle(getContext()) == BasePresenterActivity
                //            .THEME_DARK ? R.drawable.history_lookup : R.drawable.history_lookup_light);
                //} else {
                //过期未下载
                btnDrawable = getDrawableRes(UniversalUtil.getThemeStyle(getContext()) == BasePresenterActivity
                        .THEME_DARK ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
                mFileDownloadBtn.setEnabled(true);
                //}
            } else {
                LogUtil.d("", "zhu->UI Content:progress=" + dataSource.getFileInfo().getTranslatePercent()
                        + ",state=" + state);
                mFileDownloadBtn.setEnabled(true);
                switch (state) {
                    case ConstDef.INACTIVE:
                        //fix bug 7829 by zya 20170104
                        btnDrawable = getDrawableRes(UniversalUtil.getThemeStyle(getContext()) == BasePresenterActivity
                                .THEME_DARK ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
                        mFileDateLayout.setVisibility(View.VISIBLE);
                        mFileDownloadPb.setVisibility(View.GONE);
                        mFileOutDateTv.setVisibility(View.VISIBLE);
                        //end by zya
                        break;
                    case ConstDef.LOADING://下载中
                        btnDrawable = getDrawableRes(UniversalUtil.getThemeStyle(getContext()) ==
                                BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_history_pause : R.drawable
                                .im_uikit_history_pause_light);
                        mFileDateLayout.setVisibility(View.GONE);
                        mFileDownloadPb.setVisibility(View.VISIBLE);
                        mFileOutDateTv.setVisibility(View.VISIBLE);
                        break;
                    case ConstDef.DONE://下载完成后变成查看
                        btnDrawable = getDrawableRes(UniversalUtil.getThemeStyle(getContext()) == BasePresenterActivity
                                .THEME_DARK ? R.drawable.im_uikit_history_lookup : R.drawable.im_uikit_history_lookup_light);
                        mFileDateLayout.setVisibility(View.VISIBLE);
                        mFileDownloadPb.setVisibility(View.GONE);
                        mFileOutDateTv.setVisibility(View.GONE);
                        break;
                    case ConstDef.PAUSE://暂停
                        btnDrawable = getDrawableRes(UniversalUtil.getThemeStyle(getContext()) ==
                                BasePresenterActivity.THEME_DARK ? R.drawable.im_uikit_history_resume : R.drawable
                                .im_uikit_history_resume_light);
                        mFileDateLayout.setVisibility(View.GONE);
                        mFileDownloadPb.setVisibility(View.VISIBLE);
                        mFileOutDateTv.setVisibility(View.VISIBLE);
                        break;
                    case ConstDef.FAIL://下载失败
                        btnDrawable = getDrawableRes(UniversalUtil.getThemeStyle(getContext()) == BasePresenterActivity
                                .THEME_DARK ? R.drawable.im_uikit_history_download : R.drawable.im_uikit_history_download_light);
                        mFileDateLayout.setVisibility(View.VISIBLE);
                        mFileDownloadPb.setVisibility(View.GONE);
                        mFileOutDateTv.setVisibility(View.VISIBLE);
                        break;
                }
            }
        }

        mFileDownloadBtn.setBackground(btnDrawable);
        mFileDownloadPb.setProgress(dataSource.getFileInfo().getTranslatePercent());
    }

    /**
     * 设置文件来自哪里
     */
    private void setSenderName() {
        AccountBean info;
        //fix bug 18863 by jyg start 20170831
        String senderName;
        if (dataSource.isGroupMsg()) {
            //info = getCommand().getGroupMemberInfo(dataSource.getTo(), dataSource.getFrom());
            senderName = String.format(getStringRes(R.string.im_uikit_history_file_come_from), getStringRes(R.string.im_uikit_group_chat));
            mFileFromTv.setText(senderName);
        } else {

            IMUiKitProxyImpl.getInstance().getAccount(dataSource.isMine() ? dataSource.getTo() : dataSource.getFrom(), ConstDef.CHAT_TYPE_P2P, new Subscriber<AccountBean>() {
                @Override
                public void onCompleted() {

                }

                @Override
                public void onError(Throwable e) {
                    e.printStackTrace();
                }

                @Override
                public void onNext(AccountBean accountBean) {
                    String senderName = String.format(getStringRes(dataSource.isMine() ? R.string.im_uikit_history_file_come_to :
                            R.string.im_uikit_history_file_come_from), accountBean.getDisplayName());
                    mFileFromTv.setText(senderName);
                }
            });
//            info = getCommand().getAccountBean(dataSource.isMine() ? dataSource.getTo() : dataSource.getFrom());
//            senderName = String.format(getStringRes(dataSource.isMine() ? R.string.im_uikit_history_file_come_to :
//                    R.string.im_uikit_history_file_come_from), info.getDisplayName());
        }
        //fix bug 18863 by jyg start 20170831
    }
}
