package com.xdja.im.lib.video.palyer;

import android.graphics.Bitmap;

public interface IVideoPlayCallback {


    /**
     * 视频播放完成回调
     */
    void prepareListener();

    /**
     * 播放视频进度回调
     *
     * @param pro 当前进度
     */
    void progressListener(int pro);

    /**
     * 视频播放完成回调
     */
    void completeListener();

    /**
     * 视频播放暂停回调
     */
    void pauseListener(int currentPos);

    /**
     * 视频播放恢复回调
     */
    void resumeListener(int currentPos);

    /**
     * surfaceView准备完毕
     */
    void surfacePrepareCallback();

    /**
     * 视频播放恢复回调
     */
    void surfaceDestroyListener(Bitmap currentPosBitmap);
}
