package com.xdja.im.lib.video.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

import com.xdja.im.uikit.R;


/**
 * 项目名称：            <br>
 * 类描述  ：           <br>
 * 创建时间：2017/6/22     <br>
 * 修改记录：             <br>
 *
 * @author jyg@xdja.com   <br>
 */


public class FocusView extends View {
    private float defaultRadius;
    private float focusLine;
    private float centerX; // 焦点中心点X
    private float centerY; // 焦点中心点Y
    private float radius; // 焦点选框的最小半径
    private float maxRadius; // 焦点选框的最大半径
    private int paintAlpha = 255; // 焦点选框的最大透明度
    private int paintColor = Color.WHITE;
    private final Rect rect = new Rect();
    /**
     * 焦点选框是否需要消失
     */
    private boolean isNeedDismiss = true;


    public FocusView(Context context) {
        super(context);
    }


    public FocusView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }


    private Paint mPaint;


    private void init(Context context, AttributeSet attrs) {
        // init paint
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.im_uikit_FocusView);
        int count = typedArray.getIndexCount();
        for (int i = 0; i < count; i++) {
            int id = typedArray.getIndex(i);
            if (id == R.styleable.im_uikit_FocusView_im_uikit_focusColor) {
                paintColor = typedArray.getColor(id, Color.WHITE);

            } else if (id == R.styleable.im_uikit_FocusView_im_uikit_focusDefaultRadius) {
                defaultRadius = typedArray.getFloat(id, 100);

            } else if (id == R.styleable.im_uikit_FocusView_im_uikit_focusMaxRadius) {
                maxRadius = typedArray.getFloat(id, 40);
            } else if (id == R.styleable.im_uikit_FocusView_im_uikit_focusLine) {
                focusLine = typedArray.getFloat(id, 10);
            }
        }

        typedArray.recycle();

        mPaint = new Paint();
        mPaint.setAntiAlias(true);
        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.setStrokeWidth(3);
        mPaint.setColor(paintColor);

    }


    // addGestureRecognizer UITapGestureRecognizer
    @SuppressLint("ClickableViewAccessibility")
    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN: // UIGestureRecognizerStateBegan
                mHandler.removeMessages(0);
                mHandler.removeMessages(1);
                invalidate();
                centerX = event.getX();
                centerY = event.getY();
                // 重量选框参数
                isNeedDismiss = false;
                paintAlpha = 255;
                mPaint.setAlpha(paintAlpha);
                radius = defaultRadius;
                mHandler.obtainMessage(0).sendToTarget();
                break;
            case MotionEvent.ACTION_MOVE: // UIGestureRecognizerStateChange
                break;
            case MotionEvent.ACTION_UP: // UIGestureRecognizerStateEnd
                break;
            default:
                break;
        }
        return super.onTouchEvent(event);
    }


    @SuppressLint("HandlerLeak")
    private final Handler mHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: // update size
                    radius -= 5;
                    if (radius <= maxRadius) { // 若将要绘制的尺寸大于约束的最大尺寸,则将该尺寸还原
                        radius += 5;
                        mHandler.sendEmptyMessageDelayed(1, 500); // 使选框停留500ms后逐渐消失
                    } else {
                        mHandler.sendEmptyMessageDelayed(0, (long) (radius / 200));
                        invalidate(); // setNeedDisplay
                    }
                    break;
                case 1: // update alpha
                    paintAlpha -= 20; // 当选框达到最大后,就不断改变其透明度，直至透明度为0，本次绘制过程结束
                    if (paintAlpha <= 0) {
                        isNeedDismiss = true;
                        invalidate();
                    } else {
                        mPaint.setAlpha(paintAlpha);
                        invalidate();
                        mHandler.sendEmptyMessageDelayed(1, 15);
                    }
                    break;
                default:
                    break;
            }
        }
    };

    /**
     * 设置焦点选框的初始半径
     *
     * @param radius
     */
    public void setFocusCircleRadius(float radius) {
        this.radius = radius;
    }


    /**
     * 设置焦点选框的最大半径
     *
     * @param radius
     */
    public void setFocusCircleMaxRadius(float radius) {
        this.maxRadius = radius;
    }


    /**
     * 设置焦点选框的颜色
     *
     * @param color
     */
    public void setFocusCircleColor(int color) {
        this.paintColor = color;
        mPaint.setColor(color);
    }


    // drawRect
    @Override
    protected void onDraw(Canvas canvas) {

        if (!isNeedDismiss) { // 若绘制过程结束,则清除焦点框

            rect.set((int) (centerX - radius), (int) (centerY - radius),
                    (int) (centerX + radius), (int) (centerY + radius));
            canvas.drawRect(rect, mPaint);
            canvas.drawLine((int) (centerX - radius), (int) centerY,
                    (int) (centerX - radius + focusLine), (int) centerY, mPaint);
            canvas.drawLine((int) (centerX + radius - focusLine), (int) centerY,
                    (int) (centerX + radius), (int) centerY, mPaint);

            canvas.drawLine((int) (centerX), (int) (centerY - radius),
                    (int) (centerX), (int) (centerY - radius + focusLine), mPaint);
            canvas.drawLine((int) (centerX), (int) (centerY + radius),
                    (int) (centerX), (int) (centerY + radius - focusLine), mPaint);
        }

    }
}
