package com.xdja.im.uikit.base;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntDef;
import android.support.annotation.StringRes;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.ConvertUtils;
import com.xdja.im.uikit.view.ElliTextView;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package: com.xdja.im.uikit.base
 * @Author: xdjaxa
 * @Creation: 2017-07-11 16:26
 * @Version V1.0
 * @Description:
 */
public class ImFragmentSuperView<P extends Presenter> extends FragmentSuperBaseView<P> {

    private Toolbar mToolBar;

    private ElliTextView mToolbarTitle;

    private ImageView mToolbarBack;

    protected ImageView mToolbarAdd;

    private onNavigateCallback mCallback;

    @Override
    protected void injectView() {
        super.injectView();
        mToolBar = (Toolbar) findViewById(R.id.toolbar);
        mToolbarTitle = (ElliTextView) findViewById(R.id.tv_title);
        mToolbarBack = (ImageView) findViewById(R.id.img_back);
        mToolbarAdd = (ImageView) findViewById(R.id.img_add);
    }

    /**
     * ToolBar初始化
     */
    private void initToolBar() {
        ((AppCompatActivity) getActivity()).setSupportActionBar(mToolBar);
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = getActivity().getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.setStatusBarColor(getResources().getColor(R.color.im_uikit_im_fragment_super_view_bar_color));
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            setTranslucentStatus(true);
            mToolBar.setPadding(0, getStatusBarHeight(), 0, 0);
            mToolBar.setBackgroundColor(getResources().getColor(R.color.im_uikit_im_fragment_super_view_tool_bar_color));
        }
        switch (getToolbarType()) {
            //处理导航后退
            case ToolbarDef.NAVIGATE_CUSTOM_BACK:
                break;

            case ToolbarDef.NAVIGATE_BACK:
                mToolbarBack.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mCallback != null) {
                            mCallback.onBackClick();
                        }
                        getActivity().finish();
                    }
                });
                mToolbarAdd.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mCallback != null) {
                            mCallback.onAddClick();
                        }
                    }
                });
                break;

            case ToolbarDef.NAVIGATE_DEFAULT:
                break;

            case ToolbarDef.NAVIGATE_OTHER:
                break;
        }
    }

    @TargetApi(19)
    private void setTranslucentStatus(boolean on) {
        Window win = getActivity().getWindow();
        WindowManager.LayoutParams params = getActivity().getWindow().getAttributes();
        final int bits = WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS;
        if (on) {
            params.flags |= bits;
        } else {
            params.flags &= ~bits;
        }
        win.setAttributes(params);
    }

    protected void supportActionBar(boolean isSupport) {
        if (isSupport) {
            if (mToolBar != null) {
                mToolBar.setVisibility(View.VISIBLE);
                initToolBar();
                if (getToolbarTitle() > 0) {
                    setToolBarTitle(getToolbarTitle());
                }
            }
        } else {
            if (mToolBar != null) {
                mToolBar.setVisibility(View.GONE);
            }
        }
    }

    public boolean isSupportActionBar() {
        if (mToolBar != null) {
            return mToolBar.getVisibility() == View.VISIBLE;
        }
        return false;
    }

    private int getStatusBarHeight() {
        int statusBarHeight = ConvertUtils.dp2px(getActivity(), 25);
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            int height = Integer.parseInt(clazz.getField("status_bar_height")
                    .get(object).toString());
            statusBarHeight = getActivity().getResources().getDimensionPixelSize(height);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return statusBarHeight;
    }

    protected int getToolbarTitle() {
        return -1;
    }

    /**
     * Set the title of this toolbar.
     *
     * @param resId
     */
    public void setToolBarTitle(@StringRes int resId) {
        if (mToolbarTitle != null) {
            //mToolbarTitle.setText(resId);
            mToolbarTitle.setStrText(getStringRes(resId));
        }
    }

    /**
     * Set the title of this toolbar.
     *
     * @param title
     */
    public void setToolBarTitle(CharSequence title) {
        if (mToolbarTitle != null) {
//            mToolbarTitle.setText(title);
            mToolbarTitle.setStrText(title);
        }
    }

    public void setToolBarTitleColor(@ColorRes int id) {
        if (mToolbarTitle != null) {
            mToolbarTitle.setTextColor(getResources().getColor(id));
        }
    }

    public void setToolBarAddVisible(boolean isShow){
        if (mToolbarAdd != null) {
            mToolbarAdd.setVisibility(isShow ? View.VISIBLE : View.INVISIBLE);
        }
    }

    public void setToolBarAddImage(@DrawableRes int id){
        if (mToolbarAdd != null) {
            mToolbarAdd.setImageResource(id);
        }
    }

    /**
     * 设置回调事件
     *
     * @param callback
     */
    public void setNavigateCallback(onNavigateCallback callback) {
        this.mCallback = callback;
    }

    /**
     * 获得导航显示方式
     *
     * @return 显示方式
     */
    @ToolbarDef.NavigateType
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_DEFAULT;
    }

    public static class ToolbarDef {
        /**
         * 导航显示为后退
         */
        public final static int NAVIGATE_BACK = 0;
        /**
         * 默认导航
         */
        public final static int NAVIGATE_DEFAULT = 1;
        /**
         * 未知，留待扩展
         */
        public final static int NAVIGATE_OTHER = 2;

        /**
         * 自定义的带返回键和一个标题和一个菜单的导航
         */
        public final static int NAVIGATE_CUSTOM_BACK = 3;

        /**
         * 导航显示类型
         */
        @Retention(RetentionPolicy.SOURCE)
        @IntDef({NAVIGATE_BACK, NAVIGATE_DEFAULT, NAVIGATE_OTHER, NAVIGATE_CUSTOM_BACK})
        public @interface NavigateType {
        }
    }

    /**
     * ToolBar回调事件
     */
    public interface onNavigateCallback {

        /**
         * 返回点击回调事件
         */
        void onBackClick();

        /**
         * 添加点击回调事件
         */
        void onAddClick();
    }

}
